/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.draft;

import java.util.List;
import java.util.Vector;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataIndexer;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;

public class DraftMetadataIndexer
extends BaseMetadataIndexer
implements IMetadataIndexer {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;

    @Override
    public void init(ServiceContext context) throws Exception {
        super.init(context);
        this.metadataDraftRepository = context.getBean(MetadataDraftRepository.class);
    }

    @Override
    protected void addExtraFields(AbstractMetadata fullMd, Vector<Element> moreFields) {
        super.addExtraFields(fullMd, moreFields);
        if (fullMd instanceof MetadataDraft) {
            Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a draft with uuid " + fullMd.getUuid()));
            moreFields.addElement(SearchManager.makeField("_draft", "y", true, true));
        } else {
            MetadataDraft metadataDraft = this.metadataDraftRepository.findOneByUuid(fullMd.getUuid());
            if (metadataDraft != null) {
                MetadataStatus stat;
                Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with a draft associated with uuid " + fullMd.getUuid()));
                moreFields.addElement(SearchManager.makeField("_draft", "e", true, true));
                String status = "";
                String statusDraft = "";
                Sort statusSort = new Sort(Sort.Direction.DESC, new String[]{MetadataStatus_.changeDate.getName()});
                List statuses = this.statusRepository.findAllByMetadataIdAndByType(fullMd.getId(), StatusValueType.workflow, statusSort);
                if (!statuses.isEmpty()) {
                    stat = (MetadataStatus)statuses.get(0);
                    status = String.valueOf(stat.getStatusValue().getId());
                }
                if (!(statuses = this.statusRepository.findAllByMetadataIdAndByType(metadataDraft.getId(), StatusValueType.workflow, statusSort)).isEmpty()) {
                    stat = (MetadataStatus)statuses.get(0);
                    statusDraft = String.valueOf(stat.getStatusValue().getId());
                }
                moreFields.add(SearchManager.makeField("_statusWorkflow", status + statusDraft, true, true));
            } else {
                Log.trace((String)"geonetwork.datamanager", (Object)("We are indexing a record with no draft associated with uuid " + fullMd.getUuid()));
                moreFields.addElement(SearchManager.makeField("_draft", "n", true, true));
                Sort statusSort = new Sort(Sort.Direction.DESC, new String[]{MetadataStatus_.changeDate.getName()});
                List statuses = this.statusRepository.findAllByMetadataIdAndByType(fullMd.getId(), StatusValueType.workflow, statusSort);
                if (!statuses.isEmpty()) {
                    MetadataStatus stat = (MetadataStatus)statuses.get(0);
                    String status = String.valueOf(stat.getStatusValue().getId());
                    moreFields.add(SearchManager.makeField("_statusWorkflow", status, true, true));
                }
            }
        }
    }
}

