/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.exceptions.TermNotFoundException;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.rdf.Query;
import org.fao.geonet.kernel.rdf.QueryBuilder;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.rdf.Wheres;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.util.LangUtils;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.GraphException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.DummyAdminListener;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.memory.RdfSchemaRepositoryConfig;
import org.springframework.context.ApplicationContext;

public class Thesaurus {
    private static final String DEFAULT_THESAURUS_NAMESPACE = "https://registry.geonetwork-opensource.org/concept#";
    private String fname;
    private String type;
    private String dname;
    private Path thesaurusFile;
    private LocalRepository repository;
    private String title;
    private String date;
    private String createdDate;
    private String issuedDate;
    private String modifiedDate;
    private String defaultNamespace;
    private String downloadUrl;
    private String keywordUrl;
    private IsoLanguagesMapper isoLanguageMapper;
    private Map<String, String> multilingualTitles = new Hashtable<String, String>();
    private Map<String, Map<String, String>> dublinCoreMultilingual = new Hashtable<String, Map<String, String>>();

    protected Thesaurus() {
    }

    public Thesaurus(IsoLanguagesMapper isoLanguageMapper, String fname, String type, String dname, Path thesaurusFile, String siteUrl) {
        this(isoLanguageMapper, fname, null, null, type, dname, thesaurusFile, siteUrl, false);
    }

    public Thesaurus(IsoLanguagesMapper isoLanguageMapper, String fname, String tname, String tnamespace, String type, String dname, Path thesaurusFile, String siteUrl, boolean ignoreMissingError) {
        this.isoLanguageMapper = isoLanguageMapper;
        this.fname = fname;
        this.type = type;
        this.dname = dname;
        this.thesaurusFile = thesaurusFile;
        if (!siteUrl.endsWith("/")) {
            siteUrl = siteUrl + '/';
        }
        this.downloadUrl = this.buildDownloadUrl(fname, type, dname, siteUrl);
        this.keywordUrl = this.buildKeywordUrl(fname, type, dname, siteUrl);
        this.defaultNamespace = StringUtils.isEmpty((String)tnamespace) ? this.buildThesaurusNamespace() : tnamespace;
        this.defaultNamespace = this.defaultNamespace;
        if (tname != null) {
            this.title = tname;
        } else {
            this.retrieveThesaurusTitle(thesaurusFile, dname + "." + fname, ignoreMissingError);
        }
    }

    public static String buildThesaurusKey(String fname, String type, String dname) {
        String name = fname;
        if (name.endsWith(".rdf")) {
            name = name.substring(0, fname.indexOf(".rdf"));
        }
        return type + "." + dname + "." + name;
    }

    public Map<String, String> getMultilingualTitles() {
        return Collections.unmodifiableMap(this.multilingualTitles);
    }

    public Map<String, Map<String, String>> getDublinCoreMultilingual() {
        return Collections.unmodifiableMap(this.dublinCoreMultilingual);
    }

    public String getKey() {
        return Thesaurus.buildThesaurusKey(this.fname, this.type, this.dname);
    }

    public String getDname() {
        return this.dname;
    }

    public String getFname() {
        return this.fname;
    }

    public Path getFile() {
        return this.thesaurusFile;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDate() {
        return this.date;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getIssuedDate() {
        return this.issuedDate;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    @Nonnull
    public FileTime getLastModifiedTime() {
        FileTime lastModified;
        try {
            lastModified = Files.getLastModifiedTime(this.getFile(), new LinkOption[0]);
        }
        catch (IOException e) {
            lastModified = FileTime.fromMillis(System.currentTimeMillis());
        }
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)(this.title + " has lastModified of: " + lastModified.toMillis()));
        }
        return lastModified;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getKeywordUrl() {
        return this.keywordUrl;
    }

    public void retrieveThesaurusTitle() {
        this.retrieveThesaurusTitle(this.thesaurusFile, this.dname + "." + this.fname, false);
    }

    private String buildApiPath(String path, String key) {
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        return String.format(path, settingManager.getNodeURL(), key);
    }

    private String buildThesaurusNamespace() {
        return this.buildApiPath("%sapi/registries/vocabularies/%s", this.getKey());
    }

    protected String buildDownloadUrl(String fname, String type, String dname, String siteUrl) {
        return this.buildApiPath("%sapi/registries/vocabularies/%s", type.equals("register") ? fname.substring(0, fname.indexOf(".rdf")) : Thesaurus.buildThesaurusKey(fname, type, dname));
    }

    protected String buildKeywordUrl(String fname, String type, String dname, String siteUrl) {
        return this.buildApiPath("%sapi/registries/vocabularies/keyword?thesaurus=%s&amp;id=", Thesaurus.buildThesaurusKey(fname, type, dname));
    }

    public synchronized LocalRepository getRepository() {
        return this.repository;
    }

    public synchronized Thesaurus setRepository(LocalRepository repository) {
        this.repository = repository;
        return this;
    }

    public synchronized Thesaurus initRepository() throws ConfigurationException, IOException {
        RepositoryConfig repConfig = new RepositoryConfig(this.getKey());
        SailConfig syncSail = new SailConfig("org.openrdf.sesame.sailimpl.sync.SyncRdfSchemaRepository");
        RdfSchemaRepositoryConfig memSail = new RdfSchemaRepositoryConfig(this.getFile().toString(), RDFFormat.RDFXML);
        repConfig.addSail(syncSail);
        repConfig.addSail((SailConfig)memSail);
        repConfig.setWorldReadable(true);
        repConfig.setWorldWriteable(true);
        LocalRepository thesaurusRepository = Sesame.getService().createRepository(repConfig);
        this.setRepository(thesaurusRepository);
        return this;
    }

    public synchronized QueryResultsTable performRequest(String query) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
            Log.debug((String)"geonetwork.thesaurus", (Object)("Query : " + query));
        }
        return this.repository.performTableQuery(QueryLanguage.SERQL, query);
    }

    public boolean hasConceptScheme(String uri) {
        String query = "SELECT conceptScheme FROM {conceptScheme} rdf:type {skos:ConceptScheme} WHERE conceptScheme = <" + uri + "> USING NAMESPACE skos = <http://www.w3.org/2004/02/skos/core#>";
        try {
            return this.performRequest(query).getRowCount() > 0;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.thesaurus-man", (Object)("Error retrieving concept scheme for " + this.thesaurusFile + ". Error is: " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public List<String> getConceptSchemes() {
        String query = "SELECT conceptScheme FROM {conceptScheme} rdf:type {skos:ConceptScheme} USING NAMESPACE skos = <http://www.w3.org/2004/02/skos/core#>";
        try {
            ArrayList<String> ret = new ArrayList<String>();
            QueryResultsTable table = this.performRequest(query);
            for (int i = 0; i < table.getRowCount(); ++i) {
                Value value = table.getValue(i, 0);
                ret.add(value.toString());
            }
            return ret;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.thesaurus-man", (Object)("Error retrieving concept schemes for " + this.thesaurusFile + ". Error is: " + e.getMessage()));
            return Collections.EMPTY_LIST;
        }
    }

    private void printResultsTable(QueryResultsTable resultsTable) {
        int rowCount = resultsTable.getRowCount();
        int columnCount = resultsTable.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                Value value = resultsTable.getValue(row, column);
                if (value != null) {
                    System.out.print(value.toString());
                } else {
                    System.out.print("null");
                }
                System.out.print("\t");
            }
        }
    }

    public synchronized URI addElement(KeywordBean keyword) throws IOException, AccessDeniedException, GraphException {
        GraphImpl myGraph = new GraphImpl();
        ValueFactory myFactory = myGraph.getValueFactory();
        String namespaceSkos = "http://www.w3.org/2004/02/skos/core#";
        String namespaceGml = "http://www.opengis.net/gml#";
        URI mySubject = myFactory.createURI(keyword.getUriCode());
        URI skosClass = myFactory.createURI(namespaceSkos, "Concept");
        URI rdfType = myFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        URI predicatePrefLabel = myFactory.createURI(namespaceSkos, "prefLabel");
        URI predicateScopeNote = myFactory.createURI(namespaceSkos, "scopeNote");
        URI predicateBoundedBy = myFactory.createURI(namespaceGml, "BoundedBy");
        URI predicateEnvelope = myFactory.createURI(namespaceGml, "Envelope");
        URI predicateSrsName = myFactory.createURI(namespaceGml, "srsName");
        URI srsNameURI = myFactory.createURI("http://www.opengis.net/gml/srs/epsg.xml#epsg:4326");
        BNode gmlNode = myFactory.createBNode();
        URI predicateLowerCorner = myFactory.createURI(namespaceGml, "lowerCorner");
        URI predicateUpperCorner = myFactory.createURI(namespaceGml, "upperCorner");
        Literal lowerCorner = myFactory.createLiteral(keyword.getCoordWest() + " " + keyword.getCoordSouth());
        Literal upperCorner = myFactory.createLiteral(keyword.getCoordEast() + " " + keyword.getCoordNorth());
        mySubject.addProperty(rdfType, (Value)skosClass);
        Set<Map.Entry<String, String>> values = keyword.getValues().entrySet();
        for (Map.Entry<String, String> entry : values) {
            String language = this.toiso639_1_Lang(entry.getKey());
            Literal valueObj = myFactory.createLiteral(entry.getValue(), language);
            myGraph.add((Resource)mySubject, predicatePrefLabel, (Value)valueObj);
        }
        Set<Map.Entry<String, String>> definitions = keyword.getDefinitions().entrySet();
        for (Map.Entry<String, String> entry : definitions) {
            String language = this.toiso639_1_Lang(entry.getKey());
            Literal definitionObj = myFactory.createLiteral(entry.getValue(), language);
            myGraph.add((Resource)mySubject, predicateScopeNote, (Value)definitionObj);
        }
        myGraph.add((Resource)mySubject, predicateBoundedBy, (Value)gmlNode);
        gmlNode.addProperty(rdfType, (Value)predicateEnvelope);
        myGraph.add((Resource)gmlNode, predicateLowerCorner, (Value)lowerCorner);
        myGraph.add((Resource)gmlNode, predicateUpperCorner, (Value)upperCorner);
        myGraph.add((Resource)gmlNode, predicateSrsName, (Value)srsNameURI);
        this.repository.addGraph((Graph)myGraph);
        return mySubject;
    }

    public synchronized Thesaurus removeElement(KeywordBean keyword) throws MalformedQueryException, QueryEvaluationException, IOException, AccessDeniedException {
        String namespace = keyword.getNameSpaceCode();
        String code = keyword.getRelativeCode();
        return this.removeElement(namespace, code);
    }

    public synchronized Thesaurus removeElement(String namespace, String code) throws AccessDeniedException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        URI subject = myFactory.createURI(namespace, code);
        return this.removeElement(myGraph, subject);
    }

    public synchronized Thesaurus removeElement(String uri) throws AccessDeniedException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        URI subject = myFactory.createURI(uri);
        return this.removeElement(myGraph, subject);
    }

    private Thesaurus removeElement(Graph myGraph, URI subject) throws AccessDeniedException {
        StatementIterator iter = myGraph.getStatements((Resource)subject, null, null);
        while (iter.hasNext()) {
            AtomicReference<Statement> st = new AtomicReference<Statement>(iter.next());
            if (!(st.get().getObject() instanceof BNode)) continue;
            BNode node = (BNode)st.get().getObject();
            this.repository.getGraph().remove((Resource)node, null, null);
        }
        int removedItems = myGraph.remove((Resource)subject, null, null);
        if (Log.isDebugEnabled((String)"geonetwork.thesaurus")) {
            String msg = "Removed " + removedItems + " elements from thesaurus " + this.title + " with uri: " + subject;
            Log.debug((String)"geonetwork.thesaurus", (Object)msg);
        }
        return this;
    }

    private String toiso639_1_Lang(String lang) {
        String defaultCode = this.getIsoLanguageMapper().iso639_2_to_iso639_1("eng", "eng".substring(0, 2));
        return this.getIsoLanguageMapper().iso639_2_to_iso639_1(lang, defaultCode);
    }

    public synchronized URI updateElement(KeywordBean keyword, boolean replace) throws AccessDeniedException, IOException, MalformedQueryException, QueryEvaluationException, GraphException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        String namespaceSkos = "http://www.w3.org/2004/02/skos/core#";
        URI predicatePrefLabel = myFactory.createURI(namespaceSkos, "prefLabel");
        URI predicateScopeNote = myFactory.createURI(namespaceSkos, "scopeNote");
        URI subject = myFactory.createURI(keyword.getUriCode());
        StatementIterator iter = myGraph.getStatements((Resource)subject, predicatePrefLabel, null);
        this.removeMatchingLiterals(replace, myGraph, iter, keyword.getValues().keySet());
        iter = myGraph.getStatements((Resource)subject, predicateScopeNote, null);
        this.removeMatchingLiterals(replace, myGraph, iter, keyword.getDefinitions().keySet());
        Set<Map.Entry<String, String>> values = keyword.getValues().entrySet();
        for (Map.Entry<String, String> entry : values) {
            String string = this.toiso639_1_Lang(entry.getKey());
            Literal valueObj = myFactory.createLiteral(entry.getValue(), string);
            myGraph.add((Resource)subject, predicatePrefLabel, (Value)valueObj);
        }
        Set<Map.Entry<String, String>> definitions = keyword.getDefinitions().entrySet();
        for (Map.Entry<String, String> entry : definitions) {
            String language = this.toiso639_1_Lang(entry.getKey());
            Literal definitionObj = myFactory.createLiteral(entry.getValue(), language);
            myGraph.add((Resource)subject, predicateScopeNote, (Value)definitionObj);
        }
        if (replace || !(keyword.getCoordEast() + keyword.getCoordNorth() + keyword.getCoordWest() + keyword.getCoordSouth()).trim().isEmpty()) {
            AtomicReference<Statement> st;
            String string = "http://www.opengis.net/gml#";
            URI uRI = myFactory.createURI(string, "BoundedBy");
            URI predicateLowerCorner = myFactory.createURI(string, "lowerCorner");
            URI predicateUpperCorner = myFactory.createURI(string, "upperCorner");
            BNode subjectGml = null;
            iter = myGraph.getStatements((Resource)subject, uRI, null);
            while (iter.hasNext()) {
                st = new AtomicReference<Statement>(iter.next());
                if (!(st.get().getObject() instanceof BNode)) continue;
                subjectGml = (BNode)st.get().getObject();
            }
            if (subjectGml != null) {
                iter = myGraph.getStatements(subjectGml, predicateLowerCorner, null);
                if (iter.hasNext()) {
                    st = new AtomicReference<Statement>(iter.next());
                    myGraph.remove(st.get());
                }
                iter = myGraph.getStatements(subjectGml, predicateUpperCorner, null);
                if (iter.hasNext()) {
                    st = new AtomicReference<Statement>(iter.next());
                    myGraph.remove(st.get());
                }
                Literal lowerCorner = myFactory.createLiteral(keyword.getCoordWest() + " " + keyword.getCoordSouth());
                Literal upperCorner = myFactory.createLiteral(keyword.getCoordEast() + " " + keyword.getCoordNorth());
                myGraph.add((Resource)subjectGml, predicateLowerCorner, (Value)lowerCorner);
                myGraph.add((Resource)subjectGml, predicateUpperCorner, (Value)upperCorner);
            }
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMatchingLiterals(boolean replace, Graph myGraph, StatementIterator iter, Set<String> valueLanguages) {
        try {
            ArrayList<Statement> toRemove = new ArrayList<Statement>();
            while (iter.hasNext()) {
                Statement st = iter.next();
                if (!(st.getObject() instanceof Literal)) continue;
                Literal litt = (Literal)st.getObject();
                String lang = this.getIsoLanguageMapper().iso639_1_to_iso639_2(litt.getLanguage(), "eng");
                if (!replace && !valueLanguages.contains(lang)) continue;
                toRemove.add(st);
            }
            for (Statement statement : toRemove) {
                myGraph.remove(statement);
            }
        }
        finally {
            iter.close();
        }
    }

    public synchronized boolean isFreeCode(String namespace, String code) throws AccessDeniedException {
        boolean res = true;
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        URI obj = namespace == null ? myFactory.createURI(code) : myFactory.createURI(namespace, code);
        Collection statementsCollection = myGraph.getStatementCollection((Resource)obj, null, null);
        if (statementsCollection != null && statementsCollection.size() > 0) {
            res = false;
        }
        if ((statementsCollection = myGraph.getStatementCollection(null, null, (Value)obj)) != null && statementsCollection.size() > 0) {
            res = false;
        }
        return res;
    }

    public Thesaurus updateCode(KeywordBean bean, String newcode) throws AccessDeniedException, IOException {
        return this.updateCode(bean.getNameSpaceCode(), bean.getRelativeCode(), newcode);
    }

    public synchronized Thesaurus updateCode(String namespace, String oldcode, String newcode) throws AccessDeniedException, IOException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        URI oldobj = myFactory.createURI(namespace, oldcode);
        URI newobj = myFactory.createURI(namespace, newcode);
        return this.updateElementCode(myGraph, oldobj, newobj);
    }

    public synchronized Thesaurus updateCodeByURI(String olduri, String newuri) throws AccessDeniedException, IOException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        URI oldobj = myFactory.createURI(olduri);
        URI newobj = myFactory.createURI(newuri);
        return this.updateElementCode(myGraph, oldobj, newobj);
    }

    private Thesaurus updateElementCode(Graph myGraph, URI oldobj, URI newobj) {
        StatementIterator iterStSubject = myGraph.getStatements((Resource)oldobj, null, null);
        while (iterStSubject.hasNext()) {
            AtomicReference<Statement> st = new AtomicReference<Statement>(iterStSubject.next());
            myGraph.add((Resource)newobj, st.get().getPredicate(), st.get().getObject());
        }
        StatementIterator iterStObject = myGraph.getStatements(null, null, (Value)oldobj);
        while (iterStObject.hasNext()) {
            Statement st = iterStObject.next();
            myGraph.add(st.getSubject(), st.getPredicate(), (Value)newobj);
        }
        myGraph.remove((Resource)oldobj, null, null);
        myGraph.remove(null, null, (Value)oldobj);
        return this;
    }

    public void addTitleElement(String thesaurusTitle) throws IOException, AccessDeniedException, GraphException {
        GraphImpl myGraph = new GraphImpl();
        ValueFactory myFactory = myGraph.getValueFactory();
        String namespaceSkos = "http://www.w3.org/2004/02/skos/core#";
        String namespaceDC = "http://purl.org/dc/elements/1.1/";
        URI mySubject = myFactory.createURI(this.getDefaultNamespace());
        URI skosClass = myFactory.createURI(namespaceSkos, "ConceptScheme");
        URI titleURI = myFactory.createURI(namespaceDC, "title");
        URI rdfType = myFactory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        mySubject.addProperty(rdfType, (Value)skosClass);
        Literal valueObj = myFactory.createLiteral(thesaurusTitle);
        myGraph.add((Resource)mySubject, titleURI, (Value)valueObj);
        this.repository.addGraph((Graph)myGraph);
    }

    private void retrieveDublinCore(Element thesaurusEl) {
        ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
        theNSs.add(Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        theNSs.add(Namespace.getNamespace((String)"skos", (String)"http://www.w3.org/2004/02/skos/core#"));
        theNSs.add(Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/"));
        theNSs.add(Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/"));
        Namespace xmlNS = Namespace.getNamespace((String)"xml", (String)"http://www.w3.org/XML/1998/namespace");
        try {
            List multiLingualTitles = Xml.selectNodes((Element)thesaurusEl, (String)"skos:ConceptScheme/dc:*[@xml:lang]|skos:ConceptScheme/dcterms:*[@xml:lang]", theNSs);
            this.dublinCoreMultilingual.clear();
            for (Element el : multiLingualTitles) {
                String lang = this.isoLanguageMapper.iso639_2_to_iso639_1(el.getAttribute("lang", xmlNS).getValue());
                String value = el.getTextTrim();
                String name = el.getName();
                if (!this.dublinCoreMultilingual.containsKey(lang)) {
                    this.dublinCoreMultilingual.put(lang, new HashMap());
                }
                this.dublinCoreMultilingual.get(lang).put(name, value);
                boolean bl = false;
            }
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.thesaurus", (Object)"error extracting multilingual dublin core items from thesaurus", (Throwable)e);
        }
    }

    private void retrieveMultiLingualTitles(Element thesaurusEl) {
        ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
        theNSs.add(Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        theNSs.add(Namespace.getNamespace((String)"skos", (String)"http://www.w3.org/2004/02/skos/core#"));
        theNSs.add(Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/"));
        theNSs.add(Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/"));
        Namespace xmlNS = Namespace.getNamespace((String)"xml", (String)"http://www.w3.org/XML/1998/namespace");
        try {
            List multiLingualTitles = Xml.selectNodes((Element)thesaurusEl, (String)"skos:ConceptScheme/dc:title[@xml:lang]|skos:ConceptScheme/dcterms:title[@xml:lang]", theNSs);
            this.multilingualTitles.clear();
            for (Element el : multiLingualTitles) {
                String lang = this.isoLanguageMapper.iso639_2_to_iso639_1(el.getAttribute("lang", xmlNS).getValue());
                String title = el.getTextTrim();
                this.multilingualTitles.put(lang, title);
            }
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.thesaurus", (Object)"error extracting multilingual titles from thesaurus", (Throwable)e);
        }
    }

    private void retrieveThesaurusTitle(Path thesaurusFile, String defaultTitle, boolean ignoreMissingError) {
        block16: {
            this.title = defaultTitle;
            try {
                Element thesaurusEl = Xml.loadFile((Path)thesaurusFile);
                ArrayList<Namespace> theNSs = new ArrayList<Namespace>();
                Namespace rdfNamespace = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                theNSs.add(rdfNamespace);
                theNSs.add(Namespace.getNamespace((String)"skos", (String)"http://www.w3.org/2004/02/skos/core#"));
                theNSs.add(Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/"));
                theNSs.add(Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/"));
                this.defaultNamespace = null;
                this.retrieveMultiLingualTitles(thesaurusEl);
                this.retrieveDublinCore(thesaurusEl);
                Element title = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dc:title|skos:ConceptScheme/dcterms:title|skos:Collection/dc:title|skos:Collection/dcterms:title|rdf:Description/dc:title|rdf:Description/dcterms:title", theNSs);
                if (title != null) {
                    this.title = title.getValue();
                    this.defaultNamespace = title.getParentElement().getAttributeValue("about", rdfNamespace);
                } else {
                    this.title = defaultTitle;
                    this.defaultNamespace = DEFAULT_THESAURUS_NAMESPACE;
                }
                try {
                    new java.net.URI(this.defaultNamespace);
                }
                catch (Exception e) {
                    this.defaultNamespace = DEFAULT_THESAURUS_NAMESPACE;
                }
                Element issuedDateEl = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dcterms:issued", theNSs);
                this.issuedDate = issuedDateEl == null ? "" : issuedDateEl.getText();
                Element modifiedDateEl = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dcterms:modified", theNSs);
                this.modifiedDate = modifiedDateEl == null ? "" : modifiedDateEl.getText();
                Element createdDateEl = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dcterms:created", theNSs);
                this.createdDate = createdDateEl == null ? "" : createdDateEl.getText();
                Element dateEl = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dcterms:issued|skos:Collection/dc:date", theNSs);
                Date thesaususDate = this.parseThesaurusDate(dateEl);
                if (thesaususDate == null) {
                    dateEl = Xml.selectElement((Element)thesaurusEl, (String)"skos:ConceptScheme/dcterms:modified", theNSs);
                    thesaususDate = this.parseThesaurusDate(dateEl);
                }
                if (thesaususDate != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    this.date = df.format(thesaususDate);
                }
                FileTime lastModifiedTime = null;
                if (this.date != null) {
                    try {
                        lastModifiedTime = FileTime.fromMillis(ISODate.parseBasicOrFullDateTime((String)this.date).toDate().getTime());
                    }
                    catch (IOException e) {
                        Log.warning((String)"geonetwork.thesaurus", (Object)("Unable to parse " + this.date + " into an actual java.util.Date object"), (Throwable)e);
                    }
                }
                if (lastModifiedTime == null) {
                    try {
                        lastModifiedTime = Files.getLastModifiedTime(thesaurusFile, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        lastModifiedTime = FileTime.fromMillis(new Date().getTime());
                    }
                    if (this.date == null) {
                        this.date = new ISODate(lastModifiedTime.toMillis(), true).toString();
                    }
                }
                if (Log.isDebugEnabled((String)"geonetwork.thesaurus-man")) {
                    Log.debug((String)"geonetwork.thesaurus-man", (Object)("Thesaurus information: " + this.title + " (" + this.date + ")"));
                }
            }
            catch (Exception ex) {
                if (ignoreMissingError) break block16;
                Log.error((String)"geonetwork.thesaurus-man", (Object)("Error getting thesaurus info for " + thesaurusFile + ". Error is: " + ex.getMessage()));
            }
        }
    }

    private Date parseThesaurusDate(Element dateEl) {
        Date thesaurusDate = null;
        if (dateEl == null) {
            return thesaurusDate;
        }
        String dateVal = dateEl.getText();
        ArrayList<SimpleDateFormat> dfList = new ArrayList<SimpleDateFormat>();
        dfList.add(new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"));
        dfList.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        dfList.add(new SimpleDateFormat("yyyy-MM-dd"));
        dfList.add(new SimpleDateFormat("yyyy-MM"));
        dfList.add(new SimpleDateFormat("yyyy"));
        StringBuffer errorMsg = new StringBuffer("Error parsing the thesaurus date value: ");
        errorMsg.append(dateVal);
        boolean success = false;
        for (SimpleDateFormat df : dfList) {
            try {
                thesaurusDate = df.parse(dateVal);
                success = true;
            }
            catch (Exception ex) {
                errorMsg.append("\n  * with format: ");
                errorMsg.append(df.toPattern());
                errorMsg.append(". Error is: ");
                errorMsg.append(ex.getMessage());
            }
        }
        if (!success) {
            errorMsg.append("\nCheck thesaurus date in ");
            errorMsg.append(this.fname);
            Log.error((String)"geonetwork.thesaurus-man", (Object)errorMsg.toString());
        }
        return thesaurusDate;
    }

    protected void finalize() {
        if (this.repository != null) {
            this.repository.shutDown();
        }
    }

    public IsoLanguagesMapper getIsoLanguageMapper() {
        return this.isoLanguageMapper;
    }

    public synchronized void addRelation(String subject, KeywordRelation related, String relatedSubject) throws AccessDeniedException, IOException, MalformedQueryException, QueryEvaluationException, GraphException {
        Graph myGraph = this.repository.getGraph();
        ValueFactory myFactory = myGraph.getValueFactory();
        String namespaceSkos = "http://www.w3.org/2004/02/skos/core#";
        URI relationURI = myFactory.createURI(namespaceSkos, related.name);
        URI opposteRelationURI = myFactory.createURI(namespaceSkos, related.opposite().name);
        URI subjectURI = myFactory.createURI(subject);
        URI relatedSubjectURI = myFactory.createURI(relatedSubject);
        myGraph.add((Resource)subjectURI, relationURI, (Value)relatedSubjectURI);
        myGraph.add((Resource)relatedSubjectURI, opposteRelationURI, (Value)subjectURI);
    }

    public KeywordBean getKeyword(String uri, String ... languages) {
        List<KeywordBean> keywords;
        try {
            Query<KeywordBean> query = QueryBuilder.keywordQueryBuilder(this.getIsoLanguageMapper(), languages).where(Wheres.ID(uri)).build();
            keywords = query.execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (keywords.isEmpty()) {
            throw new TermNotFoundException(this.getTermNotFoundMessage(uri));
        }
        return keywords.get(0);
    }

    public List<KeywordBean> getTopConcepts(String ... languages) {
        List<KeywordBean> keywords;
        try {
            Query<KeywordBean> query = QueryBuilder.keywordQueryBuilder(this.getIsoLanguageMapper(), languages).select(Selectors.TOPCONCEPTS, true).build();
            keywords = query.execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (keywords.isEmpty()) {
            throw new TermNotFoundException("No top concepts/keywords in file " + this.thesaurusFile);
        }
        return keywords;
    }

    private String getTermNotFoundMessage(String searchValue) {
        return "Could not find " + searchValue + " in file " + this.thesaurusFile;
    }

    public boolean hasKeyword(String uri) {
        try {
            this.getKeyword(uri, new String[0]);
        }
        catch (TermNotFoundException e) {
            return false;
        }
        return true;
    }

    public List<KeywordBean> getBroader(String uri, String ... languages) {
        return this.getRelated(uri, KeywordRelation.NARROWER, languages);
    }

    public boolean hasBroader(String uri) {
        return this.getRelated(uri, KeywordRelation.NARROWER, new String[0]).size() > 0;
    }

    public List<KeywordBean> getRelated(String uri, KeywordRelation request, String ... languages) {
        Query<KeywordBean> query = QueryBuilder.keywordQueryBuilder(this.getIsoLanguageMapper(), languages).select(Selectors.related(uri, request), true).build();
        try {
            return query.execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasKeywordWithLabel(String label, String langCode) {
        try {
            this.getKeywordWithLabel(label, langCode);
        }
        catch (TermNotFoundException e) {
            return false;
        }
        return true;
    }

    public KeywordBean getKeywordWithLabel(String label, String langCode) {
        List<KeywordBean> matchingKeywords;
        Query<KeywordBean> query = QueryBuilder.keywordQueryBuilder(this.getIsoLanguageMapper(), langCode).where(Wheres.prefLabel(langCode, label)).build();
        try {
            matchingKeywords = query.execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (matchingKeywords.size() == 0) {
            throw new TermNotFoundException(label);
        }
        return matchingKeywords.get(0);
    }

    URI addElement(String code, String prefLab, String note, String lang) throws GraphException, IOException, AccessDeniedException {
        KeywordBean bean = new KeywordBean(this.getIsoLanguageMapper()).setUriCode(code).setValue(prefLab, lang).setDefinition(note, lang);
        return this.addElement(bean);
    }

    URI addElement(String code, String prefLab, String note, String east, String west, String south, String north, String lang) throws IOException, AccessDeniedException, GraphException {
        return this.addElement(new KeywordBean(this.getIsoLanguageMapper()).setUriCode(code).setValue(prefLab, lang).setDefinition(note, lang).setCoordEast(east).setCoordNorth(north).setCoordSouth(south).setCoordWest(west));
    }

    URI updateElement(String namespace, String id, String prefLab, String note, String lang) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException, GraphException {
        KeywordBean keyword = new KeywordBean(this.getIsoLanguageMapper()).setNamespaceCode(namespace).setRelativeCode(id).setValue(prefLab, lang).setDefinition(note, lang);
        return this.updateElement(keyword, false);
    }

    URI updateElement(String namespace, String id, String prefLab, String note, String east, String west, String south, String north, String lang) throws AccessDeniedException, IOException, MalformedQueryException, QueryEvaluationException, GraphException {
        KeywordBean bean = new KeywordBean(this.getIsoLanguageMapper()).setNamespaceCode(namespace).setRelativeCode(id).setValue(prefLab, lang).setDefinition(note, lang).setCoordEast(east).setCoordNorth(north).setCoordSouth(south).setCoordWest(west);
        return this.updateElement(bean, true);
    }

    public synchronized void clear() throws IOException, AccessDeniedException {
        DummyAdminListener listener = new DummyAdminListener();
        this.repository.clear((AdminListener)listener);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Map<String, String> getTitles(ApplicationContext context) throws JDOMException, IOException {
        return LangUtils.translate(context, this.getKey());
    }
}

