/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.util.Properties;
import jeeves.server.overrides.AddPropertyUpdater;
import jeeves.server.overrides.BeanUpdater;
import jeeves.server.overrides.ConfigurationOverrides;
import jeeves.server.overrides.RefValueLoader;
import jeeves.server.overrides.SetPropertyUpdater;
import jeeves.server.overrides.ValueLoader;
import jeeves.server.overrides.ValueValueLoader;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

abstract class PropertyUpdater
extends BeanUpdater {
    protected ValueLoader valueLoader;
    protected String propertyName;

    PropertyUpdater() {
    }

    public static PropertyUpdater create(Element element) {
        ValueLoader valueLoader;
        PropertyUpdater updater;
        if ("set".equalsIgnoreCase(element.getName())) {
            updater = new SetPropertyUpdater();
        } else if ("add".equalsIgnoreCase(element.getName())) {
            updater = new AddPropertyUpdater();
        } else {
            throw new IllegalArgumentException(element.getName() + " is not known type of updater");
        }
        updater.setBeanName(element);
        super.setPropertyName(element.getAttributeValue("property"));
        if (element.getAttributeValue("ref") != null) {
            valueLoader = new RefValueLoader(element.getAttributeValue("ref"));
        } else if (element.getAttributeValue("value") != null) {
            valueLoader = new ValueValueLoader(element.getAttributeValue("value"));
        } else {
            throw new IllegalArgumentException(Xml.getString((Element)element) + " does not have a value associated with it that is recognized. Excepted ref or value attribute");
        }
        super.setSetValueLoader(valueLoader);
        return updater;
    }

    @Override
    public void update(ConfigurableListableBeanFactory beanFactory, Properties properties, BeanDefinition bean) {
        Object value = this.valueLoader.load((ConfigurableBeanFactory)beanFactory, properties);
        if (value instanceof String) {
            String string = (String)value;
            value = ConfigurationOverrides.DEFAULT.updatePropertiesInText(properties, string);
        }
        this.doUpdate(beanFactory, bean, value);
    }

    protected abstract void doUpdate(ConfigurableListableBeanFactory var1, BeanDefinition var2, Object var3);

    private void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private void setSetValueLoader(ValueLoader valueLoader) {
        this.valueLoader = valueLoader;
    }
}

