/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import jeeves.server.overrides.SpringPropertyOverrides;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerRepository;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.XPath;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ConfigurationOverrides {
    public static final String OVERRIDES_KEY = "jeeves.configuration.overrides.file";
    public static final ConfigurationOverrides DEFAULT = new ConfigurationOverrides(null);
    static final String LOGFILE_XPATH = "logging/logFile";
    private static final String CONFIG_OVERRIDES_FILENAME = "config-overrides.xml";
    private static final String ATTNAME_ATTR_NAME = "attName";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String XPATH_ATTR_NAME = "xpath";
    private static final String FILE_NODE_NAME = "file";
    private static final String TEXT_FILE_NODE_NAME = "textFile";
    private static final String FILE_NAME_ATT_NAME = "name";
    private static final Pattern PROP_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
    private static final Filter ELEMENTS_FILTER = new Filter(){

        public boolean matches(Object obj) {
            return obj instanceof Element;
        }
    };
    private static final Filter TEXTS_FILTER = new Filter(){

        public boolean matches(Object obj) {
            return obj instanceof Text;
        }
    };
    private static final List<Namespace> WEB_XML_NS = new ArrayList<Namespace>();
    private SpringPropertyOverrides springPropertyOverrides;
    private String _overrides;

    public ConfigurationOverrides(String overrides) {
        this._overrides = overrides;
    }

    public void updateLoggingAsAccordingToOverrides(ServletContext context, Path appPath) throws JDOMException, IOException {
        ServletResourceLoader loader = new ServletResourceLoader(context, appPath);
        String resource = this.lookupOverrideParameter(context, appPath);
        Element xml = loader.loadXmlResource(resource);
        if (xml != null) {
            this.doUpdateLogging(xml, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateLogging(Element overrides, ResourceLoader loader) throws JDOMException, IOException {
        List logOverides = Xml.selectNodes((Element)overrides, (String)LOGFILE_XPATH);
        Properties p = new Properties();
        for (Object logOveride : logOverides) {
            String value = ((Content)logOveride).getValue();
            InputStream in = loader.loadInputStream(value);
            if (in != null) {
                try {
                    p.load(in);
                    continue;
                }
                finally {
                    in.close();
                    continue;
                }
            }
            throw new IllegalArgumentException("log configuration file " + value + " was not found");
        }
        if (logOverides.size() > 0) {
            LoggerRepository loggerRepo = Logger.getRootLogger().getLoggerRepository();
            loggerRepo.resetConfiguration();
            PropertyConfigurator configurator = new PropertyConfigurator();
            configurator.doConfigure(p, loggerRepo);
        }
    }

    public void updateWithOverrides(String configFile, ServletContext context, Path appPath, Element configElement) throws JDOMException, IOException {
        String resource = this.lookupOverrideParameter(context, appPath);
        ServletResourceLoader loader = new ServletResourceLoader(context, appPath);
        this.updateConfig(loader, resource, configFile, configElement);
    }

    private void updateConfig(ResourceLoader loader, String overridesResource, String configFilePath, Element configRoot) throws JDOMException, IOException {
        Element overrides = loader.loadXmlResource(overridesResource);
        if (overrides == null) {
            return;
        }
        Properties properties = this.loadProperties(overrides);
        List files = overrides.getChildren(FILE_NODE_NAME);
        for (Element file : files) {
            String expectedfileName = file.getAttributeValue(FILE_NAME_ATT_NAME);
            if (!Pattern.matches(expectedfileName, configFilePath.replace(File.separator, "/"))) continue;
            Log.info((String)"jeeves", (Object)("Overrides being applied to configuration file: " + expectedfileName));
            List elements = file.getChildren();
            block8: for (Element element : elements) {
                switch (Updates.valueOf(element.getName().toUpperCase())) {
                    case ADDXML: {
                        this.addXml(properties, element, configRoot);
                        continue block8;
                    }
                    case REMOVEXML: {
                        this.removeXml(properties, element, configRoot);
                        continue block8;
                    }
                    case REPLACEXML: {
                        this.replaceXml(properties, element, configRoot);
                        continue block8;
                    }
                    case REPLACEATT: {
                        this.replaceAtts(properties, element, configRoot);
                        continue block8;
                    }
                    case REPLACETEXT: {
                        this.replaceText(properties, element, configRoot);
                        continue block8;
                    }
                }
                throw new IllegalArgumentException(element.getName() + " is not a recognized update tag");
            }
        }
    }

    private void removeXml(Properties properties, Element elem, Element configRoot) throws JDOMException {
        String xpath = this.getXPath(elem);
        List<Content> matches = this.xpathLookup(configRoot, xpath);
        this.info("Removing xml elements: " + xpath);
        for (Content match : matches) {
            match.detach();
        }
    }

    private void addXml(Properties properties, Element elem, Element configRoot) throws JDOMException {
        List<Content> newXml = this.updateProperties(properties, elem);
        String xpath = this.getXPath(elem);
        this.info("Adding xml elements to " + xpath);
        this.debug("Elements added are:" + Xml.getString((Element)new Element("toAdd").addContent(newXml)));
        for (Content content : newXml) {
            content.detach();
        }
        if (xpath.trim().equals("")) {
            this.debug("Adding to root element");
            configRoot.addContent(newXml);
        } else {
            List<Content> matches = this.xpathLookup(configRoot, xpath);
            for (Content match : matches) {
                if (match instanceof Element) {
                    Element element = (Element)match;
                    this.debug("Adding xml to " + XPath.getXPath((Element)element));
                    element.addContent(newXml);
                    continue;
                }
                throw new IllegalArgumentException("the xpath of an Add XML overrides must select elements only");
            }
        }
    }

    private void replaceXml(Properties properties, Element elem, Element configRoot) throws JDOMException {
        String xpath = this.getXPath(elem);
        List<Content> matches = this.xpathLookup(configRoot, xpath);
        List<Content> newXml = this.updateProperties(properties, elem);
        this.info("Replacing child xml elements of " + xpath);
        this.debug("New elements are:" + Xml.getString((Element)new Element("toAdd").addContent(newXml)));
        for (Content content : newXml) {
            content.detach();
        }
        for (Content toUpdate : matches) {
            if (toUpdate instanceof Element) {
                Element element = (Element)toUpdate;
                this.debug("replacingXML of " + XPath.getXPath((Element)element));
                element.setContent(newXml);
                continue;
            }
            throw new IllegalArgumentException("the xpath of an Replace XML override must select elements only");
        }
    }

    private void replaceText(Properties properties, Element elem, Element configRoot) throws JDOMException {
        String xpath = this.getXPath(elem);
        String text = this.updatePropertiesInText(properties, elem.getText());
        this.info("Replacing text of " + xpath);
        this.debug("New text is:" + text);
        List<Content> matches = this.xpathLookup(configRoot, xpath);
        for (Content toUpdate : matches) {
            if (toUpdate instanceof Element) {
                Element element = (Element)toUpdate;
                this.debug("replacing Text of " + XPath.getXPath((Element)element));
                List textContent = this.toList(element.getDescendants(TEXTS_FILTER));
                if (textContent.size() > 0) {
                    for (int i = 0; i < textContent.size(); ++i) {
                        Text text1 = (Text)textContent.get(i);
                        if (i == 0 && text.length() > 0) {
                            text1.setText(text);
                            continue;
                        }
                        text1.detach();
                    }
                    continue;
                }
                element.addContent(text);
                continue;
            }
            throw new IllegalArgumentException("the xpath of an Replace Text override must select elements only");
        }
    }

    private void replaceAtts(Properties properties, Element elem, Element configRoot) throws JDOMException {
        String xpath = this.getXPath(elem);
        List<Content> matches = this.xpathLookup(configRoot, xpath);
        String attName = this.getCaseInsensitiveAttValue(elem, ATTNAME_ATTR_NAME, true);
        String newValue = this.updatePropertiesInText(properties, this.getCaseInsensitiveAttValue(elem, VALUE_ATTR_NAME, false));
        this.info("Replacing attribute " + attName + " of node " + xpath);
        this.debug("New attribute is:" + newValue);
        for (Content toUpdate : matches) {
            if (toUpdate instanceof Element) {
                Element element = (Element)toUpdate;
                this.debug("Updating attibute of node " + XPath.getXPath((Element)element));
                if (newValue == null) {
                    element.removeAttribute(attName);
                    continue;
                }
                element.setAttribute(attName, newValue);
                continue;
            }
            throw new IllegalArgumentException("the xpath of an Replace Attribute override must select elements only");
        }
    }

    private List<Content> xpathLookup(Element configRoot, String xpath) throws JDOMException {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (Namespace ns : configRoot.getAdditionalNamespaces()) {
            namespaces.add(ns);
        }
        List objects = Xml.selectNodes((Element)configRoot, (String)xpath, namespaces);
        ArrayList<Content> elements = new ArrayList<Content>();
        for (Object object : objects) {
            if (object instanceof Content) {
                elements.add((Content)((Element)object));
                continue;
            }
            throw new Error("How can this not be a content element");
        }
        return elements;
    }

    private Properties loadProperties(Element overrides) {
        Properties properties = new Properties();
        List pElem = overrides.getChildren("properties");
        for (Element element : pElem) {
            List props = element.getChildren();
            for (Element prop : props) {
                String key = prop.getName();
                String value = prop.getTextTrim();
                properties.put(key, value);
            }
        }
        while (!this.resolve(properties)) {
        }
        return properties;
    }

    private String getXPath(Element elem) {
        return this.getCaseInsensitiveAttValue(elem, XPATH_ATTR_NAME, true);
    }

    private String getCaseInsensitiveAttValue(Element elem, String name, boolean exceptionOnFailure) {
        List atts = elem.getAttributes();
        for (Attribute att : atts) {
            if (!att.getName().equalsIgnoreCase(name)) continue;
            return att.getValue();
        }
        if (exceptionOnFailure) {
            throw new AssertionError((Object)(elem.getName() + " does not have a '" + name + "' attribute"));
        }
        return null;
    }

    private List<Content> updateProperties(Properties properties, Element elem) {
        Element clone = (Element)elem.clone();
        Iterator iter = clone.getDescendants(ELEMENTS_FILTER);
        List elems = this.toList(iter);
        for (Element next : elems) {
            List atts = next.getAttributes();
            Iterator iterator = atts.iterator();
            while (iterator.hasNext()) {
                Attribute att = (Attribute)iterator.next();
                if (att.getName().equalsIgnoreCase(XPATH_ATTR_NAME)) continue;
                String updatedValue = this.updatePropertiesInText(properties, att.getValue());
                att.setValue(updatedValue);
            }
        }
        Iterator iter2 = clone.getDescendants(TEXTS_FILTER);
        List textNodes = this.toList(iter2);
        for (Text text : textNodes) {
            String updatedText = this.updatePropertiesInText(properties, text.getText());
            text.setText(updatedText);
        }
        ArrayList<Content> newXml = new ArrayList<Content>(clone.getChildren());
        for (Content content : newXml) {
            content.detach();
        }
        return newXml;
    }

    private <E> List<E> toList(Iterator<E> iter) {
        ArrayList<E> elems = new ArrayList<E>();
        while (iter.hasNext()) {
            elems.add(iter.next());
        }
        return elems;
    }

    String updatePropertiesInText(Properties properties, String value) {
        if (value == null) {
            return null;
        }
        String updatedValue = value;
        Matcher matcher = PROP_PATTERN.matcher(updatedValue);
        while (matcher.find()) {
            String propKey = matcher.group(1);
            String propValue = properties.getProperty(propKey);
            if (propKey.startsWith("env:")) continue;
            if (propValue == null) {
                throw new IllegalArgumentException("Found a reference to a variable: " + propKey + " which is not a valid property.  Check the spelling");
            }
            String dataToReplace = matcher.group(0);
            updatedValue = updatedValue.replace(dataToReplace, propValue);
        }
        return updatedValue;
    }

    private boolean resolve(Properties properties) {
        boolean finishedResolving = true;
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            Matcher matcher = PROP_PATTERN.matcher(value);
            if (matcher.find()) {
                finishedResolving = false;
            }
            String updatedValue = this.updatePropertiesInText(properties, value);
            properties.put(key, updatedValue);
        }
        return finishedResolving;
    }

    private void info(String msg) {
        Log.info((String)"jeeves", (Object)msg);
    }

    private void debug(String msg) {
        Log.debug((String)"jeeves", (Object)msg);
    }

    private String lookupOverrideParameter(ServletContext context, Path appPath) throws JDOMException, IOException {
        if (this._overrides != null) {
            return this._overrides;
        }
        String resource = context == null ? this.lookupOverrideParamFromAppPath(appPath) : this.lookupOverrideParamFromServlet(context);
        return resource;
    }

    private String lookupOverrideParamFromAppPath(Path appPath) throws JDOMException, IOException {
        Path webInf = appPath.resolve("WEB-INF");
        Path webxmlFile = webInf.resolve("web.xml");
        String resource = null;
        if (Files.exists(webxmlFile, new LinkOption[0])) {
            Namespace namespace;
            Element webXML = Xml.loadFile((Path)webxmlFile);
            String webappName = webXML.getChildTextTrim("display-name", namespace = webXML.getNamespace());
            if (webappName == null || webappName.isEmpty()) {
                webappName = "geonetwork";
            }
            resource = System.getProperty(webappName + "." + OVERRIDES_KEY);
        }
        if (resource == null || resource.trim().isEmpty()) {
            resource = this.lookupOverrideParamFromConfigFile(webInf.resolve(CONFIG_OVERRIDES_FILENAME).toUri().toURL());
        }
        if (resource == null || resource.trim().isEmpty()) {
            resource = System.getProperty(OVERRIDES_KEY);
        }
        return resource;
    }

    private String lookupOverrideParamFromConfigFile(URL url) throws IOException, JDOMException {
        try {
            Element config = Xml.loadFile((URL)url);
            StringBuilder builder = new StringBuilder();
            for (Element elem : config.getChildren("override")) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(elem.getTextTrim());
            }
            return builder.toString();
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String lookupOverrideParamFromServlet(ServletContext context) throws IOException, JDOMException {
        String resource = System.getProperty(context.getServletContextName() + "." + OVERRIDES_KEY);
        if (resource == null || resource.trim().isEmpty()) {
            resource = System.getProperty(OVERRIDES_KEY);
        }
        if (resource == null || resource.trim().isEmpty()) {
            resource = this.lookupOverrideParamFromConfigFile(context.getResource("/WEB-INF/config-overrides.xml"));
        }
        if (resource == null || resource.trim().isEmpty()) {
            resource = context.getInitParameter(OVERRIDES_KEY);
        }
        return resource;
    }

    public Element loadXmlFileAndUpdate(String servletRelativePath, ServletContext context) {
        Path appPath = IO.toPath((String)context.getContextPath(), (String[])new String[0]);
        Element elem = null;
        try {
            Path realPath = IO.toPath((String)context.getRealPath(servletRelativePath), (String[])new String[0]);
            elem = Xml.loadFile((Path)realPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.updateWithOverrides(servletRelativePath, context, appPath, elem);
        }
        catch (Exception e) {
            Log.error((String)"jeeves", (Object)("Unable to read overrides for config.xml: " + e.getMessage()), (Throwable)e);
        }
        return elem;
    }

    public List<String> loadTextFileAndUpdate(String configFilePath, ServletContext context, Path appPath, BufferedReader reader) throws IOException {
        ServletResourceLoader loader = new ServletResourceLoader(context, appPath);
        try {
            String resource = this.lookupOverrideParameter(context, appPath);
            return this.loadFileAndUpdate(loader, resource, configFilePath, reader);
        }
        catch (JDOMException e) {
            return this.loadFileAndUpdate(loader, null, configFilePath, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadFileAndUpdate(ResourceLoader loader, String overridesResource, String configFilePath, BufferedReader reader) throws IOException {
        Element overrides = loader.loadXmlResource(overridesResource);
        HashMap<Pattern, String> matches = new HashMap<Pattern, String>();
        Properties properties = new Properties();
        if (overrides != null) {
            properties = this.loadProperties(overrides);
            List files = overrides.getChildren(TEXT_FILE_NODE_NAME);
            for (Element file : files) {
                String string = file.getAttributeValue(FILE_NAME_ATT_NAME);
                if (!Pattern.matches(string, configFilePath)) continue;
                List updates = file.getChildren("update");
                for (Element element : updates) {
                    matches.put(Pattern.compile(element.getAttributeValue("linePattern")), element.getTextTrim());
                }
            }
        }
        ArrayList<String> al = new ArrayList<String>();
        String line = reader.readLine();
        try {
            while (line != null) {
                for (Map.Entry entry : matches.entrySet()) {
                    Matcher matcher = ((Pattern)entry.getKey()).matcher(line);
                    if (!matcher.matches()) continue;
                    String value = this.updatePropertiesInText(properties, (String)entry.getValue());
                    line = matcher.replaceFirst(value);
                    break;
                }
                al.add(line);
                line = reader.readLine();
            }
            ArrayList<String> arrayList = al;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSpringConfigurations(XmlBeanDefinitionReader reader, ConfigurableBeanFactory beanFactory, ServletContext servletContext, Path appPath) throws JDOMException, IOException {
        ServletResourceLoader loader = new ServletResourceLoader(servletContext, appPath);
        String overridesResource = this.lookupOverrideParameter(servletContext, appPath);
        Element overrides = loader.loadXmlResource(overridesResource);
        if (overrides == null) {
            return;
        }
        Properties properties = this.loadProperties(overrides);
        for (Element e : overrides.getChildren("spring")) {
            for (Element element : e.getChildren("import")) {
                String importFile = element.getAttributeValue(FILE_NODE_NAME);
                importFile = this.updatePropertiesInText(properties, importFile);
                Log.info((String)"jeeves", (Object)("ConfigurationOverrides: importing spring file into application context: " + importFile));
                Path file = ((ResourceLoader)loader).resolveFile(importFile);
                if (file != null) {
                    InputStreamResource inputSource = new InputStreamResource(IO.newInputStream((Path)file));
                    reader.loadBeanDefinitions((Resource)inputSource);
                    continue;
                }
                InputStream inputStream = loader.loadInputStream(importFile);
                try {
                    InputStreamResource inputSource = new InputStreamResource(inputStream);
                    reader.loadBeanDefinitions((Resource)inputSource);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
    }

    public void postProcessSpringBeanFactory(ConfigurableListableBeanFactory beanFactory, ServletContext servletContext, Path appPath) throws JDOMException, IOException {
        SpringPropertyOverrides springPropertyOverrides = this.getSpringPropertyOverrides(servletContext, appPath);
        if (springPropertyOverrides == null) {
            return;
        }
        springPropertyOverrides.postProcessBeanFactory(beanFactory);
    }

    public void onSpringApplicationContextFinishedRefresh(ConfigurableListableBeanFactory beanFactory, ServletContext servletContext, Path appPath) throws JDOMException, IOException {
        SpringPropertyOverrides springPropertyOverrides = this.getSpringPropertyOverrides(servletContext, appPath);
        if (springPropertyOverrides == null) {
            return;
        }
        springPropertyOverrides.onFinishedRefresh(beanFactory);
    }

    private synchronized SpringPropertyOverrides getSpringPropertyOverrides(ServletContext servletContext, Path appPath) throws JDOMException, IOException {
        if (this.springPropertyOverrides == null) {
            ServletResourceLoader loader = new ServletResourceLoader(servletContext, appPath);
            String overridesResource = this.lookupOverrideParameter(servletContext, appPath);
            Element overrides = loader.loadXmlResource(overridesResource);
            if (overrides == null) {
                return null;
            }
            Properties properties = this.loadProperties(overrides);
            ArrayList<Element> updateEls = new ArrayList<Element>();
            ArrayList spring = new ArrayList(overrides.getChildren("spring"));
            for (Element el : spring) {
                for (Element element : el.getChildren()) {
                    if (element.getName().equals("import")) continue;
                    updateEls.add(element);
                }
            }
            this.springPropertyOverrides = new SpringPropertyOverrides(updateEls, properties);
        }
        return this.springPropertyOverrides;
    }

    static {
        WEB_XML_NS.add(Namespace.getNamespace((String)"http://java.sun.com/xml/ns/j2ee"));
    }

    static class ServletResourceLoader
    extends ResourceLoader {
        private final ServletContext context;
        private Path appPath;

        ServletResourceLoader(ServletContext context, Path appPath) {
            this.context = context;
            this.appPath = appPath;
        }

        @Override
        protected Path resolveFile(String resource) throws IOException {
            URL url;
            Path testFile;
            String path;
            Path file = null;
            Path testPath = IO.toPath((String)resource, (String[])new String[0]);
            if (Files.exists(testPath, new LinkOption[0])) {
                file = testPath;
            }
            if (file == null && this.context != null && (path = this.context.getRealPath(resource)) != null && Files.exists(testPath = IO.toPath((String)path, (String[])new String[0]), new LinkOption[0])) {
                file = testPath;
            }
            if (file == null && this.appPath != null) {
                String resourceNoFirstSlash = resource;
                if (resourceNoFirstSlash.startsWith("/") || resourceNoFirstSlash.startsWith("\\")) {
                    resourceNoFirstSlash = resourceNoFirstSlash.substring(1);
                }
                if (Files.exists(testFile = this.appPath.resolve(resourceNoFirstSlash), new LinkOption[0])) {
                    file = testFile;
                }
            }
            if (file == null && (url = Thread.currentThread().getContextClassLoader().getResource(resource)) != null) {
                testFile = IO.toPath((String)url.getFile(), (String[])new String[0]);
                if (Files.exists(testFile, new LinkOption[0])) {
                    file = testFile;
                } else {
                    testFile = IO.toPath((String)url.getPath(), (String[])new String[0]);
                    if (Files.exists(testFile, new LinkOption[0])) {
                        file = testFile;
                    }
                }
            }
            return file;
        }

        @Override
        protected InputStream fallbackInputStream(String resource) throws IOException {
            if (resource != null) {
                InputStream in;
                try {
                    in = new URL(resource).openStream();
                }
                catch (MalformedURLException e) {
                    URL url;
                    try {
                        Path appBasedFile;
                        url = this.context != null ? this.context.getResource(resource) : (Files.exists(appBasedFile = this.appPath.resolve(resource), new LinkOption[0]) ? appBasedFile.toUri().toURL() : null);
                    }
                    catch (MalformedURLException e2) {
                        url = null;
                    }
                    if (url == null) {
                        Path file = IO.toPath((String)resource, (String[])new String[0]);
                        if (Files.exists(file, new LinkOption[0])) {
                            in = IO.newInputStream((Path)file);
                        }
                        file = IO.toPath((String)resource.replace('/', '\\'), (String[])new String[0]);
                        if (Files.exists(file, new LinkOption[0])) {
                            in = IO.newInputStream((Path)file);
                        }
                        throw new IllegalArgumentException("The resource file " + resource + " is not a file and not a web resource.  Perhaps a leading / was forgotten?");
                    }
                    in = url.openStream();
                }
                return in;
            }
            return null;
        }
    }

    public static abstract class ResourceLoader {
        protected InputStream loadInputStream(String resource) throws IOException {
            Pattern p = Pattern.compile("\\$\\{env:([^\\}]*)\\}");
            Matcher m = p.matcher(resource);
            while (m.find()) {
                String repl = m.group();
                String subst = System.getProperty(m.group(1), "");
                if (StringUtils.isEmpty((String)subst)) {
                    Log.warning((String)"jeeves", (Object)("Unable to resolve environmnent variable " + m.group(1) + ", replacing with empty string"));
                }
                resource = resource.replace(repl, subst);
            }
            Path file = this.resolveFile(resource);
            if (file == null) {
                return this.fallbackInputStream(resource);
            }
            return IO.newInputStream((Path)file);
        }

        protected abstract Path resolveFile(String var1) throws IOException;

        protected abstract InputStream fallbackInputStream(String var1) throws IOException;

        protected String resolveImportFileName(String importResource, String baseResource) {
            String resolved = this.resolveRelative(importResource, baseResource, File.separator);
            if (resolved.equals(importResource)) {
                return this.resolveRelative(importResource, baseResource, "/");
            }
            return resolved;
        }

        protected String resolveRelative(String importResource, String baseResource, String sep) {
            String back;
            String baseDir = baseResource;
            int lastSep = baseDir.lastIndexOf(sep);
            if (lastSep > -1) {
                baseDir = baseDir.substring(0, lastSep);
            }
            if (importResource.startsWith(back = ".." + sep)) {
                return baseDir + sep + ".." + sep + importResource;
            }
            if (importResource.startsWith(back.substring(1))) {
                return baseDir + sep + importResource;
            }
            return importResource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String loadStringResource(String resource) throws JDOMException, IOException {
            InputStream in = this.loadInputStream(resource);
            BufferedReader reader = null;
            if (in != null) {
                String string;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(in, Charset.forName(Constants.ENCODING)));
                    StringBuilder data = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        data.append(line);
                    }
                    string = data.toString();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (reader != null) {
                    IOUtils.closeQuietly((Reader)reader);
                }
                return string;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Element loadXmlResource(String resource) throws IOException {
            String[] resources;
            Element loadedResource = null;
            if (resource == null) {
                return null;
            }
            for (String string : resources = resource.split(",")) {
                if (string.trim().isEmpty()) continue;
                InputStream in = this.loadInputStream(string);
                if (in != null) {
                    try {
                        try {
                            Element element = Xml.loadStream((InputStream)in);
                            Element loaded = this.resolveImports(element, string);
                            if (loadedResource == null) {
                                loadedResource = loaded;
                                continue;
                            }
                            this.mergeElements(loadedResource, loaded);
                            continue;
                        }
                        catch (JDOMException e) {
                            throw new IOException(e);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                if (!Log.isDebugEnabled((String)"jeeves")) continue;
                Log.debug((String)"jeeves", (Object)("Unable to load Configuration Override resource: " + string));
            }
            return loadedResource;
        }

        private Element resolveImports(Element baseElement, String baseResource) throws JDOMException, IOException {
            ArrayList imports = new ArrayList(baseElement.getChildren("import"));
            for (Element anImport : imports) {
                anImport.detach();
                String file = anImport.getAttributeValue(ConfigurationOverrides.FILE_NODE_NAME);
                Element importedXml = this.loadXmlResource(this.resolveImportFileName(file, baseResource));
                this.mergeElements(baseElement, importedXml);
            }
            return baseElement;
        }

        private void mergeElements(Element baseElement, Element importedXml) throws JDOMException {
            ArrayList children = new ArrayList(importedXml.getChildren());
            for (Element toMerge : children) {
                String xpath;
                toMerge.detach();
                if (toMerge.getName().equalsIgnoreCase(ConfigurationOverrides.FILE_NODE_NAME)) {
                    xpath = "file[@name = '" + toMerge.getAttributeValue(ConfigurationOverrides.FILE_NAME_ATT_NAME) + "']";
                    this.merge(baseElement, toMerge, xpath, false);
                    continue;
                }
                if (toMerge.getName().equalsIgnoreCase("properties")) {
                    this.merge(baseElement, toMerge, toMerge.getName(), true);
                    continue;
                }
                if (toMerge.getName().equalsIgnoreCase(ConfigurationOverrides.TEXT_FILE_NODE_NAME)) {
                    xpath = "textFile[@name = '" + toMerge.getAttributeValue(ConfigurationOverrides.FILE_NAME_ATT_NAME) + "']";
                    this.merge(baseElement, toMerge, xpath, false);
                    continue;
                }
                this.merge(baseElement, toMerge, toMerge.getName(), false);
            }
        }

        private void merge(Element baseElement, Element toMerge, String xpath, boolean overrideImports) throws JDOMException {
            Element mergeTarget = Xml.selectElement((Element)baseElement, (String)xpath);
            if (mergeTarget != null) {
                Collection<Content> contentToAdd = this.detach(toMerge.getContent());
                if (overrideImports) {
                    contentToAdd = this.filterOutExistingElements(mergeTarget, contentToAdd);
                }
                mergeTarget.addContent(0, contentToAdd);
            } else {
                baseElement.addContent((Content)toMerge);
            }
        }

        private Collection<Content> filterOutExistingElements(Element mergeTarget, Collection<Content> contentToAdd) {
            ArrayList<Content> toAdd = new ArrayList<Content>();
            for (Content c : contentToAdd) {
                if (c instanceof Element) {
                    Element e = (Element)c.detach();
                    if (mergeTarget.getChild(e.getName()) != null) continue;
                    toAdd.add((Content)e);
                    continue;
                }
                toAdd.add(c);
            }
            contentToAdd = toAdd;
            return contentToAdd;
        }

        private Collection<Content> detach(List<Content> content) {
            ArrayList<Content> al = new ArrayList<Content>(content);
            for (Content o : al) {
                o.detach();
            }
            return al;
        }
    }

    static enum Updates {
        REPLACEATT,
        REPLACEXML,
        ADDXML,
        REMOVEXML,
        REPLACETEXT;

    }
}

