/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import jeeves.server.overrides.OverridesMetadataSource;
import jeeves.server.overrides.Updater;
import org.jdom.Element;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.util.RegexRequestMatcher;

abstract class AbstractInterceptUrlUpdater
implements Updater {
    private static final Function<? super FilterSecurityInterceptor, OverridesMetadataSource> TRANSFORMER = new Function<FilterSecurityInterceptor, OverridesMetadataSource>(){

        @Nullable
        public OverridesMetadataSource apply(@Nullable FilterSecurityInterceptor interceptor) {
            OverridesMetadataSource overrideSource;
            if (interceptor == null) {
                throw new IllegalArgumentException();
            }
            FilterInvocationSecurityMetadataSource metadataSource = interceptor.getSecurityMetadataSource();
            if (metadataSource instanceof OverridesMetadataSource) {
                overrideSource = (OverridesMetadataSource)metadataSource;
            } else {
                overrideSource = new OverridesMetadataSource(metadataSource);
                interceptor.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)overrideSource);
            }
            return overrideSource;
        }
    };
    protected final RegexRequestMatcher pattern;
    protected String patternString;

    public AbstractInterceptUrlUpdater(Element element) {
        this.pattern = new RegexRequestMatcher(element.getAttributeValue("pattern"), element.getAttributeValue("httpMethod"), Boolean.parseBoolean(element.getAttributeValue("caseInsensitive")));
        this.patternString = element.getAttributeValue("pattern");
    }

    @Override
    public boolean runOnFinish() {
        return true;
    }

    protected abstract void update(Iterable<OverridesMetadataSource> var1);

    @Override
    public void update(ConfigurableListableBeanFactory beanFactory, Properties properties) {
        Map beansOfType = beanFactory.getBeansOfType(FilterSecurityInterceptor.class);
        Iterable sources = Iterables.transform(beansOfType.values(), TRANSFORMER);
        this.update(sources);
    }
}

