/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.config.springutil.JeevesDelegatingFilterProxy;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class JeevesNodeAwareLogoutSuccessHandler
extends AbstractAuthenticationTargetUrlRequestHandler
implements LogoutSuccessHandler {
    @Autowired
    ServletContext context;
    @Autowired
    SettingManager settingManager;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        super.handle(request, response, authentication);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        ConfigurableApplicationContext applicationContext = JeevesDelegatingFilterProxy.getApplicationContextFromServletContext(JeevesDelegatingFilterProxy.getServletContext(this.context));
        NodeInfo nodeInfo = (NodeInfo)applicationContext.getBean(NodeInfo.class);
        String urlPatternValue = super.determineTargetUrl(request, response);
        if (urlPatternValue != null) {
            if (!urlPatternValue.startsWith("/")) {
                URL urlPattern = null;
                try {
                    urlPattern = new URL(urlPatternValue);
                    String hostName = urlPattern.getHost();
                    String protocol = urlPattern.getProtocol();
                    int port = urlPattern.getPort() == -1 ? urlPattern.getDefaultPort() : urlPattern.getPort();
                    String siteHost = this.settingManager.getValue("system/server/host");
                    String siteProtocol = this.settingManager.getValue("system/server/protocol");
                    int sitePort = this.settingManager.getValueAsInt("system/server/port");
                    if (!hostName.equalsIgnoreCase(siteHost) || !protocol.equalsIgnoreCase(siteProtocol) || port != sitePort) {
                        urlPatternValue = this.getDefaultTargetUrl();
                    }
                }
                catch (MalformedURLException e) {
                    urlPatternValue = this.getDefaultTargetUrl();
                }
            }
        } else {
            urlPatternValue = this.getDefaultTargetUrl();
        }
        return urlPatternValue.replace("@@nodeId@@", nodeInfo.getId());
    }
}

