/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import com.google.common.io.Files;
import java.io.File;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jeeves.config.springutil.JeevesApplicationContext;
import jeeves.server.JeevesEngine;
import jeeves.server.overrides.ConfigurationOverrides;
import org.fao.geonet.utils.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.repository.JpaRepository;

public class JeevesContextLoaderListener
implements ServletContextListener {
    private JeevesApplicationContext parentAppContext;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            Pattern nodeNamePattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
            ServletContext servletContext = sce.getServletContext();
            String javaVersion = System.getProperty("java.version");
            if (!javaVersion.startsWith("1.8")) {
                throw new RuntimeException("Java 8 required, cannot start with \"" + javaVersion + "\"");
            }
            File node = new File(servletContext.getRealPath("/WEB-INF/config-node/srv.xml"));
            ConfigurationOverrides overrides = ConfigurationOverrides.DEFAULT;
            String parentConfigFile = "/WEB-INF/config-spring-geonetwork-parent.xml";
            this.parentAppContext = new JeevesApplicationContext(null, null, parentConfigFile);
            this.parentAppContext.setServletContext(servletContext);
            this.parentAppContext.refresh();
            String commonConfigFile = "/WEB-INF/config-spring-geonetwork.xml";
            String nodeId = Files.getNameWithoutExtension((String)node.getName());
            if (!nodeNamePattern.matcher(nodeId).matches()) {
                throw new IllegalArgumentException(nodeId + " has an illegal name.  Node names must be of the form: [a-zA-Z_\\-]+ ");
            }
            JeevesApplicationContext jeevesAppContext = new JeevesApplicationContext(overrides, (ApplicationContext)this.parentAppContext, "classpath:mapfish-spring-application-context.xml", commonConfigFile, node.toURI().toString());
            jeevesAppContext.setServletContext(servletContext);
            jeevesAppContext.refresh();
            jeevesAppContext.getBeansOfType(JpaRepository.class, false, true);
            servletContext.setAttribute("jeevesNodeApplicationContext_", (Object)jeevesAppContext);
        }
        catch (Throwable e) {
            Log.error((String)"jeeves", (Object)("JeevesContextLoaderListener: " + e.getMessage()), (Throwable)e);
            JeevesEngine.handleStartupError(e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        JeevesApplicationContext jeevesAppContext = (JeevesApplicationContext)((Object)servletContext.getAttribute("jeevesNodeApplicationContext_"));
        if (jeevesAppContext != null) {
            jeevesAppContext.destroy();
        }
        Log.info((String)"jeeves.engine", (Object)"Destroying the parent appContext");
        this.parentAppContext.destroy();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            try {
                DriverManager.deregisterDriver(drivers.nextElement());
            }
            catch (SQLException e) {
                Log.warning((String)"jeeves.engine", (Object)"Cannot de-register driver", (Throwable)e);
            }
        }
    }
}

