/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class OrdinateFormat {
    public static final String REP_POS_INF = "Inf";
    public static final String REP_NEG_INF = "-Inf";
    public static final String REP_NAN = "NaN";
    public static final int MAX_FRACTION_DIGITS = 325;
    public static OrdinateFormat DEFAULT = new OrdinateFormat();
    private DecimalFormat format;

    public static OrdinateFormat create(int maximumFractionDigits) {
        return new OrdinateFormat(maximumFractionDigits);
    }

    public OrdinateFormat() {
        this.format = OrdinateFormat.createFormat(325);
    }

    public OrdinateFormat(int maximumFractionDigits) {
        this.format = OrdinateFormat.createFormat(maximumFractionDigits);
    }

    private static DecimalFormat createFormat(int maximumFractionDigits) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("0", symbols);
        format.setMaximumFractionDigits(maximumFractionDigits);
        return format;
    }

    public synchronized String format(double ord) {
        if (Double.isNaN(ord)) {
            return REP_NAN;
        }
        if (Double.isInfinite(ord)) {
            return ord > 0.0 ? REP_POS_INF : REP_NEG_INF;
        }
        return this.format.format(ord);
    }
}

