/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRetriever;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

class WAFRemoteFile
implements RemoteFile {
    private static final String OUTPUT_SCHEMA = "iso19139";
    private final CloseableHttpClient httpClient;
    private final String path;
    private ISODate changeDate;

    public WAFRemoteFile(String path, CloseableHttpClient httpClient) {
        this.path = path;
        this.httpClient = httpClient;
    }

    @Override
    public Element getMetadata(SchemaManager schemaMan) throws Exception {
        String type = WAFRetriever.getFileType(this.path);
        if ("GetCapabilities".equals(type)) {
            return this.getMdFromService(this.path, schemaMan);
        }
        if ("xml".equals(type)) {
            return this.getXmlFromUrl(new URL(this.path));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getXmlFromUrl(URL url) throws IOException, JDOMException {
        Element result;
        block28: {
            HttpGet request = new HttpGet(url.toString());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
                if (response.getStatusLine().getStatusCode() / 100 == 2) {
                    HttpEntity entity = response.getEntity();
                    try (InputStream responseInputStream = entity.getContent();){
                        result = Xml.loadStream((InputStream)responseInputStream);
                        break block28;
                    }
                    finally {
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    }
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            }
        }
        return result;
    }

    private Element getMdFromService(String url, SchemaManager schemaMan) throws Exception {
        Path styleSheet = this.getStyleSheet(url, schemaMan);
        if (styleSheet == null) {
            return null;
        }
        Element xml = this.getXmlFromUrl(new URL(url));
        String uuid = Sha1Encoder.encodeString((String)url);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uuid", uuid);
        Element el = Xml.transform((Element)xml, (Path)styleSheet, param);
        return el;
    }

    private Path getStyleSheet(String url, SchemaManager schemaMan) {
        String serviceType = this.getServiceType(url);
        if (serviceType == null) {
            return null;
        }
        return schemaMan.getSchemaDir(OUTPUT_SCHEMA).resolve("convert/").resolve("OGCWxSGetCapabilitiesto19119").resolve("OGC" + serviceType + "GetCapabilities-to-ISO19119_ISO19139.xsl");
    }

    private String getServiceType(String url) {
        if (url.toUpperCase().contains("SERVICE=WMS")) {
            return "WMS";
        }
        if (url.toUpperCase().contains("SERVICE=WCS")) {
            return "WCS";
        }
        if (url.toUpperCase().contains("SERVICE=WFS")) {
            return "WFS";
        }
        if (url.toUpperCase().contains("SERVICE=WPS")) {
            return "WPS";
        }
        return null;
    }

    @Override
    public boolean isMoreRecentThan(String localChangeDate) {
        ISODate remoteDate = this.changeDate;
        if (remoteDate == null) {
            return true;
        }
        ISODate localDate = new ISODate(localChangeDate);
        return remoteDate.timeDifferenceInSeconds(localDate) > 0L;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public ISODate getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(String date) {
        try {
            this.changeDate = new ISODate(ISODate.parseBasicOrFullDateTime((String)date).getMillis());
        }
        catch (Exception e) {
            this.changeDate = null;
        }
    }

    public static class WXS {
        public static final String WMS = "SERVICE=WMS";
        public static final String WCS = "SERVICE=WCS";
        public static final String WFS = "SERVICE=WFS";
        public static final String WPS = "SERVICE=WPS";
    }
}

