/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.util;

import java.util.List;
import org.fao.oaipmh.exceptions.BadResumptionTokenException;
import org.fao.oaipmh.util.Lib;

public class SearchResult {
    public String prefix;
    private List<Integer> ids;
    private String token;

    public SearchResult(String prefix) {
        this.prefix = prefix;
    }

    public int parseToken(String token) throws BadResumptionTokenException {
        if (!Lib.isInteger(token)) {
            throw new BadResumptionTokenException("Invalid token : " + token);
        }
        if (this.ids == null) {
            throw new IllegalStateException("res.ids should not be null");
        }
        int pos = Integer.parseInt(token);
        if (pos >= this.ids.size()) {
            throw new BadResumptionTokenException("Token beyond limit : " + token);
        }
        this.token = token;
        return pos;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public void setIds(List<Integer> ids) {
        this.ids = ids;
    }

    public void addIds(List<Integer> ids) {
        if (this.ids == null) {
            this.ids = ids;
        } else {
            this.ids.addAll(ids);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

