/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ImportAware;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

public class AddFileUriCommentProcessor
implements ResourcePreProcessor,
ImportAware {
    public static final String ALIAS = "addFileUriComment";
    protected static final String START_JS_COMMENT = "/* ---------------  Wro4j Start %s  --------------- */";
    protected static final String END_JS_COMMENT = "/* ---------------  Wro4j End %s --------------- */";
    protected static final String START_CSS_BLOCK = "#______WRO4J_START___ { background-image: url('%s'); }";
    protected static final String END_CSS_BLOCK = "#______WRO4J_END____ { background-image: url('%s'); }";
    private static final int MAX_FILE_LENGTH = 50;

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String uri = resource.getUri();
        if (uri.startsWith("closureDep://")) {
            IOUtils.copy((Reader)reader, (Writer)writer);
        } else {
            if (resource.getUri().length() > 50) {
                uri = "..." + uri.substring(uri.length() - 50);
            }
            switch (resource.getType()) {
                case JS: {
                    this.addJavascriptComment(reader, writer, uri);
                    break;
                }
                case CSS: {
                    this.addCssBlock(reader, writer, uri);
                    break;
                }
            }
        }
    }

    private void addCssBlock(Reader reader, Writer writer, String uri) throws IOException {
        writer.write(String.format(START_CSS_BLOCK, uri));
        writer.write("\n\n\n\n");
        IOUtils.copy((Reader)reader, (Writer)writer);
        writer.write("\n\n\n\n");
        writer.write(String.format(END_CSS_BLOCK, uri));
        writer.write("\n");
    }

    public void addJavascriptComment(Reader reader, Writer writer, String uri) throws IOException {
        writer.write(String.format(START_JS_COMMENT, uri));
        writer.write("\n\n\n\n");
        IOUtils.copy((Reader)reader, (Writer)writer);
        writer.write("\n\n\n\n");
        writer.write(String.format(END_JS_COMMENT, uri));
        writer.write("\n");
    }

    public boolean isImportAware() {
        return true;
    }
}

