/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.fao.geonet.Logger;
import org.fao.geonet.utils.Log;

public class GeonetworkHttpSessionListener
implements HttpSessionListener {
    private final AtomicInteger activeSessions;
    private final Logger LOGGER = Log.createLogger((String)"jeeves");

    public GeonetworkHttpSessionListener() {
        this.activeSessions = new AtomicInteger();
    }

    public int getTotalActiveSession() {
        return this.activeSessions.get();
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.activeSessions.incrementAndGet();
        if (this.LOGGER.isDebugEnabled()) {
            HttpSession session = event.getSession();
            ServletContext context = session.getServletContext();
            this.review(context);
            this.LOGGER.debug("sessions " + this.getTotalActiveSession() + ": session created");
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.activeSessions.decrementAndGet();
        if (this.LOGGER.isDebugEnabled()) {
            HttpSession session = event.getSession();
            ServletContext context = session.getServletContext();
            this.review(context);
            this.LOGGER.debug("sessions " + this.getTotalActiveSession() + ": session destroyed");
        }
    }

    protected void review(ServletContext context) {
        Enumeration e = context.getAttributeNames();
        while (e.hasMoreElements()) {
            String attributeName = (String)e.nextElement();
            StringBuilder build = new StringBuilder();
            build.append("sessionContent: ");
            build.append(attributeName);
            Object attribute = context.getAttribute(attributeName);
            if (attribute == null) {
                build.append(" --> null");
            } else if ("jeevesNodeApplicationContext_".equals(attributeName)) {
                build.append(" -- jeeves application context");
            } else if ("session".equals(attributeName)) {
                build.append(" -- jeeves session");
            } else {
                build.append(" --> ");
                build.append(attribute);
            }
            this.LOGGER.debug(build.toString());
        }
    }
}

