/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharIterator;
import bak.pcj.adapter.IteratorToCharIteratorAdapter;
import bak.pcj.set.AbstractCharSet;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;
import java.util.Set;

public class SetToCharSetAdapter
extends AbstractCharSet
implements CharSet {
    protected Set set;

    public SetToCharSetAdapter(Set set) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
    }

    public SetToCharSetAdapter(Set set, boolean validate) {
        if (set == null) {
            Exceptions.nullArgument("set");
        }
        this.set = set;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(char v) {
        return this.set.add(new Character(v));
    }

    public void clear() {
        this.set.clear();
    }

    public boolean contains(char v) {
        return this.set.contains(new Character(v));
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public CharIterator iterator() {
        return new IteratorToCharIteratorAdapter(this.set.iterator());
    }

    public boolean remove(char v) {
        return this.set.remove(new Character(v));
    }

    public int size() {
        return this.set.size();
    }

    public boolean validate() {
        return Adapter.isCharAdaptable(this.set);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("set");
        }
    }
}

