/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import io.searchbox.action.Action;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.springframework.beans.factory.BeanCreationException;

public class IndexHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(final ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() throws Exception {
                GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
                try {
                    EsSearchManager searchMan = (EsSearchManager)gc.getBean(EsSearchManager.class);
                    try {
                        Search search = ((Search.Builder)((Search.Builder)new Search.Builder("").addIndex(searchMan.getIndex())).addType(searchMan.getIndexType())).build();
                        SearchResult result = (SearchResult)searchMan.getClient().getClient().execute((Action)search);
                        if (result.isSucceeded()) {
                            return HealthCheck.Result.healthy((String)String.format("%s records indexed in remote index currently.", result.getHits(Object.class).size()));
                        }
                        return HealthCheck.Result.unhealthy((String)"Index storing records is not available currently. This component is only required if you use WFS features indexing and dashboards.");
                    }
                    catch (Throwable e) {
                        return HealthCheck.Result.unhealthy((Throwable)e);
                    }
                }
                catch (BeanCreationException e) {
                    return HealthCheck.Result.unhealthy((String)"Remote index module is not installed in your catalogue installation. Add 'es' to the spring.profiles.active in WEB-INF/web.xml to activate it.");
                }
            }
        };
    }
}

