/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common.requests;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.csw.common.Section;
import org.fao.geonet.csw.common.requests.CatalogRequest;
import org.jdom.Element;

public class GetCapabilitiesRequest
extends CatalogRequest {
    private String sequence;
    private List<String> alVersions = new ArrayList<String>();
    private List<String> alFormats = new ArrayList<String>();
    private Set<Section> hsSections = new HashSet<Section>();

    public GetCapabilitiesRequest(ServiceContext context) {
        super(context);
    }

    public void addVersion(String version) {
        this.alVersions.add(version);
    }

    public void addSection(Section section) {
        this.hsSections.add(section);
    }

    public void addOutputFormat(String format) {
        this.alFormats.add(format);
    }

    public void setUpdateSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    protected String getRequestName() {
        return "GetCapabilities";
    }

    @Override
    protected void setupGetParams() {
        this.addParam("request", this.getRequestName());
        this.addParam("service", "CSW");
        if (this.sequence != null) {
            this.addParam("updateSequence", this.sequence);
        }
        this.fill("acceptVersions", this.alVersions);
        this.fill("sections", this.hsSections);
        this.fill("acceptFormats", this.alFormats);
    }

    @Override
    protected Element getPostParams() {
        Element params = new Element(this.getRequestName(), Csw.NAMESPACE_CSW);
        params.setAttribute("service", "CSW");
        if (this.sequence != null) {
            params.setAttribute("updateSequence", this.sequence);
        }
        this.fill(params, "AcceptVersions", "Version", this.alVersions, Csw.NAMESPACE_OWS);
        this.fill(params, "Sections", "Section", this.hsSections, Csw.NAMESPACE_OWS);
        this.fill(params, "AcceptFormats", "OutputFormat", this.alFormats, Csw.NAMESPACE_OWS);
        return params;
    }
}

