/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyBooleanMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyBooleanMap;
import bak.pcj.map.ObjectKeyBooleanMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyBooleanMapAdapter
extends AbstractObjectKeyBooleanMap
implements ObjectKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToObjectKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Boolean)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public ObjectKeyBooleanMapIterator entries() {
        return new ObjectKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(Object key) {
        Boolean value = (Boolean)this.map.get(key);
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(Object key, boolean value) {
        Boolean oldValue = this.map.put(key, new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(Object key) {
        Boolean value = (Boolean)this.map.remove(key);
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(Object key) {
        Boolean value = (Boolean)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

