/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting.notifier;

import java.util.ArrayList;
import jeeves.server.context.ServiceContext;
import org.apache.commons.mail.EmailException;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.MailUtil;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class SendNotification {
    public static void process(ServiceContext context, Element element, AbstractHarvester abstractHarvester) throws EmailException {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settings = (SettingManager)gc.getBean(SettingManager.class);
        SendNotification.notifyByMail(settings, element, abstractHarvester);
    }

    private static void notifyByMail(SettingManager settings, Element element, AbstractHarvester ah) throws EmailException {
        if (!settings.getValueAsBool("system/harvesting/mail/enabled")) {
            return;
        }
        String receiver = settings.getValue("system/harvesting/mail/recipient");
        ArrayList<String> toAddress = new ArrayList<String>();
        if (receiver == null || receiver.trim().isEmpty()) {
            try {
                receiver = ah.getOwnerEmail();
            }
            catch (Exception e1) {
                Log.error((String)"geonetwork.harvester", (Object)e1.getMessage(), (Throwable)e1);
            }
        }
        toAddress.add(receiver);
        String subject = settings.getValue("system/harvesting/mail/subject");
        String htmlMessage = settings.getValue("system/harvesting/mail/template");
        Element info = element.getChild("info");
        if (info != null) {
            Element result = (Element)info.getChildren().get(0);
            if (info.getChildren("error").size() > 0) {
                String[] values;
                if (!settings.getValueAsBool("system/harvesting/mail/level3")) {
                    return;
                }
                htmlMessage = settings.getValue("system/harvesting/mail/templateError");
                Element error = (Element)info.getChildren("error").get(0);
                String errorMsg = error.getChildText("message");
                errorMsg = errorMsg.replace("<", " ");
                errorMsg = errorMsg + SendNotification.extractWarningsTrace(info);
                htmlMessage = htmlMessage.replace("$$errorMsg$$", errorMsg);
                for (String value : values = new String[]{"total", "added", "updated", "removed", "unchanged", "unretrievable", "doesNotValidate"}) {
                    htmlMessage = SendNotification.replace(result, htmlMessage, value);
                    subject = SendNotification.replace(result, subject, value);
                }
            } else {
                Element harvesterErrors = result.getChild("errors");
                if (harvesterErrors != null && harvesterErrors.getChildren().size() > 0) {
                    String[] values;
                    if (!settings.getValueAsBool("system/harvesting/mail/level2")) {
                        return;
                    }
                    htmlMessage = settings.getValue("system/harvesting/mail/templateWarning");
                    String errorMsg = SendNotification.extractWarningsTrace(result);
                    htmlMessage = htmlMessage.replace("$$errorMsg$$", errorMsg);
                    for (String value : values = new String[]{"total", "added", "updated", "removed", "unchanged", "unretrievable", "doesNotValidate"}) {
                        htmlMessage = SendNotification.replace(result, htmlMessage, value);
                        subject = SendNotification.replace(result, subject, value);
                    }
                } else {
                    String[] values;
                    if (!settings.getValueAsBool("system/harvesting/mail/level1")) {
                        return;
                    }
                    for (String value : values = new String[]{"total", "added", "updated", "removed", "unchanged", "unretrievable", "doesNotValidate"}) {
                        htmlMessage = SendNotification.replace(result, htmlMessage, value);
                        subject = SendNotification.replace(result, subject, value);
                    }
                }
            }
        }
        htmlMessage = htmlMessage.replace("$$harvesterName$$", ((AbstractParams)ah.getParams()).getName());
        subject = subject.replace("$$harvesterName$$", ((AbstractParams)ah.getParams()).getName());
        htmlMessage = htmlMessage.replace("$$harvesterType$$", ah.getType());
        subject = subject.replace("$$harvesterType$$", ah.getType());
        MailUtil.sendHtmlMail(toAddress, (String)subject, (String)htmlMessage, (SettingManager)settings);
    }

    private static String extractWarningsTrace(Element result) {
        StringBuffer errorMsg = new StringBuffer("");
        for (Object o : result.getChildren("errors")) {
            Element errores = (Element)o;
            for (Object a : errores.getChildren("error")) {
                Element error = (Element)a;
                String desc = error.getChildText("description");
                String hint = error.getChildText("hint");
                String trace = SendNotification.getErrorTrace(error);
                errorMsg = errorMsg.append("<li><p><strong>'").append(desc).append("'</strong>:").append(hint).append("</p><p>").append(trace).append("</p></li>");
            }
        }
        errorMsg.append("<ul>").append(errorMsg).append("</ul>");
        return errorMsg.toString();
    }

    private static String getErrorTrace(Element error) {
        String trace = "";
        for (Object e : error.getChildren("error")) {
            Element error_ = (Element)e;
            trace = error_.getChildText("message");
        }
        return trace.replace("<", " ");
    }

    private static String replace(Element element, String htmlMessage, String value) {
        String tmp = element.getChildText(value);
        if (tmp == null) {
            return htmlMessage.replace("$$" + value + "$$", "0");
        }
        return htmlMessage.replace("$$" + value + "$$", tmp);
    }
}

