/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.text.ParseException;
import jeeves.server.context.ServiceContext;
import org.apache.http.HttpException;
import org.apache.jcs.access.exception.CacheException;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.exceptions.BadServerResponseEx;
import org.fao.geonet.exceptions.BadSoapResponseEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.SchemaMatchConflictException;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvestError;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestError
extends AbstractHarvestError {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvester");
    private Throwable origin = null;
    private String description = null;
    private String hint = "Check with your administrator the error.";

    public HarvestError(ServiceContext context, InvalidParameterValueEx ex) {
        super(context);
        this.origin = ex;
        this.description = "The server didn't accept one of the parameters sent on the request.\n The parameter rejected was: " + ex.getLocator() + " (" + ex.getMessage() + ")";
        this.hint = "Check that geonetwork supports the exact version of the server you are trying to connect";
        this.printLog();
    }

    public HarvestError(ServiceContext context, Throwable ex) {
        super(context);
        this.origin = ex;
        this.description = ex.getMessage();
        if (this.description == null || this.description.isEmpty()) {
            this.description = ex.getClass().toString();
        }
    }

    public HarvestError(ServiceContext context, CacheException ex) {
        super(context);
        this.origin = ex;
        this.description = "Failed to update Jeeves cache: " + ex.getMessage();
        this.printLog();
    }

    public HarvestError(ServiceContext context, JDOMException ex) {
        super(context);
        this.origin = ex;
        this.description = "There was an error processing the response. " + ex.getMessage();
        this.printLog();
    }

    public HarvestError(ServiceContext context, BadServerResponseEx e) {
        super(context);
        this.origin = e;
        this.description = "The server returned an answer that could not be processed: " + e.getObject();
        this.hint = "Check the harvester is correctly configured.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, BadSoapResponseEx e) {
        super(context);
        this.origin = e;
        this.description = "The server returned an answer that could not be processed.";
        this.hint = "Check the harvester is correctly configured.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, HttpException e) {
        super(context);
        this.origin = e;
        this.description = "There was an error trying to reach some URL. " + e.getMessage();
        this.printLog();
    }

    public HarvestError(ServiceContext context, IOException e) {
        super(context);
        this.origin = e;
        this.description = "There was an error trying to reach an URI. " + e.getMessage();
        this.printLog();
    }

    public HarvestError(ServiceContext context, MalformedURLException e) {
        super(context);
        this.origin = e;
        this.description = "There was an error trying to reach an URL. ";
        this.hint = "Check the configuration of the harvest.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, UnsupportedEncodingException e) {
        super(context);
        this.origin = e;
        this.description = "The metadata is defined on an unsupported encoding: " + e.getMessage();
        this.hint = "Check with your administrator the encoding error.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, ParseException e) {
        super(context);
        this.origin = e;
        this.description = "Unable to parse the metadata.";
        this.hint = "Check with your administrator about possible network errors or corrupt data on harvested server.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, SQLException e) {
        super(context);
        this.origin = e;
        this.description = "There was an error while updating the database: " + e.getSQLState();
        this.hint = "Check with your administrator that the database is not corrupted.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, UserNotFoundEx e) {
        super(context);
        this.origin = e;
        this.description = "Couldn't log in to harvest using " + e.getObject();
        this.hint = "Check username and password.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, SchemaMatchConflictException e, String name) {
        super(context);
        this.origin = e;
        this.description = "Couldn't match the schema for " + name;
        this.hint = "Check that the schemas used are defined on geonetwork.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, SchemaMatchConflictException e) {
        super(context);
        this.origin = e;
        this.description = "Couldn't match the schema.";
        this.hint = "Check that the schemas used are defined on geonetwork.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, NoSchemaMatchesException e, String name) {
        super(context);
        this.origin = e;
        this.description = "Couldn't recognize the schema for " + name;
        this.hint = "Check that the schemas used are defined on geonetwork.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, NoSchemaMatchesException e) {
        super(context);
        this.origin = e;
        this.description = "Couldn't recognize the schema.";
        this.hint = "Check that the schemas used are defined on geonetwork.";
        this.printLog();
    }

    public HarvestError(ServiceContext context, BadXmlResponseEx e, String capabUrl) {
        super(context);
        this.origin = e;
        this.description = "The response returned from the server doesn't look like XML";
        this.hint = "Check the URL is ok: " + capabUrl;
        this.printLog();
    }

    public HarvestError(ServiceContext context, BadXmlResponseEx e) {
        super(context);
        this.origin = e;
        this.description = "The response returned from the server doesn't look like XML. " + e.getMessage();
        this.hint = "Check the URL is ok.";
        this.printLog();
    }

    public Throwable getOrigin() {
        return this.origin;
    }

    public void setOrigin(Throwable origin) {
        this.origin = origin;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String toString() {
        return this.origin.getClass() + "[" + this.description + " -> " + this.hint + "]";
    }

    public void printLog() {
        if (this.description != null) {
            LOGGER.warn(this.description);
        }
        if (this.hint != null) {
            LOGGER.warn(this.hint);
        }
        if (this.origin != null) {
            LOGGER.error(this.origin.toString());
        }
    }
}

