/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroupId;
import org.fao.geonet.entitylistener.UserGroupEntityListenerManager;
import org.jdom.Content;
import org.jdom.Element;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="UserGroups")
@EntityListeners(value={UserGroupEntityListenerManager.class})
public class UserGroup
extends GeonetEntity
implements Serializable {
    private UserGroupId _id = new UserGroupId();
    private Group _group;
    private User _user;

    @EmbeddedId
    public UserGroupId getId() {
        return this._id;
    }

    public UserGroup setId(UserGroupId id) {
        this._id = id;
        return this;
    }

    @MapsId(value="groupId")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="groupId", referencedColumnName="id")
    public Group getGroup() {
        return this._group;
    }

    public UserGroup setGroup(Group group) {
        this._group = group;
        this.getId().setGroupId(group.getId());
        return this;
    }

    @MapsId(value="userId")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userId", referencedColumnName="id")
    public User getUser() {
        return this._user;
    }

    public UserGroup setUser(User user) {
        this._user = user;
        this.getId().setUserId(this._user.getId());
        return this;
    }

    @Transient
    public Profile getProfile() {
        return this.getId().getProfile();
    }

    public UserGroup setProfile(Profile profile) {
        this.getId().setProfile(profile);
        return this;
    }

    @Override
    protected Element asXml(IdentityHashMap<Object, Void> alreadyEncoded) {
        return new Element("record").addContent((Content)new Element("group").setText("" + this.getId().getGroupId())).addContent((Content)new Element("user").setText("" + this.getId().getUserId())).addContent((Content)new Element("profile").setText(this.getProfile().name()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserGroup ug = (UserGroup)o;
        return this.getId().getGroupId() == ug.getId().getGroupId() && this.getId().getUserId() == ug.getId().getUserId() && this.getProfile().name().equals(ug.getProfile().name());
    }

    public int hashCode() {
        return Objects.hash(this.getProfile().name(), this.getId().getUserId(), this.getId().getGroupId());
    }
}

