/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.entitylistener.StatusValueEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="StatusValues")
@Cacheable
@EntityListeners(value={StatusValueEntityListenerManager.class})
@SequenceGenerator(name="status_value_id_seq", initialValue=100, allocationSize=1)
public class StatusValue
extends Localized {
    static final String ID_SEQ_NAME = "status_value_id_seq";
    private int _id;
    private String _name;
    private char _reserved = (char)110;
    private StatusValueType type = StatusValueType.workflow;
    private StatusValueNotificationLevel notificationLevel;
    private int displayOrder;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="status_value_id_seq")
    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    @Column(nullable=false)
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Column(name="reserved", nullable=false, length=1)
    protected char getReserved_JpaWorkaround() {
        return this._reserved;
    }

    protected char setReserved_JpaWorkaround(char reserved) {
        this._reserved = reserved;
        return this._reserved;
    }

    @Transient
    public boolean isReserved() {
        return Constants.toBoolean_fromYNChar(this.getReserved_JpaWorkaround());
    }

    public void setReserved(boolean reserved) {
        this.setReserved_JpaWorkaround(Constants.toYN_EnabledChar(reserved));
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="StatusValuesDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    @Column(name="displayorder")
    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Column(nullable=true, name="type")
    @Enumerated(value=EnumType.STRING)
    public StatusValueType getType() {
        return this.type;
    }

    public void setType(StatusValueType type) {
        this.type = type;
    }

    @Column(nullable=true, name="notificationLevel")
    @Enumerated(value=EnumType.STRING)
    public StatusValueNotificationLevel getNotificationLevel() {
        return this.notificationLevel;
    }

    public void setNotificationLevel(StatusValueNotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StatusValue{");
        sb.append("_id=").append(this._id);
        sb.append(", _name='").append(this._name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static final class Events {
        public static final String RECORDCREATED = "50";
        public static final String RECORDUPDATED = "51";
        public static final String ATTACHMENTADDED = "52";
        public static final String ATTACHMENTDELETED = "53";
        public static final String RECORDOWNERCHANGE = "54";
        public static final String RECORDGROUPOWNERCHANGE = "55";
        public static final String RECORDPRIVILEGESCHANGE = "56";
        public static final String RECORDCATEGORYCHANGE = "57";
        public static final String RECORDVALIDATIONTRIGGERED = "58";
        public static final String RECORDSTATUSCHANGE = "59";
        public static final String RECORDPROCESSINGCHANGE = "60";
        public static final String RECORDDELETED = "61";
        public static final String RECORDIMPORTED = "62";
        public static final String RECORDRESTORED = "63";
    }

    public static final class Status {
        public static final String DRAFT = "1";
        public static final String APPROVED = "2";
        public static final String RETIRED = "3";
        public static final String SUBMITTED = "4";
    }
}

