/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.util.logging.Logging;
import org.geotools.xs.XS;
import org.geotools.xsd.SchemaLocationResolver;
import org.geotools.xsd.SchemaLocator;
import org.geotools.xsd.Schemas;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public abstract class XSD {
    protected static Logger LOGGER = Logging.getLogger(XSD.class);
    protected volatile XSDSchema schema;
    protected Schema typeSchema;
    protected Schema typeMappingProfile;
    private volatile Set<XSD> dependencies;

    protected XSD() {
    }

    protected Schema buildTypeSchema() {
        return new SchemaImpl(this.getNamespaceURI());
    }

    protected Schema buildTypeMappingProfile(Schema typeSchema) {
        return typeSchema.profile(Collections.EMPTY_SET);
    }

    protected Name name(QName qName) {
        return new NameImpl(qName.getNamespaceURI(), qName.getLocalPart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema getTypeSchema() {
        if (this.typeSchema == null) {
            XSD xSD = this;
            synchronized (xSD) {
                this.typeSchema = this.buildTypeSchema();
            }
        }
        return this.typeSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Schema getTypeMappingProfile() {
        if (this.typeMappingProfile == null) {
            XSD xSD = this;
            synchronized (xSD) {
                this.typeMappingProfile = this.buildTypeMappingProfile(this.getTypeSchema());
            }
        }
        return this.typeMappingProfile;
    }

    public final List<Schema> getAllTypeMappingProfiles() {
        LinkedList<Schema> profiles = new LinkedList<Schema>();
        for (XSD xsd : this.getAllDependencies()) {
            Schema profile = xsd.getTypeMappingProfile();
            if (profile.isEmpty()) continue;
            profiles.add(profile);
        }
        return profiles;
    }

    public abstract String getNamespaceURI();

    public abstract String getSchemaLocation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<XSD> getDependencies() {
        if (this.dependencies == null) {
            XSD xSD = this;
            synchronized (xSD) {
                if (this.dependencies == null) {
                    LinkedHashSet<XSD> newDeps = new LinkedHashSet<XSD>();
                    newDeps.add(XS.getInstance());
                    this.addDependencies(newDeps);
                    this.dependencies = newDeps;
                }
            }
        }
        return this.dependencies;
    }

    public List<XSD> getAllDependencies() {
        return this.allDependencies();
    }

    protected List allDependencies() {
        LinkedList<XSD> unpacked = new LinkedList<XSD>();
        Stack<XSD> stack = new Stack<XSD>();
        stack.addAll(this.getDependencies());
        while (!stack.isEmpty()) {
            XSD xsd = (XSD)stack.pop();
            if (this.equals(xsd) || unpacked.contains(xsd)) continue;
            unpacked.addFirst(xsd);
            stack.addAll(xsd.getDependencies());
        }
        return unpacked;
    }

    protected void addDependencies(Set dependencies) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final XSDSchema getSchema() throws IOException {
        if (this.schema != null) return this.schema;
        Class<Schemas> clazz = Schemas.class;
        synchronized (Schemas.class) {
            if (this.schema != null) return this.schema;
            LOGGER.fine("building schema for schema: " + this.getNamespaceURI());
            this.schema = this.buildSchema();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.schema;
        }
    }

    protected XSDSchema buildSchema() throws IOException {
        SchemaLocationResolver resolver;
        ArrayList<XSDSchemaLocator> locators = new ArrayList<XSDSchemaLocator>();
        ArrayList<SchemaLocationResolver> resolvers = new ArrayList<SchemaLocationResolver>();
        for (XSD dependency : this.allDependencies()) {
            SchemaLocationResolver resolver2;
            SchemaLocator locator = dependency.createSchemaLocator();
            if (locator != null) {
                locators.add(locator);
            }
            if ((resolver2 = dependency.createSchemaLocationResolver()) == null) continue;
            resolvers.add(resolver2);
        }
        XSDSchemaLocator suppSchemaLocator = this.getSupplementarySchemaLocator();
        if (suppSchemaLocator != null) {
            locators.add(suppSchemaLocator);
        }
        if ((resolver = this.createSchemaLocationResolver()) != null) {
            resolvers.add(resolver);
        }
        return Schemas.parse(this.getSchemaLocation(), locators, resolvers);
    }

    public SchemaLocator createSchemaLocator() {
        return new SchemaLocator(this);
    }

    public SchemaLocationResolver createSchemaLocationResolver() {
        return new SchemaLocationResolver(this);
    }

    public QName qName(String local) {
        return new QName(this.getNamespaceURI(), local);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XSD) {
            XSD other = (XSD)obj;
            return this.getNamespaceURI().equals(other.getNamespaceURI());
        }
        return false;
    }

    public final int hashCode() {
        return this.getNamespaceURI().hashCode();
    }

    public String toString() {
        return this.getNamespaceURI();
    }

    public XSDSchemaLocator getSupplementarySchemaLocator() {
        return null;
    }

    public void dispose() {
        if (this.schema != null) {
            ResourceSet rs = this.schema.eResource().getResourceSet();
            for (Resource r : rs.getResources()) {
                if (!(r instanceof XSDResourceImpl)) continue;
                Schemas.dispose(((XSDResourceImpl)r).getSchema());
            }
            this.schema = null;
        }
    }
}

