/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.util.Arrays;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.events.md.MetadataDraftAdd;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class DraftCreated
implements ApplicationListener<MetadataDraftAdd> {
    @Autowired
    private IMetadataUtils metadataUtils;
    @Autowired
    private IMetadataIndexer metadataIndexer;
    @Autowired
    ServiceManager serviceManager;

    public void onApplicationEvent(MetadataDraftAdd event) {
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    public void doAfterCommit(MetadataDraftAdd event) {
        Log.trace((String)"geonetwork.datamanager", (Object)("Reindexing non drafted versions of uuid " + event.getMd().getUuid()));
        try (ServiceContext context = this.serviceManager.createServiceContext("draft_created", -1);){
            for (AbstractMetadata md : this.metadataUtils.findAllByUuid(event.getMd().getUuid())) {
                if (md instanceof MetadataDraft) continue;
                Log.trace((String)"geonetwork.datamanager", (Object)("Reindexing " + md.getId()));
                try {
                    this.metadataIndexer.indexMetadata(Arrays.asList(String.valueOf(md.getId())));
                }
                catch (Exception e) {
                    Log.error((String)"geonetwork.datamanager", (Object)e, (Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.datamanager", (Object)("Couldn't reindex the non drafted versions of " + event.getMd()), (Throwable)e);
        }
    }
}

