/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.nodemime.NodeMime;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.List;

class DataUri
extends CatchAllMultiParameterFunction {
    private NodeMime mime = new NodeMime();
    private static final int DATA_URI_MAX_KB = 32;

    DataUri() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        String fragments;
        String mimetype = null;
        String filename = null;
        if (splitParameters.size() == 1) {
            CssString filenameArg = (CssString)splitParameters.get(0);
            filename = filenameArg.getValue();
        } else {
            CssString mimetypeArg = (CssString)splitParameters.get(0);
            mimetype = mimetypeArg.getValue();
            CssString filenameArg = (CssString)splitParameters.get(1);
            filename = filenameArg.getValue();
        }
        String[] filenameParts = filename.split("#", 2);
        filename = filenameParts[0];
        String string = fragments = filenameParts.length > 1 ? "#" + filenameParts[1] : "";
        if (mimetype == null) {
            mimetype = this.guessMimetype(filename);
        }
        LessSource source = token.getSource();
        try {
            LessSource dataSource = source.relativeSource(filename);
            byte[] data = dataSource.getBytes();
            int fileSizeInKB = data.length / 1024;
            if (fileSizeInKB >= 32) {
                problemsHandler.warnIE8UnsafeDataUri(functionCall, filename, fileSizeInKB, 32);
                FunctionExpression result = new FunctionExpression(token, "url", functionCall.getParameter().clone());
                result.configureParentToAllChilds();
                return result;
            }
            return this.toDataUri(token, mimetype, data, fragments);
        }
        catch (LessSource.FileNotFound ex) {
            problemsHandler.errorFileNotFound(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
        catch (LessSource.CannotReadFile e) {
            problemsHandler.errorFileCanNotBeRead(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
        catch (LessSource.StringSourceException ex) {
            problemsHandler.errorFileReferenceNoBaseDirectory(functionCall, filename);
            return new FaultyExpression(functionCall.getUnderlyingStructure());
        }
    }

    private String guessMimetype(String filename) {
        String mimetype = this.mime.lookupMime(filename);
        if (!this.mime.isText(mimetype)) {
            mimetype = mimetype + ";base64";
        }
        return mimetype;
    }

    private Expression toDataUri(HiddenTokenAwareTree token, String mimetype, byte[] data, String fragments) {
        if (mimetype != null && mimetype.toLowerCase().endsWith("base64")) {
            return this.toDataUri(token, mimetype, PrintUtils.base64Encode(data), fragments);
        }
        return this.toDataUri(token, mimetype, PrintUtils.toUtf8AsUri(new String(data)), fragments);
    }

    private Expression toDataUri(HiddenTokenAwareTree token, String mimetype, String data, String fragments) {
        StringBuilder value = new StringBuilder("data:");
        value.append(mimetype).append(",").append(data).append(fragments);
        CssString parameter = new CssString(token, value.toString(), "\"");
        return new FunctionExpression(token, "url", parameter);
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.STRING_EXPRESSION);
    }

    @Override
    protected String getName() {
        return "data-uri";
    }
}

