/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.v2_0.storedquery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.Wfs20Factory;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMapping;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingBlockValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingContext;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingDefaultValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.ParameterMappingExpressionValue;
import org.geotools.data.wfs.internal.v2_0.storedquery.StoredQueryConfiguration;
import org.opengis.filter.Filter;

public class ParameterTypeFactory {
    private final StoredQueryConfiguration config;
    private final StoredQueryDescriptionType desc;
    private final FeatureTypeInfo featureTypeInfo;

    public ParameterTypeFactory(StoredQueryConfiguration config, StoredQueryDescriptionType desc, FeatureTypeInfo featureTypeInfo) {
        this.config = config;
        this.desc = desc;
        this.featureTypeInfo = featureTypeInfo;
    }

    public ParameterMapping getStoredQueryParameterMapping(String parameterName) {
        ParameterMapping ret = null;
        if (this.config == null || this.config.getStoredQueryParameterMappings() == null) {
            return ret;
        }
        for (ParameterMapping sqpm : this.config.getStoredQueryParameterMappings()) {
            if (!sqpm.getParameterName().equals(parameterName)) continue;
            ret = sqpm;
            break;
        }
        return ret;
    }

    public List<ParameterType> buildStoredQueryParameters(Map<String, String> viewParams, Filter filter) {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        if (filter == null) {
            filter = Filter.INCLUDE;
        }
        ParameterMappingContext mappingContext = new ParameterMappingContext(filter, viewParams, this.featureTypeInfo);
        ArrayList<ParameterType> ret = new ArrayList<ParameterType>();
        for (ParameterExpressionType parameter : this.desc.getParameter()) {
            String value = null;
            ParameterMapping mapping = this.getStoredQueryParameterMapping(parameter.getName());
            if (mapping != null && mapping.isForcible()) {
                value = this.evaluateMapping(mappingContext, mapping);
            } else {
                if (viewParams != null) {
                    value = viewParams.get(parameter.getName());
                }
                if (value == null && mapping != null) {
                    value = this.evaluateMapping(mappingContext, mapping);
                }
            }
            if (value == null) continue;
            ParameterType tmp = factory.createParameterType();
            tmp.setName(parameter.getName());
            tmp.setValue(value);
            ret.add(tmp);
        }
        return ret;
    }

    protected String evaluateMapping(ParameterMappingContext mappingContext, ParameterMapping mapping) {
        String value;
        if (mapping instanceof ParameterMappingDefaultValue) {
            value = ((ParameterMappingDefaultValue)mapping).getDefaultValue();
        } else if (mapping instanceof ParameterMappingExpressionValue) {
            value = ((ParameterMappingExpressionValue)mapping).evaluate(mappingContext);
        } else if (mapping instanceof ParameterMappingBlockValue) {
            value = null;
        } else {
            throw new IllegalArgumentException("Unknown StoredQueryParameterMapping: " + mapping.getClass());
        }
        return value;
    }
}

