/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.dynect.v3.domain.RecordId;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.json.internal.GsonWrapper;

public final class ToRecordIds
implements Function<HttpResponse, FluentIterable<RecordId>> {
    private final ParseFirstJsonValueNamed<FluentIterable<String>> parser;

    @Inject
    public ToRecordIds(GsonWrapper gsonView) {
        this.parser = new ParseFirstJsonValueNamed((GsonWrapper)Preconditions.checkNotNull((Object)gsonView, (Object)"gsonView"), (TypeLiteral)new TypeLiteral<FluentIterable<String>>(){}, new String[]{"data"});
    }

    public FluentIterable<RecordId> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        return ((FluentIterable)this.parser.apply(response)).transform((Function)ParsePath.INSTANCE);
    }

    static enum ParsePath implements Function<String, RecordId>
    {
        INSTANCE;

        public static final Pattern DEFAULT_PATTERN;

        public RecordId apply(String in) {
            Matcher matcher = DEFAULT_PATTERN.matcher(in);
            Preconditions.checkState((matcher.find() && matcher.groupCount() == 4 ? 1 : 0) != 0, (String)"%s didn't match %s", (Object[])new Object[]{in, DEFAULT_PATTERN});
            return ((RecordId.Builder)((RecordId.Builder)((RecordId.Builder)((RecordId.Builder)RecordId.recordIdBuilder().type(matcher.group(1))).zone(matcher.group(2))).fqdn(matcher.group(3))).id(Long.parseLong(matcher.group(4)))).build();
        }

        static {
            DEFAULT_PATTERN = Pattern.compile("/REST/([a-zA-Z]+)Record/(.*)/(.*)/([0-9]+)");
        }
    }
}

