/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.session.infinispan;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.infinispan.commons.api.BasicCache;

@ManagedObject
public class InfinispanSessionDataStore
extends AbstractSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private BasicCache<String, Object> _cache;
    private int _infinispanIdleTimeoutSec;

    public BasicCache<String, Object> getCache() {
        return this._cache;
    }

    public void setCache(BasicCache<String, Object> cache) {
        this._cache = cache;
    }

    public SessionData load(final String id) throws Exception {
        final AtomicReference reference = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        Runnable load = new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Loading session {} from infinispan", new Object[]{id});
                    }
                    SessionData sd = (SessionData)InfinispanSessionDataStore.this._cache.get((Object)InfinispanSessionDataStore.this.getCacheKey(id));
                    reference.set(sd);
                }
                catch (Exception e) {
                    exception.set(new UnreadableSessionDataException(id, InfinispanSessionDataStore.this._context, (Throwable)e));
                }
            }
        };
        this._context.run(load);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (SessionData)reference.get();
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting session with id {} from infinispan", new Object[]{id});
        }
        return this._cache.remove((Object)this.getCacheKey(id)) != null;
    }

    public Set<String> doGetExpired(Set<String> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        long now = System.currentTimeMillis();
        HashSet<String> expired = new HashSet<String>();
        for (String candidate : candidates) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking expiry for candidate {}", new Object[]{candidate});
            }
            try {
                SessionData sd = this.load(candidate);
                if (sd == null) {
                    expired.add(candidate);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Session {} does not exist in infinispan", new Object[]{candidate});
                    continue;
                }
                if (this._context.getWorkerName().equals(sd.getLastNode())) {
                    if (sd.getExpiry() <= 0L || sd.getExpiry() > now) continue;
                    expired.add(candidate);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Session {} managed by {} is expired", new Object[]{candidate, this._context.getWorkerName()});
                    continue;
                }
                if (this._lastExpiryCheckTime <= 0L) {
                    if (sd.getExpiry() <= 0L || sd.getExpiry() >= now - 1000L * (long)(3 * this._gracePeriodSec)) continue;
                    expired.add(candidate);
                    continue;
                }
                if (sd.getExpiry() <= 0L || sd.getExpiry() >= now - 1000L * (long)this._gracePeriodSec) continue;
                expired.add(candidate);
            }
            catch (Exception e) {
                LOG.warn("Error checking if candidate {} is expired", new Object[]{candidate, e});
            }
        }
        return expired;
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (data.getMaxInactiveMs() > 0L && this.getInfinispanIdleTimeoutSec() > 0) {
            this._cache.put((Object)this.getCacheKey(id), (Object)data, -1L, TimeUnit.MILLISECONDS, (long)this.getInfinispanIdleTimeoutSec(), TimeUnit.SECONDS);
        } else {
            this._cache.put((Object)this.getCacheKey(id), (Object)data);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session {} saved to infinispan, expires {} ", new Object[]{id, data.getExpiry()});
        }
    }

    public String getCacheKey(String id) {
        return this._context.getCanonicalContextPath() + "_" + this._context.getVhost() + "_" + id;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        try {
            Class<?> remoteClass = Thread.currentThread().getContextClassLoader().loadClass("org.infinispan.client.hotrod.RemoteCache");
            return remoteClass.isAssignableFrom(this._cache.getClass());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean exists(final String id) throws Exception {
        final AtomicBoolean reference = new AtomicBoolean();
        final AtomicReference exception = new AtomicReference();
        Runnable load = new Runnable(){

            @Override
            public void run() {
                try {
                    SessionData sd = InfinispanSessionDataStore.this.load(id);
                    if (sd == null) {
                        reference.set(false);
                        return;
                    }
                    if (sd.getExpiry() <= 0L) {
                        reference.set(true);
                    } else {
                        reference.set(sd.getExpiry() > System.currentTimeMillis());
                    }
                }
                catch (Exception e) {
                    exception.set(e);
                }
            }
        };
        this._context.run(load);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return reference.get();
    }

    public void setInfinispanIdleTimeoutSec(int sec) {
        this._infinispanIdleTimeoutSec = sec;
    }

    @ManagedAttribute(value="infinispan idle timeout sec", readonly=true)
    public int getInfinispanIdleTimeoutSec() {
        return this._infinispanIdleTimeoutSec;
    }

    public String toString() {
        return String.format("%s[cache=%s,idleTimeoutSec=%d]", super.toString(), this._cache == null ? "" : this._cache.getName(), this._infinispanIdleTimeoutSec);
    }
}

