/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.tools.cmdline;

import java.io.File;
import java.net.URL;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.StdOutAdminListener;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;

public class AddData {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            AddData._printUsage();
            return;
        }
        String systemConfFile = args[0];
        String repositoryID = args[1];
        LocalService service = Sesame.getService(new File(systemConfFile));
        service.getSystemConfig().setWorldWriteable(repositoryID, true);
        SesameRepository repository = service.getRepository(repositoryID);
        long startTime = System.currentTimeMillis();
        for (int i = 2; i < args.length; ++i) {
            String dataLoc = args[i];
            System.out.println("Adding file " + dataLoc);
            long fileStartTime = System.currentTimeMillis();
            StdOutAdminListener adminListener = new StdOutAdminListener();
            if (dataLoc.toLowerCase().startsWith("http")) {
                URL dataURL = new URL(dataLoc);
                repository.addData(dataURL, dataLoc, RDFFormat.RDFXML, true, (AdminListener)adminListener);
            } else {
                File dataFile = new File(dataLoc);
                repository.addData(dataFile, dataFile.toURI().toString(), RDFFormat.RDFXML, true, (AdminListener)adminListener);
            }
            long fileEndTime = System.currentTimeMillis();
            System.out.println("File added in " + (fileEndTime - fileStartTime) + " ms");
        }
        long endTime = System.currentTimeMillis();
        System.out.println("All files added in " + (endTime - startTime) + " ms");
    }

    private static void _printUsage() {
        System.err.println("Usage: java org.openrdf.tools.cmdline.AddData <system-conf-file> <repository-id> {<data-file>|<url>}");
    }
}

