/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.MethodLookupEngine;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatchers;

public class SubclassImplementationTarget
extends Implementation.Target.AbstractBase {
    protected final Map<TypeList, MethodDescription> superConstructors;
    protected final OriginTypeIdentifier originTypeIdentifier;

    protected SubclassImplementationTarget(MethodLookupEngine.Finding finding, BridgeMethodResolver.Factory bridgeMethodResolverFactory, OriginTypeIdentifier originTypeIdentifier) {
        super(finding, bridgeMethodResolverFactory);
        TypeDescription superType = finding.getTypeDescription().getSupertype();
        MethodList.Empty superConstructors = superType == null ? new MethodList.Empty() : (MethodList)superType.getDeclaredMethods().filter(ElementMatchers.isConstructor());
        this.superConstructors = new HashMap<TypeList, MethodDescription>(superConstructors.size());
        for (MethodDescription superConstructor : superConstructors) {
            this.superConstructors.put(superConstructor.getParameters().asTypeList(), superConstructor);
        }
        this.originTypeIdentifier = originTypeIdentifier;
    }

    @Override
    protected Implementation.SpecialMethodInvocation invokeSuper(MethodDescription methodDescription) {
        if (methodDescription.isConstructor() && (methodDescription = this.superConstructors.get(methodDescription.getParameters().asTypeList())) == null) {
            return Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
        }
        return Implementation.SpecialMethodInvocation.Simple.of(methodDescription, this.typeDescription.getSupertype());
    }

    @Override
    public TypeDescription getOriginType() {
        return this.originTypeIdentifier.identify(this.typeDescription);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.originTypeIdentifier == ((SubclassImplementationTarget)other).originTypeIdentifier;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.originTypeIdentifier.hashCode();
    }

    public String toString() {
        return "SubclassImplementationTarget{typeDescription=" + this.typeDescription + ", defaultMethods=" + this.defaultMethods + ", bridgeMethodResolver=" + this.bridgeMethodResolver + ", superConstructors=" + this.superConstructors + ", originTypeIdentifier=" + (Object)((Object)this.originTypeIdentifier) + '}';
    }

    public static class Factory
    implements Implementation.Target.Factory {
        private final BridgeMethodResolver.Factory bridgeMethodResolverFactory;
        private final OriginTypeIdentifier originTypeIdentifier;

        public Factory(BridgeMethodResolver.Factory bridgeMethodResolverFactory, OriginTypeIdentifier originTypeIdentifier) {
            this.bridgeMethodResolverFactory = bridgeMethodResolverFactory;
            this.originTypeIdentifier = originTypeIdentifier;
        }

        @Override
        public Implementation.Target make(MethodLookupEngine.Finding finding, List<? extends MethodDescription> instrumentedMethods) {
            return new SubclassImplementationTarget(finding, this.bridgeMethodResolverFactory, this.originTypeIdentifier);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.bridgeMethodResolverFactory.equals(((Factory)other).bridgeMethodResolverFactory) && this.originTypeIdentifier.equals((Object)((Factory)other).originTypeIdentifier);
        }

        public int hashCode() {
            return 31 * this.bridgeMethodResolverFactory.hashCode() + this.originTypeIdentifier.hashCode();
        }

        public String toString() {
            return "SubclassImplementationTarget.Factory{bridgeMethodResolverFactory=" + this.bridgeMethodResolverFactory + "originTypeIdentifier=" + (Object)((Object)this.originTypeIdentifier) + '}';
        }
    }

    public static enum OriginTypeIdentifier {
        SUPER_TYPE{

            @Override
            protected TypeDescription identify(TypeDescription typeDescription) {
                return typeDescription.getSupertype();
            }
        }
        ,
        LEVEL_TYPE{

            @Override
            protected TypeDescription identify(TypeDescription typeDescription) {
                return typeDescription;
            }
        };


        protected abstract TypeDescription identify(TypeDescription var1);

        public String toString() {
            return "SubclassImplementationTarget.OriginTypeIdentifier." + this.name();
        }
    }
}

