/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.harvester.wfsfeatures.worker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Exchange;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.fao.geonet.es.EsClient;
import org.fao.geonet.harvester.wfsfeatures.model.WFSHarvesterParameter;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSFeatureUtils;
import org.fao.geonet.harvester.wfsfeatures.worker.WFSHarvesterExchangeState;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class EsWFSFeatureIndexer {
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_START_REGEX = "<!\\[CDATA\\[";
    public static final String CDATA_END = "]]>";
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvest.wfs.features");
    @Value(value="${es.index.features}")
    private String index = "features";
    @Value(value="${es.index.features.type}")
    private String indexType = "features";
    @Value(value="${es.index.features.featureCommitInterval:300}")
    private int featureCommitInterval;
    @Value(value="${es.index.features.applyPrecisionModel:false}")
    private boolean applyPrecisionModel;
    @Value(value="${es.index.features.numberOfDecimals:7}")
    private int numberOfDecimals;
    @Autowired
    private EsClient client;
    private ObjectMapper jacksonMapper = new ObjectMapper();
    private int nbOfFeatures;
    private static final String DEFAULT_FIELDSUFFIX = "_s";
    private static final String TREE_FIELD_SUFFIX = "_tree";
    private static final String FEATURE_FIELD_PREFIX = "ft_";
    private static final Map<String, String> XSDTYPES_TO_FIELD_NAME_SUFFIX;
    private Map<String, String> featureAttributeToDocumentFieldNames = new LinkedHashMap<String, String>();

    public int getFeatureCommitInterval() {
        return this.featureCommitInterval;
    }

    public void setFeatureCommitInterval(int featureCommitInterval) {
        this.featureCommitInterval = featureCommitInterval;
    }

    public boolean isApplyPrecisionModel() {
        return this.applyPrecisionModel;
    }

    public void setApplyPrecisionModel(boolean applyPrecisionModel) {
        this.applyPrecisionModel = applyPrecisionModel;
    }

    public int getNumberOfDecimals() {
        return this.numberOfDecimals;
    }

    public void setNumberOfDecimals(int numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    public void initialize(Exchange exchange, boolean connect) throws InvalidArgumentException {
        WFSHarvesterParameter configuration = (WFSHarvesterParameter)exchange.getProperty("configuration");
        if (configuration == null) {
            throw new InvalidArgumentException("Missing WFS harvester configuration.");
        }
        LOGGER.info("Initializing harvester configuration for uuid '{}', url '{}', feature type '{}'. Exchange id is '{}'.", new Object[]{configuration.getMetadataUuid(), configuration.getUrl(), configuration.getTypeName(), exchange.getExchangeId()});
        WFSHarvesterExchangeState config = new WFSHarvesterExchangeState(configuration);
        if (connect) {
            try {
                config.initDataStore();
            }
            catch (Exception e) {
                String errorMsg = String.format("Failed to connect to server '%s'. Error is %s", configuration.getUrl(), e.getMessage());
                LOGGER.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        exchange.setProperty("featureTypeConfig", (Object)config);
    }

    public void deleteFeatures(Exchange exchange) {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        this.deleteFeatures(url, typeName, this.client);
    }

    public void deleteFeatures(String url, String typeName, EsClient client) {
        LOGGER.info("Deleting features previously index from service '{}' and feature type '{}' in index '{}/{}'", new Object[]{url, typeName, this.index, this.indexType});
        try {
            long begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+featureTypeId:\\\"%s\\\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Features deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
            begin = System.currentTimeMillis();
            client.deleteByQuery(this.index, String.format("+id:\\\"%s\\\"", this.getIdentifier(url, typeName)));
            LOGGER.info("  Report deleted in {} ms.", (Object)(System.currentTimeMillis() - begin));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error connecting to ES at '{}'. Error is {}.", (Object)this.index, (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFeatures(Exchange exchange) throws Exception {
        WFSHarvesterExchangeState state = (WFSHarvesterExchangeState)exchange.getProperty("featureTypeConfig");
        String url = state.getParameters().getUrl();
        String typeName = state.getParameters().getTypeName();
        Map<String, String> tokenizedFields = state.getParameters().getTokenizedFields();
        WFSDataStore wfs = state.getWfsDatastore();
        Map<String, String> featureAttributes = state.getFields();
        TitleResolver titleResolver = this.getTitleResolver(state);
        LOGGER.info("Indexing WFS features from service '{}' and feature type '{}'. Precision model applied: '{}', number of decimals: '{}'", new Object[]{url, typeName, this.applyPrecisionModel, this.numberOfDecimals});
        Report report = new Report(url, typeName);
        ObjectNode protoNode = this.createProtoNode(url, typeName);
        if (state.getParameters().getMetadataUuid() != null) {
            report.put("parent", state.getParameters().getMetadataUuid());
            protoNode.put("parent", state.getParameters().getMetadataUuid());
        }
        this.initFeatureAttributeToDocumentFieldNamesMapping(featureAttributes, state.getParameters().getTreeFields(), report);
        boolean initializeESReportSucceeded = report.saveHarvesterReport();
        if (!initializeESReportSucceeded) {
            LOGGER.error("couldn't initialize es report, don't even try to go further querying wfs.");
            throw new RuntimeException("couldn't initialize es report, don't even try to go further querying wfs.");
        }
        try {
            this.nbOfFeatures = 0;
            Phaser phaser = new Phaser();
            AsyncBulkResutHandler brh = new AsyncBulkResutHandler(phaser, typeName, url, this.nbOfFeatures, report);
            long begin = System.currentTimeMillis();
            ContentFeatureCollection fc = wfs.getFeatureSource(typeName).getFeatures();
            ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection((SimpleFeatureCollection)fc, CRS.decode((String)"urn:ogc:def:crs:OGC:1.3:CRS84"));
            try (SimpleFeatureIterator features = rfc.features();){
                while (features.hasNext()) {
                    try {
                        SimpleFeature feature = (SimpleFeature)features.next();
                        ObjectNode rootNode = protoNode.deepCopy();
                        titleResolver.setTitle(rootNode, feature);
                        for (String attributeName : featureAttributes.keySet()) {
                            Object attributeValue = feature.getAttribute(attributeName);
                            if (attributeValue == null) continue;
                            if (tokenizedFields != null && tokenizedFields.get(attributeName) != null) {
                                String rawValue = (String)attributeValue;
                                String value = rawValue.startsWith(CDATA_START) ? rawValue.replaceFirst(CDATA_START_REGEX, "").substring(0, rawValue.length() - CDATA_END.length() - CDATA_START.length()) : rawValue;
                                String separator = tokenizedFields.get(attributeName);
                                String[] tokens = value.split(separator);
                                ArrayNode arrayNode = this.jacksonMapper.createArrayNode();
                                for (String token : tokens) {
                                    arrayNode.add(token.trim());
                                }
                                rootNode.putPOJO(this.getDocumentFieldName(attributeName), (Object)arrayNode);
                                continue;
                            }
                            if (this.getDocumentFieldName(attributeName).equals("geom")) {
                                Geometry geom = (Geometry)feature.getDefaultGeometry();
                                if (this.applyPrecisionModel) {
                                    PrecisionModel precisionModel = new PrecisionModel(Math.pow(10.0, this.numberOfDecimals - 1));
                                    geom = GeometryPrecisionReducer.reduce((Geometry)geom, (PrecisionModel)precisionModel);
                                }
                                String gjson = new GeometryJSON(this.numberOfDecimals).toString(geom);
                                JsonNode jsonNode = this.jacksonMapper.readTree(gjson.getBytes(StandardCharsets.UTF_8));
                                rootNode.put(this.getDocumentFieldName(attributeName), jsonNode);
                                boolean isPoint = geom instanceof Point;
                                if (isPoint) {
                                    Coordinate point = geom.getCoordinate();
                                    rootNode.put("location", String.format("%s,%s", point.y, point.x));
                                } else {
                                    report.setPointOnlyForGeomsFalse();
                                }
                                BoundingBox bbox = feature.getBounds();
                                rootNode.put("bbox_xmin", bbox.getMinX());
                                rootNode.put("bbox_ymin", bbox.getMinY());
                                rootNode.put("bbox_xmax", bbox.getMaxX());
                                rootNode.put("bbox_ymax", bbox.getMaxY());
                                continue;
                            }
                            String value = attributeValue.toString();
                            rootNode.put(this.getDocumentFieldName(attributeName), value.startsWith(CDATA_START) ? value.replaceFirst(CDATA_START_REGEX, "").substring(0, value.length() - CDATA_END.length() - CDATA_START.length()) : value);
                        }
                        ++this.nbOfFeatures;
                        brh.addAction(rootNode, feature);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Error while creating document for {} feature {}. Exception is: {}", new Object[]{typeName, this.nbOfFeatures, ex.getMessage()});
                        report.put("error_ss", String.format("Error while creating document for %s feature %d. Exception is: %s", typeName, this.nbOfFeatures, ex.getMessage()));
                    }
                    if (brh.getBulkSize() < this.featureCommitInterval) continue;
                    ((BulkResutHandler)brh).launchBulk(this.client);
                    brh = new AsyncBulkResutHandler(phaser, typeName, url, this.nbOfFeatures, report);
                }
            }
            if (brh.getBulkSize() > 0) {
                ((BulkResutHandler)brh).launchBulk(this.client);
            }
            try {
                if (this.nbOfFeatures > 0) {
                    phaser.awaitAdvanceInterruptibly(0, 3L, TimeUnit.HOURS);
                }
            }
            catch (TimeoutException e) {
                throw new Exception("Timeout when awaiting all bulks to be processed.");
            }
            LOGGER.info("Total number of {} features indexed is {} in {} ms.", new Object[]{typeName, this.nbOfFeatures, System.currentTimeMillis() - begin});
            report.success(this.nbOfFeatures);
        }
        catch (Exception e) {
            report.put("status_s", "error");
            report.put("error_ss", e.getMessage());
            LOGGER.error(e.getMessage());
            throw e;
        }
        finally {
            report.saveHarvesterReport();
        }
    }

    private TitleResolver getTitleResolver(final WFSHarvesterExchangeState state) {
        String defaultTitleAttribute;
        final String titleExpression = state.getParameters().getTitleExpression();
        String string = defaultTitleAttribute = titleExpression == null ? WFSFeatureUtils.guessFeatureTitleAttribute(state.getFields()) : null;
        TitleResolver titleResolver = titleExpression != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                objectNode.put("resourceTitle", WFSFeatureUtils.buildFeatureTitle(simpleFeature, state.getFields(), titleExpression));
            }
        } : (defaultTitleAttribute != null ? new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
                objectNode.put("resourceTitle", simpleFeature.getAttribute(defaultTitleAttribute).toString());
            }
        } : new TitleResolver(){

            @Override
            public void setTitle(ObjectNode objectNode, SimpleFeature simpleFeature) {
            }
        });
        return titleResolver;
    }

    private ObjectNode createProtoNode(String url, String typeName) {
        ObjectNode protoNode = this.jacksonMapper.createObjectNode();
        protoNode.put("docType", "feature");
        protoNode.put("resourceType", "feature");
        protoNode.put("featureTypeId", this.getIdentifier(url, typeName));
        return protoNode;
    }

    private String getIdentifier(String url, String typeName) {
        try {
            return URLEncoder.encode(url + "#" + typeName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("  Can not build an URL encoded identifier from {}#{}. Exception is {}.", new Object[]{url, typeName, e.getMessage()});
            return null;
        }
    }

    private void initFeatureAttributeToDocumentFieldNamesMapping(Map<String, String> featureAttributes, List<String> treeFields, Report report) {
        for (String attributeName : featureAttributes.keySet()) {
            String attributeType = featureAttributes.get(attributeName);
            if (attributeType.equals("geometry")) {
                this.featureAttributeToDocumentFieldNames.put(attributeName, "geom");
                continue;
            }
            boolean isTree = treeFields != null ? treeFields.contains(attributeName) : false;
            this.featureAttributeToDocumentFieldNames.put(attributeName, String.join((CharSequence)"", FEATURE_FIELD_PREFIX, attributeName, XSDTYPES_TO_FIELD_NAME_SUFFIX.get(attributeType), isTree ? TREE_FIELD_SUFFIX : ""));
        }
        report.put("ftColumns_s", Joiner.on((String)"|").join(featureAttributes.keySet()));
        report.put("docColumns_s", Joiner.on((String)"|").join(this.featureAttributeToDocumentFieldNames.values()));
    }

    private String getDocumentFieldName(String attributeName) {
        return this.featureAttributeToDocumentFieldNames.get(attributeName);
    }

    static {
        try {
            Logging.ALL.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        XSDTYPES_TO_FIELD_NAME_SUFFIX = ImmutableMap.builder().put((Object)"integer", (Object)"_ti").put((Object)"string", (Object)DEFAULT_FIELDSUFFIX).put((Object)"double", (Object)"_d").put((Object)"boolean", (Object)"_b").put((Object)"date", (Object)"_dt").put((Object)"dateTime", (Object)"_dt").build();
    }

    class SyncBulkResutHandler
    extends BulkResutHandler {
        public SyncBulkResutHandler(Phaser phaser, String typeName, String url, int firstFeatureIndex, Report report) {
            super(phaser, typeName, url, firstFeatureIndex, report);
        }

        @Override
        public void launchBulk(EsClient client) {
            try {
                this.prepareLaunch();
                BulkResult result = client.bulkRequestSync(this.bulk);
                if (result.isSucceeded()) {
                    this.completed(result);
                } else {
                    this.failed(new Exception(result.getErrorMessage()));
                }
            }
            catch (IOException e) {
                this.failed(e);
            }
        }
    }

    class AsyncBulkResutHandler
    extends BulkResutHandler {
        public AsyncBulkResutHandler(Phaser phaser, String typeName, String url, int firstFeatureIndex, Report report) {
            super(phaser, typeName, url, firstFeatureIndex, report);
        }

        @Override
        public void launchBulk(EsClient client) {
            this.prepareLaunch();
            client.bulkRequestAsync(this.bulk, (JestResultHandler)this);
        }
    }

    abstract class BulkResutHandler
    implements JestResultHandler<BulkResult> {
        protected Phaser phaser;
        protected String typeName;
        private String url;
        protected int firstFeatureIndex;
        private Report report;
        protected long begin;
        protected Bulk.Builder bulk;
        protected int bulkSize;

        public BulkResutHandler(Phaser phaser, String typeName, String url, int firstFeatureIndex, Report report) {
            this.phaser = phaser;
            this.typeName = typeName;
            this.url = url;
            this.firstFeatureIndex = firstFeatureIndex;
            this.report = report;
            this.bulk = new Bulk.Builder().defaultIndex(EsWFSFeatureIndexer.this.index);
            this.bulkSize = 0;
            LOGGER.debug("  {} - from {}, {} features to index, preparing bulk.", new Object[]{typeName, firstFeatureIndex, EsWFSFeatureIndexer.this.featureCommitInterval});
        }

        public void completed(BulkResult bulkResult) {
            LOGGER.debug("  {} - from {}, {}/{} features, indexed in {} ms.", new Object[]{this.typeName, this.firstFeatureIndex, this.bulkSize, EsWFSFeatureIndexer.this.featureCommitInterval, System.currentTimeMillis() - this.begin});
            this.phaser.arriveAndDeregister();
        }

        public void failed(Exception e) {
            this.report.put("error_ss", String.format("Error while indexing %s block of documents [%d-%d]. Exception is: %s", this.typeName, this.firstFeatureIndex, this.firstFeatureIndex + EsWFSFeatureIndexer.this.featureCommitInterval, e.getMessage()));
            LOGGER.error("  {} - from {}, {}/{} features, NOT indexed in {} ms. ({}).", new Object[]{this.typeName, this.firstFeatureIndex, this.bulkSize, EsWFSFeatureIndexer.this.featureCommitInterval, System.currentTimeMillis() - this.begin, e.getMessage()});
            this.phaser.arriveAndDeregister();
        }

        public int getBulkSize() {
            return this.bulkSize;
        }

        public void addAction(ObjectNode rootNode, SimpleFeature feature) throws JsonProcessingException {
            String featureId = feature.getID();
            if (featureId.toLowerCase().indexOf("placeholder") > -1) {
                featureId = "fid-" + EsWFSFeatureIndexer.this.nbOfFeatures;
            }
            String id = String.format("%s#%s#%s", this.url, this.typeName, featureId);
            this.bulk.addAction((BulkableAction)((Index.Builder)new Index.Builder((Object)EsWFSFeatureIndexer.this.jacksonMapper.writeValueAsString((Object)rootNode)).id(id)).build());
            ++this.bulkSize;
        }

        protected void prepareLaunch() {
            this.phaser.register();
            this.begin = System.currentTimeMillis();
            LOGGER.debug("  {} - from {}, {}/{} features, launching bulk.", new Object[]{this.typeName, this.firstFeatureIndex, this.bulkSize, EsWFSFeatureIndexer.this.featureCommitInterval});
        }

        public abstract void launchBulk(EsClient var1);
    }

    class Report {
        private Map<String, Object> report = new HashMap<String, Object>();
        private String url;
        private String typeName;
        private boolean pointOnlyForGeoms;

        public Report(String url, String typeName) throws UnsupportedEncodingException {
            this.typeName = typeName;
            this.url = url;
            this.pointOnlyForGeoms = true;
            this.report.put("id", EsWFSFeatureIndexer.this.getIdentifier(url, typeName));
            this.report.put("docType", "harvesterReport");
        }

        public void put(String key, Object value) {
            this.report.put(key, value);
        }

        public void setPointOnlyForGeomsFalse() {
            this.pointOnlyForGeoms = false;
        }

        public void success(int nbOfFeatures) {
            this.report.put("status_s", "success");
            this.report.put("totalRecords_i", nbOfFeatures);
            DateTime dateTime = new DateTime(DateTimeZone.UTC);
            this.report.put("endDate_dt", String.format("%sT%s", ISODateTimeFormat.yearMonthDay().print((ReadableInstant)dateTime), ISODateTimeFormat.timeNoMillis().print((ReadableInstant)dateTime).replace("Z", "")));
            this.report.put("isPointOnly", this.pointOnlyForGeoms);
        }

        public boolean saveHarvesterReport() {
            Index search = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(this.report).index(EsWFSFeatureIndexer.this.index)).type("_doc")).id(this.report.get("id").toString())).build();
            try {
                DocumentResult response = (DocumentResult)EsWFSFeatureIndexer.this.client.getClient().execute((Action)search);
                if (response.getErrorMessage() != null) {
                    LOGGER.info("Failed to save report for {}. Error message when saving report was '{}'.", (Object)this.typeName, (Object)response.getErrorMessage());
                } else {
                    LOGGER.info("Report saved for service {} and typename {}. Report id is {}", new Object[]{this.url, this.typeName, this.report.get("id")});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static interface TitleResolver {
        public void setTitle(ObjectNode var1, SimpleFeature var2);
    }
}

