/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.neovisionaries.i18n.LanguageCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jeeves.component.ProfileManager;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.attachments.FilesystemStoreResourceContainer;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.IsoLanguage;
import org.fao.geonet.domain.LinkStatus;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.UiSetting;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.CodeListTranslator;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.kernel.url.UrlChecker;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UiSettingsRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.util.GMLParsers;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xsd.Parser;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.owasp.esapi.errors.EncodingException;
import org.owasp.esapi.reference.DefaultEncoder;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Node;

public final class XslUtil {
    private static final char TS_DEFAULT = ' ';
    private static final char CS_DEFAULT = ',';
    private static final char TS_WKT = ',';
    private static final char CS_WKT = ' ';
    private static ThreadLocal<Boolean> allowScripting = new InheritableThreadLocal<Boolean>();
    private static final Random RANDOM = new Random();
    private static final Cache<String, Integer> URL_VALIDATION_CACHE = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(25L, TimeUnit.HOURS).build();

    public static String clean(Object src) {
        String result = src.toString().replaceAll("'", "'").replaceAll("[><\n\r]", " ");
        return result;
    }

    public static String countryMatch(Object src, Object pattern) {
        if (src.toString().trim().length() == 0) {
            return "false";
        }
        boolean result = src.toString().toLowerCase().contains(pattern.toString().toLowerCase());
        return String.valueOf(result);
    }

    public static String replace(Object src, Object pattern, Object substitution) {
        String result = src.toString().replaceAll(pattern.toString(), substitution.toString());
        return result;
    }

    public static boolean isCasEnabled() {
        return ProfileManager.isCasEnabled();
    }

    public static String getConfigValue(String key) {
        if (key == null) {
            return "";
        }
        ServiceConfig config = (ServiceConfig)ApplicationContextHolder.get().getBean(ServiceConfig.class);
        if (config != null) {
            String value = config.getValue(key);
            if (value != null) {
                return value;
            }
            return "";
        }
        return "";
    }

    public static String getBuildNumber() {
        return ((SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class)).getScmRevision();
    }

    public static String getUiConfiguration(String key) {
        String nodeId = "srv";
        try {
            NodeInfo nodeInfo = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
            nodeId = nodeInfo.getId();
        }
        catch (BeanCreationException nodeInfo) {
            // empty catch block
        }
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        UiSettingsRepository uiSettingsRepository = (UiSettingsRepository)ApplicationContextHolder.get().getBean(UiSettingsRepository.class);
        Source portal = (Source)sourceRepository.findOne((Serializable)((Object)nodeId));
        if (uiSettingsRepository != null) {
            UiSetting one = null;
            if (portal != null && StringUtils.isNotEmpty((String)portal.getUiConfig())) {
                one = (UiSetting)uiSettingsRepository.findOne((Serializable)((Object)portal.getUiConfig()));
            } else if (StringUtils.isNotEmpty((String)key)) {
                one = (UiSetting)uiSettingsRepository.findOne((Serializable)((Object)key));
            } else if (one == null) {
                one = (UiSetting)uiSettingsRepository.findOne((Serializable)((Object)"srv"));
            }
            if (one != null) {
                return one.getConfiguration();
            }
            return "{}";
        }
        return "{}";
    }

    public static String getUiConfigurationJsonProperty(String key, String path) {
        String json = XslUtil.getUiConfiguration(key);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Object jsonObj = objectMapper.readValue(json, Object.class);
            Object value = PropertyUtils.getProperty((Object)jsonObj, (String)path);
            if (value != null) {
                return value.toString();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getSettingValue(String key) {
        if (key == null) {
            return "";
        }
        SettingManager settingsMan = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (settingsMan != null) {
            String value = "nodeUrl".equals(key) ? settingsMan.getNodeURL() : settingsMan.getValue(key);
            if (value != null) {
                return value;
            }
            return "";
        }
        return "";
    }

    public static String getNodeName(String key, String lang, boolean withOrganization) {
        SourceRepository sourceRepository;
        Source source;
        SettingManager settingsMan = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (StringUtils.isEmpty((String)key)) {
            key = ((NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class)).getId();
        }
        if ("srv".equals(key)) {
            key = settingsMan.getSiteId();
        }
        return (source = (Source)(sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class)).findOne((Serializable)((Object)key))) != null ? source.getLabel(lang) : settingsMan.getSiteName() + (withOrganization ? " - " + settingsMan.getValue("system/site/organization") : "");
    }

    public static String getJsonSettingValue(String key, String path) {
        if (key == null) {
            return "";
        }
        try {
            SettingManager settingsMan;
            ServiceContext serviceContext = ServiceContext.get();
            if (serviceContext != null && (settingsMan = serviceContext.getBean(SettingManager.class)) != null) {
                String json = settingsMan.getValue(key);
                if (StringUtils.isEmpty((String)json)) {
                    return "";
                }
                ObjectMapper objectMapper = new ObjectMapper();
                Object jsonObj = objectMapper.readValue(json, Object.class);
                Object value = PropertyUtils.getProperty((Object)jsonObj, (String)path);
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("XslUtil getJsonSettingValue '" + key + "' error: " + e.getMessage()), (Throwable)e);
        }
        return "";
    }

    public static Node downloadJsonAsXML(String url) {
        HttpGet httpGet = new HttpGet(url);
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            String jsonResponse = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)String.valueOf(StandardCharsets.UTF_8)).trim();
            Element element = Xml.getXmlFromJSON((String)jsonResponse);
            DOMOutputter outputter = new DOMOutputter();
            return outputter.output(new Document(element));
        }
        catch (IOException | JDOMException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAuthenticated() throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || AnonymousAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            return false;
        }
        return authentication.isAuthenticated();
    }

    public static boolean isDisableLoginForm() {
        SecurityProviderConfiguration securityProviderConfiguration = SecurityProviderConfiguration.get();
        if (securityProviderConfiguration != null) {
            return securityProviderConfiguration.getLoginType().equals(SecurityProviderConfiguration.LoginType.AUTOLOGIN.toString().toLowerCase()) || securityProviderConfiguration.getLoginType().equals(SecurityProviderConfiguration.LoginType.LINK.toString().toLowerCase());
        }
        return false;
    }

    public static boolean isShowLoginAsLink() {
        SecurityProviderConfiguration securityProviderConfiguration = SecurityProviderConfiguration.get();
        if (securityProviderConfiguration != null) {
            return securityProviderConfiguration.getLoginType().equals(SecurityProviderConfiguration.LoginType.LINK.toString().toLowerCase());
        }
        return false;
    }

    public static boolean isUserProfileUpdateEnabled() {
        SecurityProviderConfiguration securityProviderConfiguration = SecurityProviderConfiguration.get();
        if (securityProviderConfiguration != null) {
            return securityProviderConfiguration.isUserProfileUpdateEnabled();
        }
        return true;
    }

    public static boolean isUserGroupUpdateEnabled() {
        SecurityProviderConfiguration securityProviderConfiguration = SecurityProviderConfiguration.get();
        if (securityProviderConfiguration != null) {
            return securityProviderConfiguration.isUserGroupUpdateEnabled();
        }
        return true;
    }

    public static String getSecurityProvider() {
        SecurityProviderConfiguration securityProviderConfiguration = SecurityProviderConfiguration.get();
        if (securityProviderConfiguration != null) {
            return securityProviderConfiguration.getSecurityProvider();
        }
        return "";
    }

    public static MetadataResourceContainer getResourceContainerDescription(String metadataUuid, Boolean approved) throws Exception {
        Store store = (Store)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)ApplicationContextHolder.get().getBeanFactory(), Store.class, (String)"filesystemStore");
        if (store != null) {
            if (store.getResourceManagementExternalProperties() != null && store.getResourceManagementExternalProperties().isFolderEnabled()) {
                ServiceContext context = ServiceContext.get();
                return store.getResourceContainerDescription(ServiceContext.get(), metadataUuid, approved);
            }
            return new FilesystemStoreResourceContainer(metadataUuid, -1, null, null, null, approved);
        }
        Log.error((String)"geonetwork.resources", (Object)"Could not locate a Store bean in getResourceContainerDescription");
        return null;
    }

    public static Store.ResourceManagementExternalProperties getResourceManagementExternalProperties() {
        Store store = (Store)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)ApplicationContextHolder.get().getBeanFactory(), Store.class, (String)"filesystemStore");
        if (store != null) {
            return store.getResourceManagementExternalProperties();
        }
        Log.error((String)"geonetwork.resources", (Object)"Could not locate a Store bean in getResourceManagementExternalProperties");
        return null;
    }

    public static boolean isAccessibleService(Object serviceName) {
        return ProfileManager.isAccessibleService(serviceName);
    }

    public static String takeUntil(Object src, Object pattern) {
        String src2 = src.toString();
        Matcher matcher = Pattern.compile(pattern.toString()).matcher(src2);
        if (!matcher.find()) {
            return src2;
        }
        int index = matcher.start();
        if (index == -1) {
            return src2;
        }
        return src2.substring(0, index);
    }

    public static String xmlToJson(Object xml) {
        try {
            return Xml.getJSON((String)xml.toString());
        }
        catch (IOException e) {
            Log.error((String)"geonetwork", (Object)("XMLtoJSON conversion I/O error. Error is " + e.getMessage() + ". XML is " + xml.toString()));
            return "";
        }
    }

    public static String toWktCoords(Object coords, Object ts, Object cs) {
        String coordsString = coords.toString();
        char tsString = ts == null || ts.toString().length() == 0 ? (char)' ' : (char)ts.toString().charAt(0);
        char csString = cs == null || cs.toString().length() == 0 ? (char)',' : (char)cs.toString().charAt(0);
        if (tsString == ',' && csString == ' ') {
            return coordsString;
        }
        if (tsString == ' ') {
            tsString = ';';
            coordsString = coordsString.replace(' ', tsString);
        }
        coordsString = coordsString.replace(csString, ' ');
        String result = coordsString.replace(tsString, ',');
        char lastChar = result.charAt(result.length() - 1);
        if (result.charAt(result.length() - 1) == ',' || lastChar == ' ') {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String posListToWktCoords(Object coords, Object dim) {
        int dimension;
        String[] coordsString = coords.toString().split(" ");
        if (dim == null) {
            dimension = 2;
        } else {
            try {
                dimension = Integer.parseInt(dim.toString());
            }
            catch (NumberFormatException e) {
                dimension = 2;
            }
        }
        StringBuilder results = new StringBuilder();
        for (int i = 0; i < coordsString.length; ++i) {
            if (i > 0 && i % dimension == 0) {
                results.append(',');
            } else if (i > 0) {
                results.append(' ');
            }
            results.append(coordsString[i]);
        }
        return results.toString();
    }

    public static String getIndexField(Object appName, Object uuid, Object field, Object lang) {
        String id = uuid.toString();
        String fieldname = field.toString();
        String language = lang.toString().equals("") ? null : lang.toString();
        try {
            String fieldValue = LuceneSearcher.getMetadataFromIndex(language, id, fieldname);
            if (fieldValue == null) {
                return XslUtil.getIndexFieldById(appName, uuid, field, lang);
            }
            return fieldValue;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Failed to get index field '" + fieldname + "' value on '" + id + "', caused by " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    public static String getIndexFieldById(Object appName, Object id, Object field, Object lang) {
        String fieldname = field.toString();
        String language = lang.toString().equals("") ? null : lang.toString();
        try {
            String fieldValue = LuceneSearcher.getMetadataFromIndexById(language, id.toString(), fieldname);
            return fieldValue == null ? "" : fieldValue;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Failed to get index field value caused by " + e.getMessage()));
            return "";
        }
    }

    public static String getIndexFieldByIdAllValues(Object appName, Object id, Object field, Object lang) {
        String fieldname = field.toString();
        String language = lang.toString().equals("") ? null : lang.toString();
        try {
            Map<String, Map<String, String>> fieldValues = LuceneSearcher.getAllMetadataFromIndexFor(language, "_uuid", id.toString(), Collections.singleton(fieldname), false, true);
            if (fieldValues.isEmpty()) {
                return "";
            }
            Map<String, String> values = fieldValues.values().iterator().next();
            return values.get(fieldname);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Failed to get index field value caused by " + e.getMessage()));
            return "";
        }
    }

    public static String getCodelistTranslation(Object codelist, Object value, Object langCode) {
        String codeListValue = (String)value;
        if (codeListValue != null && codelist != null && langCode != null) {
            String translation = codeListValue;
            try {
                CodeListTranslator t = new CodeListTranslator((SchemaManager)ApplicationContextHolder.get().getBean(SchemaManager.class), (String)langCode, (String)codelist);
                translation = t.translate(codeListValue);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork", (Object)String.format("Failed to translate codelist value '%s' in language '%s'. Error is %s", codeListValue, langCode, e.getMessage()));
            }
            return translation;
        }
        return "";
    }

    @Nonnull
    public static String iso639_2B_to_iso639_2T(String iso639_2B) {
        return IsoLanguagesMapper.iso639_2B_to_iso639_2T(iso639_2B);
    }

    @Nonnull
    public static String iso639_2T_to_iso639_2B(String iso639_2T) {
        return IsoLanguagesMapper.iso639_2T_to_iso639_2B(iso639_2T);
    }

    @Nonnull
    public static String twoCharLangCode(String iso3LangCode) {
        return XslUtil.twoCharLangCode(iso3LangCode, XslUtil.twoCharLangCode("eng", null));
    }

    @Nonnull
    public static String twoCharLangCode(String iso3LangCode, String defaultValue) {
        LanguageCode languageCode;
        if (iso3LangCode == null || iso3LangCode.length() == 0) {
            if (defaultValue != null) {
                return defaultValue;
            }
            iso3LangCode = "eng";
        }
        String iso2LangCode = null;
        if (iso3LangCode.length() > 3 && iso3LangCode.indexOf(59) != -1) {
            iso3LangCode = iso3LangCode.split(";")[0].trim();
        }
        if ((languageCode = LanguageCode.getByCode((String)iso3LangCode.toLowerCase())) != null) {
            iso2LangCode = languageCode.name();
        }
        if (iso2LangCode == null) {
            Log.info((String)"geonetwork", (Object)("Cannot convert " + iso3LangCode + " to 2 char iso lang code"), (Throwable)new Error());
            return iso3LangCode.substring(0, 2);
        }
        return iso2LangCode;
    }

    public static String getUrlStatus(String url) {
        UrlChecker urlChecker = (UrlChecker)ApplicationContextHolder.get().getBean(UrlChecker.class);
        LinkStatus urlStatus = urlChecker.getUrlStatus(url);
        if (urlStatus.getStatusValue().equalsIgnoreCase("4XX") || urlStatus.getStatusValue().equalsIgnoreCase("310")) {
            return urlStatus.getStatusInfo();
        }
        return urlStatus.getStatusValue();
    }

    public static String threeCharLangCode(String langCode) {
        if (langCode == null || langCode.length() < 2) {
            return "eng";
        }
        if (langCode.length() == 3) {
            return langCode;
        }
        IsoLanguagesMapper mapper = (IsoLanguagesMapper)ApplicationContextHolder.get().getBean(IsoLanguagesMapper.class);
        return mapper.iso639_1_to_iso639_2(langCode);
    }

    public static boolean match(Object src, Object pattern) {
        if (src == null || src.toString().trim().isEmpty()) {
            return false;
        }
        return src.toString().matches(pattern.toString());
    }

    public static void setNoScript() {
        allowScripting.set(false);
    }

    public static boolean allowScripting() {
        return allowScripting.get() == null || allowScripting.get() != false;
    }

    public static String getUserDetails(Object contactIdentifier) {
        String contactDetails = "";
        int contactId = Integer.parseInt((String)contactIdentifier);
        User user = (User)((UserRepository)ApplicationContextHolder.get().getBean(UserRepository.class)).findOne((Serializable)Integer.valueOf(contactId));
        if (user != null) {
            contactDetails = Xml.getString((Element)user.asXml());
        }
        return contactDetails;
    }

    public static String reprojectCoords(Object minx, Object miny, Object maxx, Object maxy, Object fromEpsg) {
        String ret = "";
        try {
            Element elemmaxy;
            Element elemminy;
            Element elemmaxx;
            Element elemminx;
            Double minxf = new Double((String)minx);
            Double minyf = new Double((String)miny);
            Double maxxf = new Double((String)maxx);
            Double maxyf = new Double((String)maxy);
            CoordinateReferenceSystem fromCrs = CRS.decode((String)((String)fromEpsg));
            CoordinateReferenceSystem toCrs = CRS.decode((String)"EPSG:4326");
            ReferencedEnvelope env = new ReferencedEnvelope(minxf.doubleValue(), maxxf.doubleValue(), minyf.doubleValue(), maxyf.doubleValue(), fromCrs);
            ReferencedEnvelope reprojected = env.transform(toCrs, true);
            ret = reprojected.getMinX() + "," + reprojected.getMinY() + "," + reprojected.getMaxX() + "," + reprojected.getMaxY();
            Element elemRet = new Element("EX_GeographicBoundingBox", ISO19139Namespaces.GMD);
            boolean forceXY = Boolean.getBoolean(System.getProperty("org.geotools.referencing.forceXY", "false"));
            if (forceXY) {
                elemminx = new Element("westBoundLongitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMinX()));
                elemmaxx = new Element("eastBoundLongitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMaxX()));
                elemminy = new Element("southBoundLatitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMinY()));
                elemmaxy = new Element("northBoundLatitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMaxY()));
            } else {
                elemminx = new Element("westBoundLongitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMinY()));
                elemmaxx = new Element("eastBoundLongitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMaxY()));
                elemminy = new Element("southBoundLatitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMinX()));
                elemmaxy = new Element("northBoundLatitude", ISO19139Namespaces.GMD).addContent((Content)new Element("Decimal", ISO19139Namespaces.GCO).setText("" + reprojected.getMaxX()));
            }
            elemRet.addContent((Content)elemminx);
            elemRet.addContent((Content)elemmaxx);
            elemRet.addContent((Content)elemminy);
            elemRet.addContent((Content)elemmaxy);
            ret = Xml.getString((Element)elemRet);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static String geomToBbox(Object geom) {
        String ret = "";
        try {
            String gml = (String)geom;
            Element geomElement = Xml.loadString((String)gml, (boolean)false);
            String srs = geomElement.getAttributeValue("srsName");
            DefaultGeographicCRS geomSrs = DefaultGeographicCRS.WGS84;
            if (srs != null && !srs.equals("")) {
                geomSrs = CRS.decode((String)srs);
            }
            Parser parser = GMLParsers.create(geomElement);
            MultiPolygon jts = SpatialIndexWriter.parseGml(parser, gml);
            if (!CRS.equalsIgnoreMetadata((Object)geomSrs, (Object)DefaultGeographicCRS.WGS84)) {
                MathTransform tform = CRS.findMathTransform((CoordinateReferenceSystem)geomSrs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                jts = (MultiPolygon)JTS.transform((Geometry)jts, (MathTransform)tform);
            }
            Envelope envelope = jts.getEnvelopeInternal();
            return String.format(Locale.US, "%f|%f|%f|%f", envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
        }
        catch (Throwable throwable) {
            return ret;
        }
    }

    public static Node getRecord(String uuid) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        DataManager dataManager = (DataManager)applicationContext.getBean(DataManager.class);
        try {
            String id = dataManager.getMetadataId(uuid);
            if (id != null) {
                Element metadata = dataManager.getMetadata(id);
                DOMOutputter outputter = new DOMOutputter();
                return outputter.output(new Document(metadata));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("XslUtil getRecord '" + uuid + "' error: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    public static Double evaluate(String formula, String parameters) {
        try {
            HashMap variables = new HashMap();
            Arrays.stream(parameters.split("\\|")).forEach(e -> {
                String[] tokens = e.trim().split("=");
                if (tokens.length == 2) {
                    variables.put(tokens[0], Double.valueOf(tokens[1].trim()));
                }
            });
            Expression e2 = new ExpressionBuilder(formula).variables(variables.keySet()).build().setVariables(variables);
            return e2.evaluate();
        }
        catch (Exception e3) {
            Log.error((String)"geonetwork", (Object)("XslUtil evaluate '" + formula + "' error: " + e3.getMessage()), (Throwable)e3);
            return null;
        }
    }

    public static String getSiteUrl() {
        ServiceContext context = ServiceContext.get();
        String baseUrl = "";
        if (context != null) {
            baseUrl = context.getBaseUrl();
        }
        SettingInfo si = new SettingInfo();
        return si.getSiteUrl() + (!baseUrl.startsWith("/") ? "/" : "") + baseUrl;
    }

    @Nonnull
    public static String getDefaultLangCode() {
        return "eng";
    }

    public static String getLanguage() {
        ServiceContext context = ServiceContext.get();
        if (context != null) {
            return context.getLanguage();
        }
        return "eng";
    }

    public static String encodeForJavaScript(String str) {
        return DefaultEncoder.getInstance().encodeForJavaScript(str);
    }

    public static String encodeForHTML(String str) {
        return DefaultEncoder.getInstance().encodeForHTML(str);
    }

    public static String md5Hex(String str) {
        return DigestUtils.md5Hex((String)str);
    }

    public static String encodeForURL(String str) {
        try {
            return DefaultEncoder.getInstance().encodeForURL(str);
        }
        catch (EncodingException ex) {
            Log.error((String)"geonetwork", (Object)("XslUtil encode for URL '" + str + "' error: " + ex.getMessage()), (Throwable)ex);
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Node getUrlContent(String surl) {
        org.w3c.dom.Document document;
        Node res = null;
        InputStream is = null;
        ServiceContext context = ServiceContext.get();
        try {
            URL url = new URL(surl);
            HttpURLConnection conn = Lib.net.setupProxy(context, url);
            int status = conn.getResponseCode();
            if (status != 200) {
                if (status == 302 || status == 301 || status == 303) {
                    url = new URL(conn.getHeaderField("Location"));
                }
                conn = (HttpURLConnection)url.openConnection();
            }
            is = conn.getInputStream();
            SAXBuilder builder = Xml.getSAXBuilder((boolean)false);
            Document jdoc = builder.build(is);
            DOMOutputter outputter = new DOMOutputter();
            document = outputter.output(jdoc);
        }
        catch (Throwable e) {
            try {
                Log.error((String)"geonetwork", (Object)("Failed fetching url: " + surl), (Throwable)e);
                return res;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return document;
    }

    public static String decodeURLParameter(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork", (Object)("XslUtil decodeURLParameter '" + str + "' error: " + ex.getMessage()), (Throwable)ex);
            return str;
        }
    }

    public static String randomId() {
        return "N" + RANDOM.nextInt(Integer.MAX_VALUE);
    }

    public static String getMax(Object values) {
        String[] strings = values.toString().split(" ");
        String max = "";
        for (int i = 0; i < strings.length; ++i) {
            String val = strings[i];
            if (val.compareTo(max) <= 0) continue;
            max = val;
        }
        return max;
    }

    public static Integer getURLStatus(final String urlString) throws ExecutionException {
        return (Integer)URL_VALIDATION_CACHE.get((Object)urlString, (Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                try {
                    return Integer.parseInt(XslUtil.getUrlStatus(urlString));
                }
                catch (Exception e) {
                    Log.info((String)"geonetwork", (Object)"validateURL: exception - ", (Throwable)e);
                    return -1;
                }
            }
        });
    }

    public static String getURLStatusAsString(String urlString) throws ExecutionException {
        Integer status = XslUtil.getURLStatus(urlString);
        return status == -1 ? "UNKNOWN" : String.format("%s (%d)", HttpStatus.valueOf((int)status).name(), status);
    }

    public static boolean validateURL(String urlString) throws ExecutionException {
        Integer status = XslUtil.getURLStatus(urlString);
        return status == -1 ? false : status / 100 == 2;
    }

    public static String getThesaurusDir() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ThesaurusManager thesaurusManager = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
        return thesaurusManager.getThesauriDirectory().toString();
    }

    public static String getIsoLanguageLabel(String code, String language) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        IsoLanguageRepository isoLanguageRepository = (IsoLanguageRepository)applicationContext.getBean(IsoLanguageRepository.class);
        List languageValues = isoLanguageRepository.findAllByCode(code);
        String languageLabel = code;
        if (!languageValues.isEmpty()) {
            languageLabel = (String)((IsoLanguage)languageValues.get(0)).getLabelTranslations().get(language);
        }
        return languageLabel;
    }
}

