/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.classifier;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.search.classifier.Classifier;
import org.fao.geonet.kernel.search.facet.CategoryHelper;

public abstract class AbstractTerm
implements Classifier {
    private ThesaurusFinder finder;
    private String conceptScheme;
    private String languageToIndex;

    protected AbstractTerm(ThesaurusFinder finder, String conceptScheme) {
        this.finder = finder;
        this.conceptScheme = conceptScheme;
    }

    protected void setLanguageToIndex(String language) {
        this.languageToIndex = language;
    }

    protected List<CategoryPath> classifyUri(String uri) {
        ArrayList<CategoryPath> result = new ArrayList<CategoryPath>();
        Thesaurus thesaurus = this.getThesaurus();
        if (thesaurus.hasKeyword(uri)) {
            KeywordBean term = thesaurus.getKeyword(uri, this.getLanguages());
            result.addAll(this.classify(term));
        }
        return result;
    }

    protected Thesaurus getThesaurus() {
        return this.finder.getThesaurusByConceptScheme(this.conceptScheme);
    }

    private List<CategoryPath> classify(KeywordBean term) {
        ArrayList<CategoryPath> result = new ArrayList<CategoryPath>();
        Thesaurus thesaurus = this.getThesaurus();
        if (thesaurus.hasBroader(term.getUriCode())) {
            result.addAll(this.classifyTermWithBroaderTerms(term));
        } else {
            result.add(this.classifyTermWithNoBroaderTerms(term));
        }
        return result;
    }

    private List<CategoryPath> classifyTermWithBroaderTerms(KeywordBean term) {
        ArrayList<CategoryPath> result = new ArrayList<CategoryPath>();
        for (CategoryPath categoryPathToBroaderTerm : this.classifyBroaderTerms(term)) {
            CategoryPath categoryPathToTerm = CategoryHelper.addSubCategory(categoryPathToBroaderTerm, this.getCategoryToIndex(term));
            result.add(categoryPathToTerm);
        }
        return result;
    }

    private List<CategoryPath> classifyBroaderTerms(KeywordBean term) {
        ArrayList<CategoryPath> result = new ArrayList<CategoryPath>();
        Thesaurus thesaurus = this.getThesaurus();
        for (KeywordBean broaderTerm : thesaurus.getBroader(term.getUriCode(), this.getLanguages())) {
            result.addAll(this.classify(broaderTerm));
        }
        return result;
    }

    private CategoryPath classifyTermWithNoBroaderTerms(KeywordBean term) {
        return new CategoryPath(new String[]{this.getCategoryToIndex(term)});
    }

    private String getCategoryToIndex(KeywordBean term) {
        if (this.indexUri()) {
            return term.getUriCode();
        }
        return term.getPreferredLabel(this.languageToIndex);
    }

    private boolean indexUri() {
        return this.languageToIndex == null || this.languageToIndex.isEmpty();
    }

    private String[] getLanguages() {
        if (this.indexUri()) {
            return new String[0];
        }
        return new String[]{this.languageToIndex};
    }
}

