/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.schema.ComplexTypeEntry;
import org.fao.geonet.kernel.schema.ElementInfo;
import org.fao.geonet.kernel.schema.Logger;
import org.fao.geonet.kernel.schema.SimpleTypeEntry;
import org.fao.geonet.utils.Log;
import org.jdom.Attribute;
import org.jdom.Element;

class ElementEntry {
    public String name;
    public String ns;
    public String type;
    public int min = 1;
    public int max = 1;
    public String substGroup;
    public String substGroupNS;
    public String ref;
    public boolean abstrElem;
    public boolean choiceElem;
    public boolean groupElem;
    public boolean sequenceElem;
    public ArrayList<ElementEntry> alContainerElems = new ArrayList();
    public ComplexTypeEntry complexType;
    public SimpleTypeEntry simpleType;

    private ElementEntry() {
    }

    public ElementEntry(Element el, Path file, String targetNS, String targetNSPrefix) {
        this(new ElementInfo(el, file, targetNS, targetNSPrefix));
    }

    public ElementEntry(ElementInfo ei) {
        this.ns = ei.targetNS;
        this.handleAttribs(ei);
        if (this.choiceElem) {
            this.handleContainerChildren(ei, this.alContainerElems);
        } else if (this.sequenceElem) {
            this.handleContainerChildren(ei, this.alContainerElems);
        } else {
            this.handleChildren(ei);
        }
    }

    public ElementEntry copy() {
        ElementEntry ee = new ElementEntry();
        ee.name = this.name;
        ee.ns = this.ns;
        ee.type = this.type;
        ee.min = this.min;
        ee.max = this.max;
        ee.substGroup = this.substGroup;
        ee.substGroupNS = this.substGroupNS;
        ee.ref = this.ref;
        ee.abstrElem = this.abstrElem;
        ee.complexType = this.complexType;
        ee.simpleType = this.simpleType;
        ee.choiceElem = this.choiceElem;
        ee.groupElem = this.groupElem;
        ee.sequenceElem = this.sequenceElem;
        ee.alContainerElems = this.alContainerElems;
        return ee;
    }

    public String toString() {
        return "ElementEntry name: " + this.name + " ref: " + this.ref + " type: " + this.type + " abstract: " + this.abstrElem + " choice: " + this.choiceElem + " group: " + this.groupElem + " sequence: " + this.sequenceElem;
    }

    private void handleAttribs(ElementInfo ei) {
        if (ei.element.getName().equals("choice")) {
            this.choiceElem = true;
        } else if (ei.element.getName().equals("group")) {
            this.groupElem = true;
        } else if (ei.element.getName().equals("sequence")) {
            this.sequenceElem = true;
        }
        List attrs = ei.element.getAttributes();
        for (Attribute at : attrs) {
            String attrName = at.getName();
            String value = at.getValue();
            if (attrName.equals("name")) {
                this.name = at.getValue();
                if (this.name.indexOf(58) != -1 || ei.targetNSPrefix == null) continue;
                this.name = ei.targetNSPrefix + ":" + at.getValue();
                continue;
            }
            if (attrName.equals("type")) {
                this.type = value;
                continue;
            }
            if (attrName.equals("ref")) {
                this.ref = value;
                continue;
            }
            if (attrName.equals("substitutionGroup")) {
                this.substGroup = value;
                continue;
            }
            if (attrName.equals("abstract")) {
                this.abstrElem = "true".equals(value);
                continue;
            }
            if (attrName.equals("minOccurs")) {
                this.min = Integer.parseInt(value);
                continue;
            }
            if (!attrName.equals("maxOccurs")) continue;
            if (value.equals("unbounded")) {
                this.max = 10000;
                continue;
            }
            this.max = Integer.parseInt(value);
        }
    }

    private void handleChildren(ElementInfo ei) {
        List children = ei.element.getChildren();
        for (Element elChild : children) {
            String elName = elChild.getName();
            if (elName.equals("complexType")) {
                this.complexType = new ComplexTypeEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                continue;
            }
            if (elName.equals("simpleType")) {
                this.simpleType = new SimpleTypeEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix);
                if (this.simpleType.name != null) continue;
                this.simpleType.name = this.name + "HASHS";
                continue;
            }
            if (elName.equals("key")) {
                Logger.log();
                continue;
            }
            if (elName.equals("annotation")) continue;
            Logger.log();
        }
    }

    private void handleContainerChildren(ElementInfo ei, ArrayList<ElementEntry> elements) {
        List children = ei.element.getChildren();
        for (Element elChild : children) {
            String elName;
            if (this.groupElem) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("WARNING found element children for group in element " + this.name + " " + this.ref));
            }
            if ((elName = elChild.getName()).equals("annotation")) {
                List appinfo = elChild.getChildren();
                for (Element elElem : appinfo) {
                    if (!elElem.getName().equals("appinfo")) continue;
                    this.name = elElem.getText();
                }
                continue;
            }
            if (elName.equals("element") || elName.equals("choice") || elName.equals("sequence") || elName.equals("group")) {
                elements.add(new ElementEntry(elChild, ei.file, ei.targetNS, ei.targetNSPrefix));
                continue;
            }
            Logger.log();
        }
    }
}

