/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.kernel.AbstractSchematronValidator;
import org.fao.geonet.kernel.ApplicableSchematron;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SchematronValidator
extends AbstractSchematronValidator {
    public Element applyCustomSchematronRules(String schema, int metadataId, Element md, String lang, List<MetadataValidation> validations) {
        return this.applyCustomSchematronRules(schema, metadataId, md, lang, validations, null);
    }

    public Element applyCustomSchematronRules(String schema, int metadataId, Element md, String lang, List<MetadataValidation> validations, List<ApplicableSchematron> onlyForSchematronList) {
        SchemaManager schemaManager = (SchemaManager)ApplicationContextHolder.get().getBean(SchemaManager.class);
        MetadataSchema metadataSchema = schemaManager.getSchema(schema);
        Path schemaDir = schemaManager.getSchemaDir(schema);
        Element schemaTronXmlOut = new Element("schematronerrors", Edit.NAMESPACE);
        try {
            List<ApplicableSchematron> applicableSchematron = onlyForSchematronList == null ? this.getApplicableSchematronList(metadataId, md, metadataSchema) : onlyForSchematronList;
            for (ApplicableSchematron applicable : applicableSchematron) {
                this.runSchematron(lang, schemaDir, validations, schemaTronXmlOut, metadataId, md, applicable);
            }
        }
        catch (Throwable e) {
            Element errorReport = new Element("schematronVerificationError", Edit.NAMESPACE);
            errorReport.addContent("Schematron error occurred, rules could not be verified: " + e.getMessage());
            schemaTronXmlOut.addContent((Content)errorReport);
        }
        if (schemaTronXmlOut.getChildren().isEmpty()) {
            schemaTronXmlOut = null;
        }
        return schemaTronXmlOut;
    }

    public List<ApplicableSchematron> getApplicableSchematronList(int metadataId, Element md, MetadataSchema metadataSchema) {
        ArrayList applicableSchematron = Lists.newArrayList();
        SchematronRepository schematronRepository = (SchematronRepository)ApplicationContextHolder.get().getBean(SchematronRepository.class);
        List schematronList = schematronRepository.findAllBySchemaName(metadataSchema.getName());
        Collections.sort(schematronList, Schematron.DISPLAY_PRIORITY_COMPARATOR);
        for (Schematron schematron : schematronList) {
            ApplicableSchematron applicable = this.getApplicableSchematron(metadataId, md, metadataSchema, schematron);
            if (applicable.requirement == SchematronRequirement.DISABLED) continue;
            if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                Log.debug((String)"geonetwork.datamanager", (Object)(" - rule:" + schematron.getRuleName()));
            }
            applicableSchematron.add(applicable);
        }
        return applicableSchematron;
    }

    public ApplicableSchematron getApplicableSchematron(int metadataId, Element md, MetadataSchema metadataSchema, Schematron schematron) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SchematronCriteriaGroupRepository criteriaGroupRepository = (SchematronCriteriaGroupRepository)applicationContext.getBean(SchematronCriteriaGroupRepository.class);
        List criteriaGroups = criteriaGroupRepository.findAllById_SchematronId(schematron.getId());
        SchematronRequirement requirement = SchematronRequirement.DISABLED;
        for (SchematronCriteriaGroup criteriaGroup : criteriaGroups) {
            SchematronCriteria criteria;
            List criteriaList = criteriaGroup.getCriteria();
            boolean apply = false;
            Iterator iterator = criteriaList.iterator();
            while (iterator.hasNext() && (apply = (criteria = (SchematronCriteria)iterator.next()).accepts((ApplicationContext)applicationContext, metadataId, md, metadataSchema.getSchemaNS()))) {
            }
            if (apply) {
                if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
                    Log.debug((String)"geonetwork.datamanager", (Object)(" - Schematron group is accepted:" + criteriaGroup.getId().getName() + " for schematron: " + schematron.getRuleName()));
                }
                requirement = requirement.highestRequirement(criteriaGroup.getRequirement());
                continue;
            }
            requirement = requirement.highestRequirement(SchematronRequirement.DISABLED);
        }
        return new ApplicableSchematron(requirement, schematron);
    }
}

