/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.overrides;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DefaultWebSecurityExpressionHandler;
import org.springframework.security.web.access.expression.ExpressionBasedFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ReflectionUtils;

public class OverridesMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> _requestMap;
    private DefaultFilterInvocationSecurityMetadataSource _baseSource;

    public OverridesMetadataSource(FilterInvocationSecurityMetadataSource metadataSource) {
        this.assertKnownType(metadataSource);
        Field field = ReflectionUtils.findField(metadataSource.getClass(), (String)"requestMap");
        if (field == null) {
            throw new IllegalArgumentException("The implementation of " + FilterInvocationSecurityMetadataSource.class.getName() + " has changed an now this class must be updated to work with new implementation");
        }
        field.setAccessible(true);
        this._requestMap = (LinkedHashMap)ReflectionUtils.getField((Field)field, (Object)metadataSource);
    }

    private void assertKnownType(FilterInvocationSecurityMetadataSource metadataSource) {
        if (!(metadataSource instanceof DefaultFilterInvocationSecurityMetadataSource)) {
            throw new IllegalArgumentException("Modifying the interceptUrls can only be done when the metadataSource is an instanceof " + DefaultFilterInvocationSecurityMetadataSource.class.getName() + ". Instead the metadataSource was a " + metadataSource.getClass().getName());
        }
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return this.getDelegateSource().getAllConfigAttributes();
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        return this.getDelegateSource().getAttributes(object);
    }

    public boolean supports(Class<?> clazz) {
        return this.getDelegateSource().supports(clazz) || FilterInvocation.class.isAssignableFrom(clazz);
    }

    public synchronized void addMapping(String pattern, RequestMatcher matcher, String access, int position) {
        Collection<ConfigAttribute> allAttributes;
        this._baseSource = null;
        Collection<ConfigAttribute> attributes = this.createAttributes(matcher, access);
        RequestMatcher requestMatcher = this.findMatchingRequestMatcher(pattern);
        if (requestMatcher == null) {
            requestMatcher = matcher;
        }
        if ((allAttributes = this._requestMap.get(requestMatcher)) == null) {
            allAttributes = new LinkedList<ConfigAttribute>();
        }
        allAttributes.addAll(attributes);
        this._requestMap.remove(requestMatcher);
        if (position > this.numberOfRules()) {
            this._requestMap.put(requestMatcher, allAttributes);
        } else {
            int finalPos = Math.max(0, position);
            LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>> newMap = new LinkedHashMap<RequestMatcher, Collection<ConfigAttribute>>();
            int i = 0;
            for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : this._requestMap.entrySet()) {
                if (i == finalPos) {
                    newMap.put(requestMatcher, allAttributes);
                }
                newMap.put(entry.getKey(), entry.getValue());
                ++i;
            }
            this._requestMap = newMap;
        }
    }

    public synchronized void setMapping(String pattern, String access) throws IllegalArgumentException {
        this._baseSource = null;
        RequestMatcher oldMatcher = this.findMatchingRequestMatcher(pattern);
        for (Map.Entry<RequestMatcher, Collection<ConfigAttribute>> entry : this._requestMap.entrySet()) {
            if (entry.getKey() != oldMatcher) continue;
            entry.setValue(this.createAttributes(oldMatcher, access));
            break;
        }
    }

    private synchronized DefaultFilterInvocationSecurityMetadataSource getDelegateSource() {
        if (this._baseSource == null) {
            DefaultFilterInvocationSecurityMetadataSource ms;
            this._baseSource = ms = new DefaultFilterInvocationSecurityMetadataSource(this._requestMap);
        }
        return this._baseSource;
    }

    private Collection<ConfigAttribute> createAttributes(RequestMatcher matcher, String access) {
        LinkedHashMap map = new LinkedHashMap();
        LinkedList<SecurityConfig> atts = new LinkedList<SecurityConfig>();
        map.put(matcher, atts);
        atts.add(new SecurityConfig(access));
        ExpressionBasedFilterInvocationSecurityMetadataSource ms = new ExpressionBasedFilterInvocationSecurityMetadataSource(map, (SecurityExpressionHandler)new DefaultWebSecurityExpressionHandler());
        return ms.getAllConfigAttributes();
    }

    public synchronized RequestMatcher removeMapping(String pattern) {
        this._baseSource = null;
        RequestMatcher toRemove = this.findMatchingRequestMatcher(pattern);
        if (toRemove == null) {
            throw new IllegalArgumentException(pattern + " has not been found.");
        }
        this._requestMap.remove(toRemove);
        return toRemove;
    }

    @Nullable
    private RequestMatcher findMatchingRequestMatcher(String pattern) {
        for (RequestMatcher requestMatcher : this._requestMap.keySet()) {
            RegexRequestMatcher regexMatcher;
            Object otherPattern;
            if (!(requestMatcher instanceof RegexRequestMatcher) || !pattern.equals((otherPattern = this.getPattern(regexMatcher = (RegexRequestMatcher)requestMatcher)).toString())) continue;
            return regexMatcher;
        }
        return null;
    }

    private Object getPattern(RegexRequestMatcher regexMatcher) {
        Field field = ReflectionUtils.findField(RegexRequestMatcher.class, (String)"pattern");
        if (field == null) {
            throw new IllegalArgumentException("The implementation of " + RegexRequestMatcher.class.getName() + " has changed an now this class must be updated to work with new implementation");
        }
        field.setAccessible(true);
        Object otherPattern = ReflectionUtils.getField((Field)field, (Object)regexMatcher);
        return otherPattern;
    }

    public synchronized int numberOfRules() {
        return this._requestMap.size();
    }
}

