/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.rpc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.soap.util.mime.ByteArrayDataSource;
import org.apache.soap.util.mime.MimeUtils;

public class SOAPContext {
    protected MimeMultipart parts = null;
    protected Hashtable bag = new Hashtable();
    protected ClassLoader loader = null;
    protected boolean rootPartSet = false;
    private static final String[] ignoreHeaders = new String[]{"Message-ID", "Mime-Version"};
    private static final String DEFAULT_BASEURI = "thismessage:/";

    public void addBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        this.addBodyPart(mimeBodyPart, -1);
    }

    public void addBodyPart(MimeBodyPart mimeBodyPart, int n) throws MessagingException, IllegalArgumentException {
        if (this.parts == null) {
            this.parts = new MimeMultipart("related");
        }
        DataHandler dataHandler = mimeBodyPart.getDataHandler();
        try {
            MimeType mimeType = new MimeType(dataHandler.getContentType());
            mimeBodyPart.setHeader("Content-Type", mimeType.toString());
            if (dataHandler.getDataSource() instanceof ByteArrayDataSource) {
                mimeBodyPart.setHeader("Content-Length", String.valueOf(((ByteArrayDataSource)dataHandler.getDataSource()).getSize()));
            }
            if (mimeType.match("application/octet-stream") || mimeType.match("image/*") || mimeType.match("audio/*") || mimeType.match("video/*")) {
                mimeBodyPart.setHeader("Content-Transfer-Encoding", "8bit");
            }
        }
        catch (MessagingException messagingException) {
            throw new IllegalArgumentException("Invalid InputStream/DataSource/DataHandler metadata: " + (Object)((Object)messagingException));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("Invalid Mime type \"" + dataHandler.getContentType() + "\": " + (Object)((Object)mimeTypeParseException));
        }
        if (n == -1) {
            this.parts.addBodyPart((BodyPart)mimeBodyPart);
        } else {
            this.parts.addBodyPart((BodyPart)mimeBodyPart, n);
        }
    }

    public MimeBodyPart findBodyPart(String string) {
        block8: {
            if (this.parts == null || string == null) {
                return null;
            }
            try {
                if (string.length() > 4 && string.substring(0, 4).equalsIgnoreCase("cid:")) {
                    String string2 = MimeUtils.decode(string.substring(4));
                    if (string2.charAt(0) != '<' || string2.charAt(string2.length()) != '>') {
                        string2 = String.valueOf('<') + string2 + '>';
                    }
                    try {
                        return (MimeBodyPart)this.parts.getBodyPart(string2);
                    }
                    catch (NullPointerException nullPointerException) {
                        break block8;
                    }
                }
                return this.findPartByLocation(string);
            }
            catch (MessagingException messagingException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        return null;
    }

    public MimeBodyPart findPartByLocation(String string) {
        try {
            String string2 = this.getBaseURI();
            string = this.normalizeURI(string, string2);
            if (string == null) {
                return null;
            }
            int n = 0;
            while (n < this.parts.getCount()) {
                String string3;
                MimeBodyPart mimeBodyPart = this.getBodyPart(n);
                if (mimeBodyPart != null && string.equals(this.normalizeURI(string3 = mimeBodyPart.getHeader("Content-Location", null), string2))) {
                    return mimeBodyPart;
                }
                ++n;
            }
        }
        catch (MessagingException messagingException) {}
        return null;
    }

    public String getBaseURI() {
        String string = null;
        try {
            string = this.getRootPart().getHeader("Content-Location", null);
        }
        catch (MessagingException messagingException) {}
        if (string == null) {
            string = DEFAULT_BASEURI;
        }
        return string;
    }

    public MimeBodyPart getBodyPart(int n) {
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(n);
        }
        catch (MessagingException messagingException) {
            throw new IndexOutOfBoundsException(messagingException.getMessage());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public MimeBodyPart getBodyPart(String string) {
        if (this.parts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this.parts.getBodyPart(string);
        }
        catch (MessagingException messagingException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String getContentType() throws MessagingException {
        if (this.parts == null) {
            return null;
        }
        if (this.parts.getCount() == 1) {
            return this.getRootPart().getContentType();
        }
        return this.parts.getContentType();
    }

    public int getCount() throws MessagingException {
        if (this.parts == null) {
            return 0;
        }
        return this.parts.getCount();
    }

    public Object getProperty(String string) {
        return this.bag.get(string);
    }

    public Enumeration getPropertyNames() {
        return this.bag.keys();
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        String string;
        MimeBodyPart mimeBodyPart = null;
        if (this.getCount() > 1 && (string = new ContentType(this.parts.getContentType()).getParameter("start")) != null) {
            mimeBodyPart = this.getBodyPart(MimeUtils.decode(string));
        }
        if (mimeBodyPart == null) {
            mimeBodyPart = this.getBodyPart(0);
        }
        return mimeBodyPart;
    }

    public boolean isRootPartSet() {
        return this.rootPartSet;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (this.loader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, this.loader);
    }

    private String normalizeURI(String string, String string2) {
        String string3;
        int n = string.indexOf(58);
        if (n >= 0 && (string3 = string.substring(0, n)).indexOf(47) == -1 && string3.indexOf(63) == -1 && string3.indexOf(35) == -1) {
            return string;
        }
        return String.valueOf(string2) + string;
    }

    public void readMultipart(DataSource dataSource) throws MessagingException {
        this.parts = new MimeMultipart(dataSource);
    }

    public void removeBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        this.parts.removeBodyPart((BodyPart)mimeBodyPart);
    }

    public Object removeProperty(String string) {
        return this.bag.remove(string);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setProperty(String string, Object object) {
        this.bag.put(string, object);
    }

    public void setRootPart(String string, String string2) throws MessagingException, IOException {
        this.setRootPart(string.getBytes("UTF8"), string2);
    }

    public void setRootPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        String string = String.valueOf('<') + MimeUtils.getUniqueValue() + '>';
        mimeBodyPart.setHeader("Content-ID", string);
        if (this.rootPartSet) {
            this.parts.removeBodyPart((BodyPart)this.getRootPart());
        }
        this.addBodyPart(mimeBodyPart, 0);
        this.rootPartSet = true;
    }

    public void setRootPart(byte[] byArray, String string) throws MessagingException {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string);
        DataHandler dataHandler = new DataHandler((DataSource)byteArrayDataSource);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.setHeader("Content-Length", String.valueOf(byteArrayDataSource.getSize()));
        mimeBodyPart.setHeader("Content-Transfer-Encoding", "8bit");
        this.setRootPart(mimeBodyPart);
    }

    public void setSubType(String string) throws MessagingException {
        if (this.parts == null) {
            this.parts = new MimeMultipart(string);
        } else {
            this.parts.setSubType(string);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("[Parts={");
        if (this.parts != null) {
            try {
                int n = 0;
                while (n < this.getCount()) {
                    if (n > 0) {
                        printWriter.print(", ");
                    }
                    MimeBodyPart mimeBodyPart = this.getBodyPart(n);
                    printWriter.print("[cid:" + mimeBodyPart.getContentID() + " type: " + mimeBodyPart.getContentType() + " enc: " + mimeBodyPart.getEncoding() + "]");
                    ++n;
                }
            }
            catch (MessagingException messagingException) {
                messagingException.printStackTrace();
            }
        }
        printWriter.print("}]");
        return stringWriter.toString();
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        int n = this.getCount();
        if (n == 0) {
            throw new IOException("Message is empty!");
        }
        if (n == 1) {
            this.getRootPart().writeTo(outputStream);
        } else {
            Session session = Session.getDefaultInstance((Properties)new Properties(), null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setContent((Multipart)this.parts);
            mimeMessage.saveChanges();
            mimeMessage.writeTo(outputStream, ignoreHeaders);
        }
    }
}

