/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.bnf.context.DbSchema;
import org.h2.command.Parser;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class DbContents {
    private DbSchema[] schemas;
    private DbSchema defaultSchema;
    private boolean isOracle;
    private boolean isH2;
    private boolean isPostgreSQL;
    private boolean isDerby;
    private boolean isSQLite;
    private boolean isH2ModeMySQL;
    private boolean isMySQL;
    private boolean isFirebird;
    private boolean isMSSQLServer;

    public DbSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isH2ModeMySQL() {
        return this.isH2ModeMySQL;
    }

    public boolean isMSSQLServer() {
        return this.isMSSQLServer;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isSQLite() {
        return this.isSQLite;
    }

    public DbSchema[] getSchemas() {
        return this.schemas;
    }

    public static int findColumn(ResultSet resultSet, String string, int n) {
        try {
            return resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            return n;
        }
    }

    public synchronized void readContents(DatabaseMetaData databaseMetaData) throws SQLException {
        Object object;
        Object object2;
        String string = StringUtils.toLowerEnglish(databaseMetaData.getDatabaseProductName());
        this.isSQLite = string.indexOf("sqlite") >= 0;
        String string2 = databaseMetaData.getURL();
        if (string2 != null) {
            this.isH2 = string2.startsWith("jdbc:h2:");
            if (this.isH2) {
                object2 = databaseMetaData.getConnection().prepareStatement("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?");
                object2.setString(1, "MODE");
                object = object2.executeQuery();
                object.next();
                if ("MYSQL".equals(object.getString(1))) {
                    this.isH2ModeMySQL = true;
                }
                object.close();
                object2.close();
            }
            this.isOracle = string2.startsWith("jdbc:oracle:");
            this.isPostgreSQL = string2.startsWith("jdbc:postgresql:");
            this.isMySQL = string2.startsWith("jdbc:mysql:");
            this.isDerby = string2.startsWith("jdbc:derby:");
            this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
            this.isMSSQLServer = string2.startsWith("jdbc:sqlserver:");
        }
        object2 = this.getDefaultSchemaName(databaseMetaData);
        object = this.getSchemaNames(databaseMetaData);
        this.schemas = new DbSchema[((String[])object).length];
        for (int i = 0; i < ((String[])object).length; ++i) {
            DbSchema[] dbSchemaArray = object[i];
            int n = object2 == null || ((String)object2).equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n != 0);
            if (dbSchema.isDefault) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i] = dbSchema;
            String[] stringArray = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM", "EXTERNAL"};
            dbSchema.readTables(databaseMetaData, stringArray);
            dbSchema.readProcedures(databaseMetaData);
        }
        if (this.defaultSchema == null) {
            String string3 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string3 != null && dbSchema.name.length() >= string3.length()) continue;
                string3 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        String[] stringArray;
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String> arrayList = New.arrayList();
        while (resultSet.next()) {
            stringArray = resultSet.getString(DbContents.findColumn(resultSet, "TABLE_SCHEM", 1));
            String[] stringArray2 = null;
            if (this.isOracle) {
                stringArray2 = new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"};
            } else if (this.isMSSQLServer) {
                stringArray2 = new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"};
            }
            if (stringArray2 != null) {
                for (void var9_9 : stringArray2) {
                    if (!var9_9.equals(stringArray)) continue;
                    stringArray = null;
                    break;
                }
            }
            if (stringArray == null) continue;
            arrayList.add((String)stringArray);
        }
        resultSet.close();
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String quoteIdentifier(String string) {
        if (string == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(string);
        }
        return StringUtils.toUpperEnglish(string);
    }
}

