/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.model.ModelChannel;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.InterceptorToAsyncProcessorBridge;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.processor.interceptor.BacklogDebugger;
import org.apache.camel.processor.interceptor.BacklogTracer;
import org.apache.camel.processor.interceptor.StreamCaching;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.OrderedComparator;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannel
extends CamelInternalProcessor
implements ModelChannel {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChannel.class);
    private final List<InterceptStrategy> interceptors = new ArrayList<InterceptStrategy>();
    private Processor errorHandler;
    private Processor nextProcessor;
    private Processor output;
    private ProcessorDefinition<?> definition;
    private ProcessorDefinition<?> childDefinition;
    private CamelContext camelContext;
    private RouteContext routeContext;

    @Override
    public void setNextProcessor(Processor next) {
        this.nextProcessor = next;
    }

    @Override
    public Processor getOutput() {
        return this.errorHandler != null ? this.errorHandler : this.output;
    }

    @Override
    public boolean hasNext() {
        return this.nextProcessor != null;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.nextProcessor);
        return answer;
    }

    @Override
    public void setOutput(Processor output) {
        this.output = output;
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    public boolean hasInterceptorStrategy(Class<?> type) {
        for (InterceptStrategy strategy : this.interceptors) {
            if (!type.isInstance(strategy)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setErrorHandler(Processor errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public Processor getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptors.add(strategy);
    }

    @Override
    public void addInterceptStrategies(List<InterceptStrategy> strategies) {
        this.interceptors.addAll(strategies);
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptors;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition() {
        return this.definition;
    }

    @Override
    public void setChildDefinition(ProcessorDefinition<?> childDefinition) {
        this.childDefinition = childDefinition;
    }

    @Override
    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    @Override
    protected void doStart() throws Exception {
        this.setProcessor(this.getOutput());
        ServiceHelper.startServices(this.errorHandler, this.output);
    }

    @Override
    protected void doStop() throws Exception {
        if (!this.isContextScoped()) {
            ServiceHelper.stopServices(this.output, this.errorHandler);
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.output, this.errorHandler);
    }

    private boolean isContextScoped() {
        if (this.definition instanceof OnExceptionDefinition) {
            return !((OnExceptionDefinition)this.definition).isRouteScoped();
        }
        if (this.definition instanceof OnCompletionDefinition) {
            return !((OnCompletionDefinition)this.definition).isRouteScoped();
        }
        return false;
    }

    @Override
    public void initChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
        Processor next;
        this.routeContext = routeContext;
        this.definition = outputDefinition;
        this.camelContext = routeContext.getCamelContext();
        Processor target = this.nextProcessor;
        if (target instanceof CamelContextAware) {
            ((CamelContextAware)((Object)target)).setCamelContext(this.camelContext);
        }
        ProcessorDefinition<?> targetOutputDef = this.childDefinition != null ? this.childDefinition : outputDefinition;
        LOG.debug("Initialize channel for target: '{}'", targetOutputDef);
        if (this.childDefinition != null && outputDefinition != this.childDefinition) {
            this.childDefinition.setParent(outputDefinition);
        }
        RouteDefinitionHelper.forceAssignIds(routeContext.getCamelContext(), this.definition);
        InterceptStrategy managed = routeContext.getManagedInterceptStrategy();
        if (managed != null) {
            next = target == this.nextProcessor ? null : this.nextProcessor;
            target = managed.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
        }
        InterceptStrategy tracer = this.getOrCreateBacklogTracer();
        this.camelContext.addService(tracer);
        if (tracer instanceof BacklogTracer) {
            BacklogTracer backlogTracer = (BacklogTracer)tracer;
            RouteDefinition route = ProcessorDefinitionHelper.getRoute(this.definition);
            boolean first = false;
            if (route != null && !route.getOutputs().isEmpty()) {
                first = route.getOutputs().get(0) == this.definition;
            }
            this.addAdvice(new CamelInternalProcessor.BacklogTracerAdvice(backlogTracer.getQueue(), backlogTracer, targetOutputDef, route, first));
            InterceptStrategy debugger = this.getOrCreateBacklogDebugger();
            this.camelContext.addService(debugger);
            if (debugger instanceof BacklogDebugger) {
                BacklogDebugger backlogDebugger = (BacklogDebugger)debugger;
                this.addAdvice(new CamelInternalProcessor.BacklogDebuggerAdvice(backlogDebugger, target, targetOutputDef));
            }
        }
        if (routeContext.isMessageHistory().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.MessageHistoryAdvice(targetOutputDef));
        }
        tracer = this.getOrCreateTracer();
        this.camelContext.addService(tracer);
        if (tracer != null) {
            TraceInterceptor trace = (TraceInterceptor)tracer.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, null);
            trace.setRouteContext(routeContext);
            target = trace;
        }
        Collections.sort(this.interceptors, new OrderedComparator());
        Collections.reverse(this.interceptors);
        for (InterceptStrategy strategy : this.interceptors) {
            Processor processor = next = target == this.nextProcessor ? null : this.nextProcessor;
            if (strategy instanceof Tracer || strategy instanceof StreamCaching) continue;
            Processor wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, target, next);
            if (!(wrapped instanceof AsyncProcessor)) {
                LOG.warn("Interceptor: " + strategy + " at: " + outputDefinition + " does not return an AsyncProcessor instance." + " This causes the asynchronous routing engine to not work as optimal as possible." + " See more details at the InterceptStrategy javadoc." + " Camel will use a bridge to adapt the interceptor to the asynchronous routing engine," + " but its not the most optimal solution. Please consider changing your interceptor to comply.");
                InterceptorToAsyncProcessorBridge bridge = new InterceptorToAsyncProcessorBridge(target);
                wrapped = strategy.wrapProcessorInInterceptors(routeContext.getCamelContext(), targetOutputDef, bridge, next);
                if (!wrapped.equals(bridge)) {
                    bridge.setTarget(wrapped);
                } else {
                    bridge.setTarget(null);
                }
                wrapped = bridge;
            }
            if (!(wrapped instanceof WrapProcessor)) {
                wrapped = new WrapProcessor(wrapped, target);
            }
            target = wrapped;
        }
        if (routeContext.isStreamCaching().booleanValue()) {
            this.addAdvice(new CamelInternalProcessor.StreamCachingAdvice(this.camelContext.getStreamCachingStrategy()));
        }
        if (routeContext.getDelayer() != null && routeContext.getDelayer() > 0L) {
            this.addAdvice(new CamelInternalProcessor.DelayerAdvice(routeContext.getDelayer()));
        }
        this.output = target;
    }

    @Override
    public void postInitChannel(ProcessorDefinition<?> outputDefinition, RouteContext routeContext) throws Exception {
    }

    private InterceptStrategy getOrCreateTracer() {
        if (this.camelContext.isTracing() != null && !this.camelContext.isTracing().booleanValue()) {
            return null;
        }
        InterceptStrategy tracer = Tracer.getTracer(this.camelContext);
        if (tracer == null) {
            Map<String, Tracer> map;
            if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(Tracer.class)).size() == 1) {
                tracer = map.values().iterator().next();
            }
            if (tracer == null) {
                tracer = this.camelContext.getDefaultTracer();
                Map<String, TraceFormatter> formatters = this.camelContext.getRegistry().findByTypeWithName(TraceFormatter.class);
                if (formatters.size() == 1) {
                    TraceFormatter formatter = formatters.values().iterator().next();
                    if (tracer instanceof Tracer) {
                        ((Tracer)tracer).setFormatter(formatter);
                    }
                }
            }
        }
        return tracer;
    }

    private InterceptStrategy getOrCreateBacklogTracer() {
        InterceptStrategy tracer = BacklogTracer.getBacklogTracer(this.camelContext);
        if (tracer == null) {
            Map<String, BacklogTracer> map;
            if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogTracer.class)).size() == 1) {
                tracer = map.values().iterator().next();
            }
            if (tracer == null) {
                tracer = this.camelContext.getDefaultBacklogTracer();
            }
        }
        return tracer;
    }

    private InterceptStrategy getOrCreateBacklogDebugger() {
        InterceptStrategy debugger = BacklogDebugger.getBacklogDebugger(this.camelContext);
        if (debugger == null) {
            Map<String, BacklogDebugger> map;
            if (this.camelContext.getRegistry() != null && (map = this.camelContext.getRegistry().findByTypeWithName(BacklogDebugger.class)).size() == 1) {
                debugger = map.values().iterator().next();
            }
            if (debugger == null) {
                debugger = this.camelContext.getDefaultBacklogDebugger();
            }
        }
        return debugger;
    }

    @Override
    public String toString() {
        return "Channel[" + this.nextProcessor + "]";
    }
}

