/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.DefaultBacklogTracerEventMessage;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklogTracer
extends ServiceSupport
implements InterceptStrategy {
    public static final int MAX_BACKLOG_SIZE = 100000;
    private static final Logger LOG = LoggerFactory.getLogger(BacklogTracer.class);
    private final CamelContext camelContext;
    private boolean enabled;
    private final AtomicLong traceCounter = new AtomicLong(0L);
    private final Queue<DefaultBacklogTracerEventMessage> queue = new ArrayBlockingQueue<DefaultBacklogTracerEventMessage>(100000);
    private int backlogSize = 1000;
    private boolean removeOnDump = true;
    private int bodyMaxChars = 131072;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;
    private String tracePattern;
    private String[] patterns;
    private String traceFilter;
    private Predicate predicate;

    public BacklogTracer(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Queue<DefaultBacklogTracerEventMessage> getQueue() {
        return this.queue;
    }

    @Override
    @Deprecated
    public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        throw new UnsupportedOperationException("Deprecated");
    }

    public static BacklogTracer createTracer(CamelContext context) {
        BacklogTracer tracer = new BacklogTracer(context);
        return tracer;
    }

    public static BacklogTracer getBacklogTracer(CamelContext context) {
        List<InterceptStrategy> list = context.getInterceptStrategies();
        for (InterceptStrategy interceptStrategy : list) {
            if (!(interceptStrategy instanceof BacklogTracer)) continue;
            return (BacklogTracer)interceptStrategy;
        }
        return null;
    }

    public boolean shouldTrace(ProcessorDefinition<?> definition, Exchange exchange) {
        if (!this.enabled) {
            return false;
        }
        boolean pattern = true;
        boolean filter = true;
        if (this.patterns != null) {
            pattern = this.shouldTracePattern(definition);
        }
        if (this.predicate != null) {
            filter = this.shouldTraceFilter(exchange);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Should trace evaluated {} -> pattern: {}, filter: {}", new Object[]{definition.getId(), pattern, filter});
        }
        return pattern && filter;
    }

    private boolean shouldTracePattern(ProcessorDefinition<?> definition) {
        for (String pattern : this.patterns) {
            String id = definition.getId();
            if (EndpointHelper.matchPattern(id, pattern)) {
                return true;
            }
            RouteDefinition route = ProcessorDefinitionHelper.getRoute(definition);
            if (route == null || !EndpointHelper.matchPattern(id = route.getId(), pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldTraceFilter(Exchange exchange) {
        return this.predicate.matches(exchange);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getBacklogSize() {
        return this.backlogSize;
    }

    public void setBacklogSize(int backlogSize) {
        if (backlogSize <= 0) {
            throw new IllegalArgumentException("The backlog size must be a positive number, was: " + backlogSize);
        }
        if (backlogSize > 100000) {
            throw new IllegalArgumentException("The backlog size cannot be greater than the max size of 100000, was: " + backlogSize);
        }
        this.backlogSize = backlogSize;
    }

    public boolean isRemoveOnDump() {
        return this.removeOnDump;
    }

    public void setRemoveOnDump(boolean removeOnDump) {
        this.removeOnDump = removeOnDump;
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    public String getTracePattern() {
        return this.tracePattern;
    }

    public void setTracePattern(String tracePattern) {
        this.tracePattern = tracePattern;
        this.patterns = tracePattern != null ? tracePattern.split(",") : null;
    }

    public String getTraceFilter() {
        return this.traceFilter;
    }

    public void setTraceFilter(String filter) {
        this.traceFilter = filter;
        if (filter != null) {
            String name = ObjectHelper.before(filter, ":");
            if (name == null) {
                name = "simple";
            }
            this.predicate = this.camelContext.resolveLanguage(name).createPredicate(filter);
        }
    }

    public long getTraceCounter() {
        return this.traceCounter.get();
    }

    public void resetTraceCounter() {
        this.traceCounter.set(0L);
    }

    public List<BacklogTracerEventMessage> dumpTracedMessages(String nodeId) {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>();
        if (nodeId != null) {
            for (DefaultBacklogTracerEventMessage message : this.queue) {
                if (!nodeId.equals(message.getToNode()) && !nodeId.equals(message.getRouteId())) continue;
                answer.add(message);
            }
        }
        if (this.removeOnDump) {
            this.queue.removeAll(answer);
        }
        return answer;
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        List<BacklogTracerEventMessage> events = this.dumpTracedMessages(nodeId);
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("backlogTracerEventMessage").append("s>");
        for (BacklogTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml(2));
        }
        sb.append("\n</").append("backlogTracerEventMessage").append("s>");
        return sb.toString();
    }

    public List<BacklogTracerEventMessage> dumpAllTracedMessages() {
        ArrayList<BacklogTracerEventMessage> answer = new ArrayList<BacklogTracerEventMessage>();
        answer.addAll(this.queue);
        if (this.isRemoveOnDump()) {
            this.queue.clear();
        }
        return answer;
    }

    public String dumpAllTracedMessagesAsXml() {
        List<BacklogTracerEventMessage> events = this.dumpAllTracedMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("<").append("backlogTracerEventMessage").append("s>");
        for (BacklogTracerEventMessage event : events) {
            sb.append("\n").append(event.toXml(2));
        }
        sb.append("\n</").append("backlogTracerEventMessage").append("s>");
        return sb.toString();
    }

    public void clear() {
        this.queue.clear();
    }

    public long incrementTraceCounter() {
        return this.traceCounter.incrementAndGet();
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
        this.queue.clear();
    }
}

