/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.reload4j;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.LogManager;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;
import org.slf4j.reload4j.Reload4jLoggerAdapter;

public class Reload4jLoggerFactory
implements ILoggerFactory {
    private static final String LOG4J_DELEGATION_LOOP_URL = "http://www.slf4j.org/codes.html#log4jDelegationLoop";
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Reload4jLoggerFactory() {
        LogManager.getRootLogger();
    }

    public Logger getLogger(String name) {
        Logger slf4jLogger = (Logger)this.loggerMap.get(name);
        if (slf4jLogger != null) {
            return slf4jLogger;
        }
        org.apache.log4j.Logger log4jLogger = name.equalsIgnoreCase("ROOT") ? LogManager.getRootLogger() : LogManager.getLogger((String)name);
        Reload4jLoggerAdapter newInstance = new Reload4jLoggerAdapter(log4jLogger);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    static {
        try {
            Class.forName("org.apache.log4j.Log4jLoggerFactory");
            String part1 = "Detected both log4j-over-slf4j.jar AND bound slf4j-log4j12.jar on the class path, preempting StackOverflowError. ";
            String part2 = "See also http://www.slf4j.org/codes.html#log4jDelegationLoop for more details.";
            Util.report((String)part1);
            Util.report((String)part2);
            throw new IllegalStateException(part1 + part2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

