/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.metadata;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.responses.StatusResponse;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.services.metadata.BatchOpsMetadataReindexer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="metadata/validate")
@Deprecated
public class ValidationService
implements ApplicationContextAware {
    private ApplicationContext context;
    private Map<String, Set<Integer>> report;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{portal}/{lang}/md.validation"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public StatusResponse validateRecords(@RequestParam(required=false) String[] uuid) throws Exception {
        HashSet setOfUuidsToValidate;
        ServiceContext serviceContext = ServiceContext.get();
        UserSession session = serviceContext.getUserSession();
        this.report = new HashMap<String, Set<Integer>>();
        this.report.put("records", new HashSet());
        this.report.put("validRecords", new HashSet());
        this.report.put("notOwnerRecords", new HashSet());
        if (uuid == null) {
            SelectionManager sm = SelectionManager.getManager((UserSession)session);
            Set set = sm.getSelection("metadata");
            synchronized (set) {
                setOfUuidsToValidate = Sets.newHashSet((Iterable)sm.getSelection("metadata"));
            }
        } else {
            setOfUuidsToValidate = Sets.newHashSet(Arrays.asList(uuid));
        }
        this.validateRecords(serviceContext, setOfUuidsToValidate);
        DataManager dataMan = (DataManager)this.context.getBean(DataManager.class);
        BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(dataMan, this.report.get("records"));
        r.process();
        return new StatusResponse(String.format("%d record(s) validated. %d record(s) valid.", this.report.get("records").size(), this.report.get("validRecords").size()));
    }

    private void validateRecords(ServiceContext serviceContext, Set<String> setOfUuidsToValidate) throws Exception {
        IMetadataValidator validator = (IMetadataValidator)this.context.getBean(IMetadataValidator.class);
        AccessManager accessMan = (AccessManager)this.context.getBean(AccessManager.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
        for (String uuid : setOfUuidsToValidate) {
            for (AbstractMetadata record : metadataRepository.findAllByUuid(uuid)) {
                if (!accessMan.isOwner(serviceContext, String.valueOf(record.getId()))) {
                    this.report.get("notOwnerRecords").add(record.getId());
                    continue;
                }
                Pair validationPair = validator.doValidate(record, serviceContext.getLanguage());
                boolean isValid = (Boolean)validationPair.two();
                if (isValid) {
                    this.report.get("validRecords").add(record.getId());
                }
                this.report.get("records").add(record.getId());
            }
        }
    }
}

