/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.mef;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.mef.Importer;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class ImportWebMap
extends NotInReadOnlyModeService {
    private String styleSheetWmc;

    public void init(Path appPath, ServiceConfig params) throws Exception {
        super.init(appPath, params);
        this.styleSheetWmc = appPath + File.separator + "xsl/conversion/import" + File.separator + "OGCWMC-OR-OWSC-to-ISO19139.xsl";
    }

    @Deprecated
    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        Element mdWithOLRes;
        HashMap<String, String> onlineSrcParams;
        String mapString = Util.getParam((Element)params, (String)"map_string");
        String mapUrl = Util.getParam((Element)params, (String)"map_url", (String)"");
        String viewerUrl = Util.getParam((Element)params, (String)"map_viewer_url", (String)"");
        String groupId = Util.getParam((Element)params, (String)"group_id", null);
        String mapAbstract = Util.getParam((Element)params, (String)"map_abstract", (String)"");
        String title = Util.getParam((Element)params, (String)"map_title", (String)"");
        String mapFileName = Util.getParam((Element)params, (String)"map_filename", (String)"map-context.ows");
        String mapImage = Util.getParam((Element)params, (String)"map_image", (String)"");
        String mapImageFilename = Util.getParam((Element)params, (String)"map_image_filename", (String)"map.png");
        FilePathChecker.verify((String)mapFileName);
        String topic = Util.getParam((Element)params, (String)"topic", (String)"");
        HashMap<String, String> xslParams = new HashMap<String, String>();
        xslParams.put("viewer_url", viewerUrl);
        xslParams.put("map_url", mapUrl);
        xslParams.put("topic", topic);
        xslParams.put("title", title);
        xslParams.put("abstract", mapAbstract);
        xslParams.put("lang", context.getLanguage());
        UserSession us = context.getUserSession();
        if (us != null) {
            xslParams.put("currentuser_name", us.getName() + " " + us.getSurname());
            xslParams.put("currentuser_mail", us.getEmailAddr());
            xslParams.put("currentuser_org", us.getOrganisation());
        }
        Element wmcDoc = Xml.loadString((String)mapString, (boolean)false);
        Element transformedMd = Xml.transform((Element)wmcDoc, (Path)new File(this.styleSheetWmc).toPath(), xslParams);
        String uuid = UUID.randomUUID().toString();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        SchemaManager schemaMan = (SchemaManager)context.getBean(SchemaManager.class);
        String uuidAction = Util.getParam((Element)params, (String)"uuidAction", (String)"nothing");
        String date = new ISODate().toString();
        ArrayList id = new ArrayList();
        ArrayList<Element> md = new ArrayList<Element>();
        md.add(transformedMd);
        Importer.importRecord((String)uuid, (MEFLib.UuidAction)MEFLib.UuidAction.parse((String)uuidAction), md, (String)"iso19139", (int)0, (String)sm.getSiteId(), (String)sm.getSiteName(), null, (ServiceContext)context, id, (String)date, (String)date, (String)groupId, (MetadataType)MetadataType.METADATA);
        Store store = (Store)context.getBean("resourceStore", Store.class);
        if (StringUtils.isEmpty((String)mapUrl)) {
            store.putResource(context, uuid, mapFileName, IOUtils.toInputStream((String)Xml.getString((Element)wmcDoc)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap<String, String>();
            onlineSrcParams.put("protocol", "WWW:DOWNLOAD-OGC:OWS-C");
            onlineSrcParams.put("url", sm.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, mapFileName));
            onlineSrcParams.put("name", mapFileName);
            onlineSrcParams.put("desc", title);
            mdWithOLRes = Xml.transform((Element)transformedMd, (Path)schemaMan.getSchemaDir("iso19139").resolve("process").resolve("onlinesrc-add.xsl"), onlineSrcParams);
            dm.updateMetadata(context, (String)id.get(0), mdWithOLRes, false, true, true, context.getLanguage(), null, true);
        }
        if (StringUtils.isNotEmpty((String)mapImage) && StringUtils.isNotEmpty((String)mapImageFilename)) {
            store.putResource(context, uuid, mapImageFilename, (InputStream)new ByteArrayInputStream(Base64.decodeBase64((String)mapImage)), null, MetadataResourceVisibility.PUBLIC, Boolean.valueOf(true));
            onlineSrcParams = new HashMap();
            onlineSrcParams.put("thumbnail_url", sm.getNodeURL() + String.format("api/records/%s/attachments/%s", uuid, mapFileName));
            mdWithOLRes = Xml.transform((Element)transformedMd, (Path)schemaMan.getSchemaDir("iso19139").resolve("process").resolve("thumbnail-add.xsl"), onlineSrcParams);
            dm.updateMetadata(context, (String)id.get(0), mdWithOLRes, false, true, true, context.getLanguage(), null, true);
        }
        dm.indexMetadata(id);
        Element result = new Element("uuid");
        result.setText(uuid);
        return result;
    }
}

