/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.util.ClosureComparator;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.HandlerFunctionSelect;
import org.fao.geonet.api.records.formatters.groovy.HandlerNameSelect;
import org.fao.geonet.api.records.formatters.groovy.HandlerPathSelect;
import org.fao.geonet.api.records.formatters.groovy.Logging;
import org.fao.geonet.api.records.formatters.groovy.Mode;
import org.fao.geonet.api.records.formatters.groovy.Selectable;
import org.fao.geonet.api.records.formatters.groovy.SkipElement;
import org.fao.geonet.api.records.formatters.groovy.SkipElementClosure;
import org.fao.geonet.api.records.formatters.groovy.SkipElementPattern;
import org.fao.geonet.api.records.formatters.groovy.Sorter;
import org.fao.geonet.api.records.formatters.groovy.SorterFunctionSelect;
import org.fao.geonet.api.records.formatters.groovy.SorterNameSelect;
import org.fao.geonet.api.records.formatters.groovy.SorterPathSelect;
import org.fao.geonet.api.records.formatters.groovy.StartEndHandler;
import org.fao.geonet.api.records.formatters.groovy.TransformEngine;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.api.records.formatters.groovy.template.FileResult;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateCache;

public class Handlers {
    static final String HANDLER_SELECT = "select";
    private final Path formatterDir;
    private final Path schemaDir;
    private final Path rootFormatterDir;
    private final TemplateCache templateCache;
    TransformEngine transformationEngine = new TransformEngine(this);
    StartEndHandler startHandler = new StartEndHandler(null);
    StartEndHandler endHandler = new StartEndHandler(null);
    private Set<String> roots = Sets.newHashSet();
    private List<SkipElement> skipElements = Lists.newArrayList();
    private Callable<Iterable<Object>> functionRoots = null;
    private Map<String, Mode> modes = Maps.newHashMap();
    private ListMultimap<String, Sorter> sorters = ArrayListMultimap.create();
    private ListMultimap<String, Handler> handlers = ArrayListMultimap.create();

    public Handlers(FormatterParams fparams, Path schemaDir, Path rootFormatterDir, TemplateCache templateCache) {
        this.formatterDir = fparams.formatDir;
        this.schemaDir = schemaDir;
        this.rootFormatterDir = rootFormatterDir;
        this.templateCache = templateCache;
    }

    public void prepareForTransformer() {
        for (String id : this.handlers.keySet()) {
            Collections.sort(this.handlers.get((Object)id));
        }
        this.handlers = Multimaps.unmodifiableListMultimap(this.handlers);
        for (String id : this.sorters.keySet()) {
            Collections.sort(this.sorters.get((Object)id));
        }
        this.sorters = Multimaps.unmodifiableListMultimap(this.sorters);
        this.modes = Collections.unmodifiableMap(this.modes);
        this.roots = Collections.unmodifiableSet(this.roots);
    }

    public void roots(Object ... xpaths) {
        this.roots.clear();
        this.functionRoots = null;
        for (Object xpath : xpaths) {
            this.roots.add(xpath.toString());
        }
    }

    public void roots(Closure rootFunction) {
        this.roots.clear();
        this.functionRoots = rootFunction;
    }

    public Set<String> getRoots() throws Exception {
        HashSet allRoots = Sets.newHashSet(this.roots);
        if (this.functionRoots != null) {
            Iterable<Object> fromFunc = this.functionRoots.call();
            for (Object root : fromFunc) {
                allRoots.add(root.toString());
            }
        }
        return allRoots;
    }

    public void root(Object xpath) {
        this.roots.add(xpath.toString());
    }

    public SkipElement skip(Object select, Closure childSelector) {
        return this.skip(select, childSelector, 0);
    }

    public SkipElement skip(Object select, Closure childSelector, int priority) {
        SkipElement skipElement;
        if (select instanceof String) {
            Pattern pattern = Pattern.compile(Pattern.quote((String)select));
            skipElement = new SkipElementPattern(pattern, priority, childSelector);
        } else if (select instanceof GString) {
            GString gString = (GString)select;
            Pattern pattern = Pattern.compile(Pattern.quote(gString.toString()));
            skipElement = new SkipElementPattern(pattern, priority, childSelector);
        } else if (select instanceof Closure) {
            Closure closure = (Closure)select;
            skipElement = new SkipElementClosure(closure, priority, childSelector);
        } else {
            throw new IllegalArgumentException("select must either be a string or a closure but was a: " + select.getClass());
        }
        this.skipElements.add(skipElement);
        return skipElement;
    }

    public SkipElement skip(Map<String, Object> properties, Closure handlerFunction) {
        SkipElement handler;
        Object select = properties.get(HANDLER_SELECT);
        if (select == null) {
            throw new IllegalArgumentException("A property select must be present in the properties map");
        }
        if (select instanceof Closure) {
            handler = this.skip(select, handlerFunction);
        } else if (select instanceof String || select instanceof GString) {
            handler = this.skip(select.toString(), handlerFunction);
        } else if (select instanceof Pattern) {
            handler = this.skip(select, handlerFunction);
        } else {
            throw new IllegalArgumentException("The property select is not a legal type.  Legal types are: Closure/function or String or Regular Expression(Pattern) but was " + select.getClass());
        }
        handler.configure(properties);
        return handler;
    }

    public Handler add(String elementName, Closure function) {
        HandlerNameSelect handler = new HandlerNameSelect(Pattern.compile(Pattern.quote(elementName)), 1, function);
        this.addHandler(handler);
        return handler;
    }

    public Handler add(Pattern namePattern, Closure function) {
        HandlerNameSelect handler = new HandlerNameSelect(namePattern, 0, function);
        this.addHandler(handler);
        return handler;
    }

    public Handler withPath(Pattern pathPattern, Closure function) {
        HandlerPathSelect handler = new HandlerPathSelect(pathPattern, 0, function);
        this.addHandler(handler);
        return handler;
    }

    public Handler add(Closure select, Closure function) {
        HandlerFunctionSelect handler = new HandlerFunctionSelect(select, 0, function);
        this.addHandler(handler);
        return handler;
    }

    public Handler add(Map<String, Object> properties, Closure handlerFunction) {
        Handler handler;
        Object select = properties.get(HANDLER_SELECT);
        if (select == null) {
            throw new IllegalArgumentException("A property select must be present in the properties map");
        }
        if (select instanceof Closure) {
            handler = this.add((Closure)select, handlerFunction);
        } else if (select instanceof String || select instanceof GString) {
            handler = this.add(select.toString(), handlerFunction);
        } else if (select instanceof Pattern) {
            handler = this.withPath((Pattern)select, handlerFunction);
        } else {
            throw new IllegalArgumentException("The property select is not a legal type.  Legal types are: Closure/function or String or Regular Expression(Pattern) but was " + select.getClass());
        }
        handler.configure(properties);
        if (!handler.mode.equals("")) {
            this.handlers.get((Object)"").remove(handler);
            this.addHandler(handler);
        }
        return handler;
    }

    private void addHandler(Handler handler) {
        this.handlers.put((Object)handler.mode, (Object)handler);
        this.addMode(handler);
    }

    private void addMode(Selectable selectable) {
        if (!this.modes.containsKey(selectable.mode)) {
            this.modes.put(selectable.mode, new Mode(selectable.mode));
        }
    }

    public boolean hasHandlerFor(GPathResult elem) {
        return this.hasHandlerFor("", elem);
    }

    public boolean hasHandlerFor(String mode, GPathResult elem) {
        return this.findHandlerFor(mode, elem) != null;
    }

    public Handler findHandlerFor(GPathResult elem) {
        return this.findHandlerFor("", elem);
    }

    public Handler findHandlerFor(String mode, GPathResult elem) {
        for (Handler handler : this.handlers.get((Object)mode)) {
            if (!handler.select(TransformationContext.getContext(), elem)) continue;
            Logging.debug("Handler %2$s found for element %1$s", elem, handler);
            return handler;
        }
        Logging.debug("No handler found for element %s", elem, new Object[0]);
        return null;
    }

    public FileResult fileResult(String path, Map<String, Object> model) throws IOException {
        return this.templateCache.createFileResult(this.formatterDir, this.schemaDir, this.rootFormatterDir, path, model);
    }

    public StartEndHandler start(Closure function) {
        this.startHandler = new StartEndHandler(function);
        return this.startHandler;
    }

    public StartEndHandler end(Closure function) {
        this.endHandler = new StartEndHandler(function);
        return this.endHandler;
    }

    public Sorter sort(Closure select, Closure sortFunction) {
        SorterFunctionSelect sorter = new SorterFunctionSelect(0, select, (Comparator)new ClosureComparator(sortFunction));
        this.addSorter(sorter);
        return sorter;
    }

    public Sorter sort(String elemName, Closure sortFunction) {
        SorterNameSelect sorter = new SorterNameSelect(1, Pattern.compile(Pattern.quote(elemName)), new ClosureComparator(sortFunction));
        this.addSorter(sorter);
        return sorter;
    }

    public Sorter sort(Pattern namePattern, Closure sortFunction) {
        SorterNameSelect sorter = new SorterNameSelect(0, namePattern, new ClosureComparator(sortFunction));
        this.addSorter(sorter);
        return sorter;
    }

    public Sorter sortPathMatcher(Pattern pathSelect, Closure sortFunction) {
        SorterPathSelect sorter = new SorterPathSelect(0, pathSelect, new ClosureComparator(sortFunction));
        this.addSorter(sorter);
        return sorter;
    }

    public Sorter sort(Map<String, Object> properties, Closure handlerFunction) {
        Sorter sorter;
        Object select = properties.get(HANDLER_SELECT);
        if (select == null) {
            throw new IllegalArgumentException("A property select must be present in the properties map");
        }
        if (select instanceof Closure) {
            sorter = this.sort((Closure)select, handlerFunction);
        } else if (select instanceof String || select instanceof GString) {
            sorter = this.sort(select.toString(), handlerFunction);
        } else if (select instanceof Pattern) {
            sorter = this.sortPathMatcher((Pattern)select, handlerFunction);
        } else {
            throw new IllegalArgumentException("The property select is not a legal type.  Legal types are: Closure/function or String or Regular Expression(Pattern) but was " + select.getClass());
        }
        sorter.configure(properties);
        if (!sorter.mode.equals("")) {
            this.sorters.get((Object)"").remove(sorter);
            this.addSorter(sorter);
        }
        return sorter;
    }

    private void addSorter(Sorter sorter) {
        this.sorters.put((Object)sorter.mode, (Object)sorter);
        this.addMode(sorter);
    }

    Sorter findSorter(TransformationContext context, GPathResult md) {
        for (Sorter sorter : this.sorters.get((Object)context.getCurrentMode())) {
            if (!sorter.select(context, md)) continue;
            Logging.debug("Sorter %2$s found for element %1$s.", md, sorter);
            return sorter;
        }
        Logging.debug("No handler found for element %s", md, new Object[0]);
        return null;
    }

    public Mode mode(String id) {
        Mode mode = this.modes.get(id);
        if (mode == null) {
            mode = new Mode(id);
            this.modes.put(id, mode);
        } else if (mode.getFallback() != null) {
            throw new IllegalArgumentException("The mode with id: " + id + " already exists and has a non-null fallback id.  If you want to replace the fallback to null then explicitly call the 2 parameter mode method");
        }
        return mode;
    }

    public Mode mode(String id, String fallback) {
        Mode mode = this.modes.get(id);
        if (mode == null) {
            mode = new Mode(id, fallback);
            this.modes.put(id, mode);
        } else {
            mode.setFallback(fallback);
        }
        return mode;
    }

    public Mode findMode(String id) {
        return this.modes.get(id);
    }

    public String processElements(Iterable selection) throws IOException {
        TransformationContext context = TransformationContext.getContext();
        return this.processElementsInMode(context.getCurrentMode(), selection, null);
    }

    public String processElements(Iterable selection, GPathResult sortByElement) throws IOException {
        TransformationContext context = TransformationContext.getContext();
        return this.processElementsInMode(context.getCurrentMode(), selection, sortByElement);
    }

    public String processElementsInMode(String mode, Iterable selection) throws IOException {
        return this.processElementsInMode(mode, selection, null);
    }

    public String processElementsInMode(String mode, Iterable selection, GPathResult sortByElement) throws IOException {
        return this.transformationEngine.processElementsInMode(mode, selection, sortByElement);
    }

    ListMultimap<String, Handler> getHandlers() {
        return this.handlers;
    }

    public List<SkipElement> getSkipElements() {
        return this.skipElements;
    }
}

