/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.editing;

import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.processing.report.IProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.events.history.RecordUpdatedEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.AddElemValue;
import org.fao.geonet.kernel.BatchEditParameter;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.EditLib;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.util.UserUtil;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record editing operations")
@Controller(value="records/edit")
@ReadWriteController
public class BatchEditsApi
implements ApplicationContextAware {
    @Autowired
    SchemaManager _schemaManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    RoleHierarchy roleHierarchy;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="Edit a set of records by XPath expressions. This operations applies the update-fixed-info.xsl transformation for the metadata schema and updates the change date if the parameter updateDateStamp is set to true.", nickname="batchEdit")
    @RequestMapping(value={"/batchediting"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Return a report of what has been done."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public IProcessingReport batchEdit(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false, example="iso19139") @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @ApiParam(value="If true updates the DateStamp (or equivalent in standards different to ISO 19139) field in the metadata with the current timestamp", required=false, defaultValue="false") @RequestParam(required=false, defaultValue="false") boolean updateDateStamp, @RequestBody BatchEditParameter[] edits, HttpServletRequest request) throws Exception {
        List<BatchEditParameter> listOfUpdates = Arrays.asList(edits);
        if (listOfUpdates.size() == 0) {
            throw new IllegalArgumentException("At least one edit must be defined.");
        }
        try (ServiceContext serviceContext = ApiUtils.createServiceContext(request);){
            HashSet setOfUuidsToEdit;
            UserUtil.checkUserProfileLevel((UserSession)serviceContext.getUserSession(), (SettingManager)this.settingManager, (RoleHierarchy)this.roleHierarchy, (String)"metadata/batchediting/accesslevel", (Profile)Profile.Editor, (String)"batch edit metadata");
            if (uuids == null) {
                SelectionManager selectionManager = SelectionManager.getManager((UserSession)serviceContext.getUserSession());
                Set set = selectionManager.getSelection(bucket);
                synchronized (set) {
                    Set selection = selectionManager.getSelection(bucket);
                    setOfUuidsToEdit = Sets.newHashSet((Iterable)selection);
                }
            } else {
                setOfUuidsToEdit = Sets.newHashSet(Arrays.asList(uuids));
            }
            if (setOfUuidsToEdit.size() == 0) {
                throw new IllegalArgumentException("At least one record should be defined or selected for updates.");
            }
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            DataManager dataMan = (DataManager)appContext.getBean(DataManager.class);
            SchemaManager _schemaManager = (SchemaManager)this.context.getBean(SchemaManager.class);
            AccessManager accessMan = (AccessManager)this.context.getBean(AccessManager.class);
            String settingId = "system/csw/transactionUpdateCreateXPath";
            boolean createXpathNodeIfNotExists = ((SettingManager)this.context.getBean(SettingManager.class)).getValueAsBool("system/csw/transactionUpdateCreateXPath");
            SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
            report.setTotalRecords(setOfUuidsToEdit.size());
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            String changeDate = null;
            IMetadataUtils metadataRepository = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
            for (String recordUuid : setOfUuidsToEdit) {
                AbstractMetadata record = metadataRepository.findOneByUuid(recordUuid);
                if (record == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!accessMan.isOwner(serviceContext, String.valueOf(record.getId()))) {
                    report.addNotEditableMetadataId(record.getId());
                    continue;
                }
                try {
                    EditLib editLib = new EditLib(_schemaManager);
                    MetadataSchema metadataSchema = _schemaManager.getSchema(record.getDataInfo().getSchemaId());
                    Element metadata = record.getXmlData(false);
                    boolean metadataChanged = false;
                    for (BatchEditParameter batchEditParameter : listOfUpdates) {
                        AddElemValue propertyValue = new AddElemValue(batchEditParameter.getValue());
                        boolean applyEdit = true;
                        if (StringUtils.isNotEmpty((String)batchEditParameter.getCondition())) {
                            applyEdit = false;
                            Object node = Xml.selectSingle((Element)metadata, (String)batchEditParameter.getCondition(), (List)metadataSchema.getNamespaces());
                            if (node != null && node instanceof Boolean && ((Boolean)node).booleanValue()) {
                                applyEdit = true;
                            }
                        }
                        if (!applyEdit) continue;
                        metadataChanged = editLib.addElementOrFragmentFromXpath(metadata, metadataSchema, batchEditParameter.getXpath(), propertyValue, createXpathNodeIfNotExists) || metadataChanged;
                    }
                    if (metadataChanged) {
                        boolean validate = false;
                        boolean ufo = true;
                        boolean index = true;
                        boolean uds = updateDateStamp;
                        Element beforeMetadata = dataMan.getMetadata(serviceContext, String.valueOf(record.getId()), false, false, false);
                        dataMan.updateMetadata(serviceContext, record.getId() + "", metadata, validate, ufo, index, "eng", changeDate, uds);
                        report.addMetadataInfos(record, "Metadata updated.");
                        Element afterMetadata = dataMan.getMetadata(serviceContext, String.valueOf(record.getId()), false, false, false);
                        XMLOutputter outp = new XMLOutputter();
                        String xmlBefore = outp.outputString(beforeMetadata);
                        String xmlAfter = outp.outputString(afterMetadata);
                        new RecordUpdatedEvent(Integer.valueOf(record.getId()), Integer.valueOf(userSession.getUserIdAsInt()), xmlBefore, xmlAfter).publish((ApplicationContext)appContext);
                    }
                }
                catch (Exception e) {
                    report.addMetadataError(record, e);
                }
                report.incrementProcessedRecords();
            }
            report.close();
            SimpleMetadataProcessingReport simpleMetadataProcessingReport = report;
            return simpleMetadataProcessingReport;
        }
    }

    private void checkUserProfileToBatchEditMetadata(UserSession userSession) {
        String allowedUserProfileToImportMetadata;
        if (userSession.getProfile() != Profile.Administrator && !UserUtil.hasHierarchyRole((String)(allowedUserProfileToImportMetadata = StringUtils.defaultIfBlank((String)this.settingManager.getValue("metadata/batchediting/accesslevel"), (String)Profile.Editor.toString())), (RoleHierarchy)this.roleHierarchy)) {
            throw new NotAllowedException("The user has no permissions to batch edit metadata.");
        }
    }
}

