/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/api/records", "/{portal}/api/0.1/records"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
@Controller(value="recordVersionning")
@ReadWriteController
public class MetadataVersionningApi {
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    AccessManager accessMan;
    @Autowired
    IMetadataUtils metadataRepository;

    @ApiOperation(value="(Experimental) Enable version control", notes="", nickname="enableVersionControl")
    @RequestMapping(value={"/{metadataUuid}/versions"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public ResponseEntity enableVersionControl(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, context);
            this.dataManager.versionMetadata(context, String.valueOf(metadata.getId()), metadata.getXmlData(false));
            ResponseEntity responseEntity = new ResponseEntity(HttpStatus.CREATED);
            return responseEntity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="(Experimental) Enable version control for one or more records", notes="", nickname="enableVersionControlForRecords")
    @RequestMapping(value={"/versions"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Editor')")
    @ResponseBody
    public MetadataProcessingReport enableVersionControlForRecords(@ApiParam(value="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @ApiParam(value="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request, @ApiIgnore HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
             ServiceContext context = ApiUtils.createServiceContext(request);){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            for (String uuid : records) {
                if (!this.metadataRepository.existsMetadataUuid(uuid)) {
                    report.incrementNullRecords();
                    continue;
                }
                for (AbstractMetadata metadata : this.metadataRepository.findAllByUuid(uuid)) {
                    if (!this.accessMan.canEdit(context, String.valueOf(metadata.getId()))) {
                        report.addNotEditableMetadataId(metadata.getId());
                        continue;
                    }
                    this.dataManager.versionMetadata(context, String.valueOf(metadata.getId()), metadata.getXmlData(false));
                    report.incrementProcessedRecords();
                }
            }
        }
        return report;
    }
}

