/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.mapservers;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.mapservers.MapServersUtils;
import org.fao.geonet.api.mapservers.model.AnonymousMapserver;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.MapServer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MapServerRepository;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/mapservers", "/{portal}/api/0.1/mapservers"})
@Api(value="mapservers", tags={"mapservers"}, description="Mapservers related operations")
@Controller(value="mapservers")
public class MapServersApi {
    public static final String API_PARAM_MAPSERVER_IDENTIFIER = "Mapserver identifier";
    public static final String API_PARAM_MAPSERVER_DETAILS = "Mapserver details";
    public static final String MSG_MAPSERVER_WITH_ID_NOT_FOUND = "Mapserver with id '%s' not found.";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    MapServerRepository mapServerRepository;
    @Autowired
    @Qualifier(value="resourceStore")
    Store store;
    @Autowired
    SettingManager settingManager;
    @Autowired
    GeonetHttpRequestFactory requestFactory;

    @ApiOperation(value="Get mapservers", notes="Mapservers are used by the catalog to publish record attachments (eg. ZIP file with shape) or record associated resources (eg. database table, file on the local network) in a remote mapserver like GeoServer or MapServer. The catalog communicate with the mapserver using GeoServer REST API.", authorizations={@Authorization(value="basicAuth")}, nickname="getMapservers")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public List<AnonymousMapserver> getMapservers() throws Exception {
        List mapServers = this.mapServerRepository.findAll();
        ArrayList<AnonymousMapserver> list = new ArrayList<AnonymousMapserver>(mapServers.size());
        mapServers.stream().forEach(e -> list.add(new AnonymousMapserver((MapServer)e)));
        return list;
    }

    @ApiOperation(value="Get a mapserver", authorizations={@Authorization(value="basicAuth")}, nickname="getMapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public AnonymousMapserver getMapserver(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable String mapserverId) throws Exception {
        MapServer mapserver = this.mapServerRepository.findOneById(mapserverId);
        if (mapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        return new AnonymousMapserver(mapserver);
    }

    @ApiOperation(value="Add a mapserver", notes="Return the id of the newly created mapserver.", authorizations={@Authorization(value="basicAuth")}, nickname="addMapserver")
    @RequestMapping(method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=201, message="Mapserver created."), @ApiResponse(code=400, message="Bad parameters."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<Integer> addMapserver(@ApiParam(value="Mapserver details", required=true) @RequestBody MapServer mapserver) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserver.getId());
        if (existingMapserver != null) {
            throw new IllegalArgumentException(String.format("Mapserver with id '%d' already exists.", mapserver.getId()));
        }
        this.mapServerRepository.save((Object)mapserver);
        return new ResponseEntity((Object)mapserver.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Update a mapserver", authorizations={@Authorization(value="basicAuth")}, nickname="updateMapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=204, message="Mapserver updated."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void updateMapserver(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable Integer mapserverId, @ApiParam(value="Mapserver details", required=true) @RequestBody MapServer mapserver) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (existingMapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.updateMapserver((int)mapserverId, mapserver, this.mapServerRepository);
    }

    @ApiOperation(value="Update a mapserver authentication", notes="The remote mapserver REST API may require basic authentication. This operation set the username and password.", authorizations={@Authorization(value="basicAuth")}, nickname="updateMapserverAuth")
    @RequestMapping(value={"/{mapserverId}/auth"}, method={RequestMethod.POST}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=204, message="Mapserver updated."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateMapserver(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable Integer mapserverId, @ApiParam(value="User name", required=true) @RequestParam String username, @ApiParam(value="Password", required=true) @RequestParam String password) throws Exception {
        MapServer existingMapserver = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (existingMapserver == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.mapServerRepository.update((Serializable)mapserverId, entity -> {
            entity.setUsername(username);
            entity.setPassword(password);
        });
    }

    private void updateMapserver(int mapserverId, MapServer mapServer, MapServerRepository repository) {
        repository.update((Serializable)Integer.valueOf(mapserverId), entity -> {
            entity.setName(mapServer.getName());
            entity.setConfigurl(mapServer.getConfigurl());
            entity.setWmsurl(mapServer.getWmsurl());
            entity.setWfsurl(mapServer.getWfsurl());
            entity.setWcsurl(mapServer.getWcsurl());
            entity.setStylerurl(mapServer.getStylerurl());
            entity.setDescription(mapServer.getDescription());
            entity.setNamespace(mapServer.getNamespace());
            entity.setNamespacePrefix(mapServer.getNamespacePrefix());
            entity.setPushStyleInWorkspace(mapServer.pushStyleInWorkspace());
        });
    }

    @ApiOperation(value="Remove a mapserver", authorizations={@Authorization(value="basicAuth")}, nickname="deleteMapserver")
    @RequestMapping(value={"/{mapserverId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasRole('Reviewer')")
    @ApiResponses(value={@ApiResponse(code=204, message="Mapserver removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Reviewvers can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteMapserver(@ApiParam(value="Mapserver identifier", required=true) @PathVariable Integer mapserverId) throws Exception {
        MapServer m = this.mapServerRepository.findOneById(mapserverId.intValue());
        if (m == null) {
            throw new ResourceNotFoundException(String.format(MSG_MAPSERVER_WITH_ID_NOT_FOUND, mapserverId));
        }
        this.mapServerRepository.delete((Object)m);
    }

    @ApiOperation(value="Check metadata mapserver resource is published ", authorizations={@Authorization(value="basicAuth")}, nickname="getMapserverResource")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    public String getMapserverResource(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @ApiParam(value="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @ApiParam(value="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.GET;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    @ApiOperation(value="Publish a metadata resource in a mapserver", authorizations={@Authorization(value="basicAuth")}, nickname="publishMapserverResource")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.PUT}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @ResponseBody
    public String publishMapserverResource(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @ApiParam(value="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @ApiParam(value="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.CREATE;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    @ApiOperation(value="Remove a metadata mapserver resource", authorizations={@Authorization(value="basicAuth")}, nickname="deleteMapserverResource")
    @RequestMapping(value={"/{mapserverId}/records/{metadataUuid}"}, method={RequestMethod.DELETE}, produces={"text/plain"})
    @PreAuthorize(value="hasRole('Editor')")
    @ApiResponses(value={@ApiResponse(code=403, message="Operation not allowed. Only Editors can access it.")})
    @ResponseBody
    public String deleteMapserverResource(@ApiParam(value="Mapserver identifier", required=true, example="") @PathVariable String mapserverId, @ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, @ApiParam(value="Resource name (could be a file or a db connection)", required=true) @RequestParam String resource, @ApiParam(value="Metadata title") @RequestParam(required=false, defaultValue="") String metadataTitle, @ApiParam(value="Metadata abstract") @RequestParam(required=false, defaultValue="") String metadataAbstract, HttpServletRequest request) throws Exception {
        MapServersUtils.ACTION action = MapServersUtils.ACTION.DELETE;
        return this.publishResource(mapserverId, metadataUuid, resource, metadataTitle, metadataAbstract, request, action);
    }

    /*
     * Exception decompiling
     */
    private String publishResource(String mapserverId, String metadataUuid, String resource, String metadataTitle, String metadataAbstract, HttpServletRequest request, MapServersUtils.ACTION action) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

