/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.cloudwatch.binders.AlarmNamesBinder;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.functions.ListAlarmsToPagedIterable;
import org.jclouds.cloudwatch.options.ListAlarmHistoryOptions;
import org.jclouds.cloudwatch.options.ListAlarmsForMetric;
import org.jclouds.cloudwatch.options.ListAlarmsOptions;
import org.jclouds.cloudwatch.options.SaveAlarmOptions;
import org.jclouds.cloudwatch.xml.ListAlarmHistoryResponseHandler;
import org.jclouds.cloudwatch.xml.ListAlarmsForMetricResponseHandler;
import org.jclouds.cloudwatch.xml.ListAlarmsResponseHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
@Beta
public interface AlarmApi {
    @Named(value="DeleteAlarms")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteAlarms"})
    public void delete(@BinderParam(value=AlarmNamesBinder.class) Iterable<String> var1);

    @Named(value="DescribeAlarmHistory")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmHistoryResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarmHistory"})
    @Transform(value=ListAlarmsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public PagedIterable<AlarmHistoryItem> listHistory();

    @Named(value="DescribeAlarmHistory")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmHistoryResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarmHistory"})
    @Transform(value=ListAlarmsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public PagedIterable<AlarmHistoryItem> listHistory(ListAlarmHistoryOptions var1);

    @Named(value="DescribeAlarmHistory")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmHistoryResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarmHistory"})
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<AlarmHistoryItem> listHistoryAt(@FormParam(value="NextToken") String var1);

    @Named(value="DescribeAlarms")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmsResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarms"})
    @Transform(value=ListAlarmsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public PagedIterable<Alarm> list();

    @Named(value="DescribeAlarms")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmsResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarms"})
    @Transform(value=ListAlarmsToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public PagedIterable<Alarm> list(ListAlarmsOptions var1);

    @Named(value="DescribeAlarms")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmsResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarms"})
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Alarm> listAt(@FormParam(value="NextToken") String var1);

    @Named(value="DescribeAlarmsForMetric")
    @POST
    @Path(value="/")
    @XMLResponseParser(value=ListAlarmsForMetricResponseHandler.class)
    @FormParams(keys={"Action"}, values={"DescribeAlarmsForMetric"})
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public FluentIterable<Alarm> listForMetric(ListAlarmsForMetric var1);

    @Named(value="DisableAlarmActions")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DisableAlarmActions"})
    public void disable(@BinderParam(value=AlarmNamesBinder.class) Iterable<String> var1);

    @Named(value="EnableAlarmActions")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"EnableAlarmActions"})
    public void enable(@BinderParam(value=AlarmNamesBinder.class) Iterable<String> var1);

    @Named(value="PutMetricAlarm")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"PutMetricAlarm"})
    public void save(SaveAlarmOptions var1);

    @Named(value="SetAlarmState")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SetAlarmState"})
    public void setState(@FormParam(value="AlarmName") String var1, @FormParam(value="StateReason") String var2, @FormParam(value="StateReasonData") @Nullable String var3, @FormParam(value="StateValue") Alarm.State var4);
}

