/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["exports","./defined-2a4f2d00","./Check-e5651467","./defaultValue-29c9b1af","./Math-7782f09e","./Cartesian2-ba70b51f","./defineProperties-c817531e","./Transforms-5119c07b","./ComponentDatatype-418b1c61","./GeometryAttribute-8bc1900e","./GeometryAttributes-f8548d3f","./Plane-475170f0","./VertexFormat-e2e35139"],function(t,V,e,M,i,F,a,P,E,k,R,f,l){"use strict";function h(t){this.planes=M.defaultValue(t,[])}var p=[new F.Cartesian3,new F.Cartesian3,new F.Cartesian3];F.Cartesian3.clone(F.Cartesian3.UNIT_X,p[0]),F.Cartesian3.clone(F.Cartesian3.UNIT_Y,p[1]),F.Cartesian3.clone(F.Cartesian3.UNIT_Z,p[2]);var d=new F.Cartesian3,c=new F.Cartesian3,u=new f.Plane(new F.Cartesian3(1,0,0),0);function n(t){t=M.defaultValue(t,M.defaultValue.EMPTY_OBJECT),this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=M.defaultValue(t.near,1),this._near=this.near,this.far=M.defaultValue(t.far,5e8),this._far=this.far,this._cullingVolume=new h,this._orthographicMatrix=new P.Matrix4}function s(t){t.top===t._top&&t.bottom===t._bottom&&t.left===t._left&&t.right===t._right&&t.near===t._near&&t.far===t._far||(t._left=t.left,t._right=t.right,t._top=t.top,t._bottom=t.bottom,t._near=t.near,t._far=t.far,t._orthographicMatrix=P.Matrix4.computeOrthographicOffCenter(t.left,t.right,t.bottom,t.top,t.near,t.far,t._orthographicMatrix))}h.fromBoundingSphere=function(t,e){V.defined(e)||(e=new h);var a=p.length,i=e.planes;i.length=2*a;for(var n=t.center,r=t.radius,o=0,s=0;s<a;++s){var f=p[s],u=i[o],l=i[o+1];V.defined(u)||(u=i[o]=new P.Cartesian4),V.defined(l)||(l=i[o+1]=new P.Cartesian4),F.Cartesian3.multiplyByScalar(f,-r,d),F.Cartesian3.add(n,d,d),u.x=f.x,u.y=f.y,u.z=f.z,u.w=-F.Cartesian3.dot(f,d),F.Cartesian3.multiplyByScalar(f,r,d),F.Cartesian3.add(n,d,d),l.x=-f.x,l.y=-f.y,l.z=-f.z,l.w=-F.Cartesian3.dot(F.Cartesian3.negate(f,c),d),o+=2}return e},h.prototype.computeVisibility=function(t){for(var e=this.planes,a=!1,i=0,n=e.length;i<n;++i){var r=t.intersectPlane(f.Plane.fromCartesian4(e[i],u));if(r===P.Intersect.OUTSIDE)return P.Intersect.OUTSIDE;r===P.Intersect.INTERSECTING&&(a=!0)}return a?P.Intersect.INTERSECTING:P.Intersect.INSIDE},h.prototype.computeVisibilityWithPlaneMask=function(t,e){if(e===h.MASK_OUTSIDE||e===h.MASK_INSIDE)return e;for(var a=h.MASK_INSIDE,i=this.planes,n=0,r=i.length;n<r;++n){var o=n<31?1<<n:0;if(!(n<31&&0==(e&o))){var s=t.intersectPlane(f.Plane.fromCartesian4(i[n],u));if(s===P.Intersect.OUTSIDE)return h.MASK_OUTSIDE;s===P.Intersect.INTERSECTING&&(a|=o)}}return a},h.MASK_OUTSIDE=4294967295,h.MASK_INSIDE=0,h.MASK_INDETERMINATE=2147483647,a.defineProperties(n.prototype,{projectionMatrix:{get:function(){return s(this),this._orthographicMatrix}}});var m=new F.Cartesian3,C=new F.Cartesian3,_=new F.Cartesian3,y=new F.Cartesian3;function g(t){t=M.defaultValue(t,M.defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new n,this.width=t.width,this._width=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=M.defaultValue(t.near,1),this._near=this.near,this.far=M.defaultValue(t.far,5e8),this._far=this.far}function r(t){var e=t._offCenterFrustum;if(t.width!==t._width||t.aspectRatio!==t._aspectRatio||t.near!==t._near||t.far!==t._far){t._aspectRatio=t.aspectRatio,t._width=t.width,t._near=t.near,t._far=t.far;var a=1/t.aspectRatio;e.right=.5*t.width,e.left=-e.right,e.top=a*e.right,e.bottom=-e.top,e.near=t.near,e.far=t.far}}function o(t){t=M.defaultValue(t,M.defaultValue.EMPTY_OBJECT),this.left=t.left,this._left=void 0,this.right=t.right,this._right=void 0,this.top=t.top,this._top=void 0,this.bottom=t.bottom,this._bottom=void 0,this.near=M.defaultValue(t.near,1),this._near=this.near,this.far=M.defaultValue(t.far,5e8),this._far=this.far,this._cullingVolume=new h,this._perspectiveMatrix=new P.Matrix4,this._infinitePerspective=new P.Matrix4}function v(t){var e=t.top,a=t.bottom,i=t.right,n=t.left,r=t.near,o=t.far;e===t._top&&a===t._bottom&&n===t._left&&i===t._right&&r===t._near&&o===t._far||(t._left=n,t._right=i,t._top=e,t._bottom=a,t._near=r,t._far=o,t._perspectiveMatrix=P.Matrix4.computePerspectiveOffCenter(n,i,a,e,r,o,t._perspectiveMatrix),t._infinitePerspective=P.Matrix4.computeInfinitePerspectiveOffCenter(n,i,a,e,r,t._infinitePerspective))}n.prototype.computeCullingVolume=function(t,e,a){var i=this._cullingVolume.planes,n=this.top,r=this.bottom,o=this.right,s=this.left,f=this.near,u=this.far,l=F.Cartesian3.cross(e,a,m);F.Cartesian3.normalize(l,l);var h=C;F.Cartesian3.multiplyByScalar(e,f,h),F.Cartesian3.add(t,h,h);var p=_;F.Cartesian3.multiplyByScalar(l,s,p),F.Cartesian3.add(h,p,p);var d=i[0];return V.defined(d)||(d=i[0]=new P.Cartesian4),d.x=l.x,d.y=l.y,d.z=l.z,d.w=-F.Cartesian3.dot(l,p),F.Cartesian3.multiplyByScalar(l,o,p),F.Cartesian3.add(h,p,p),d=i[1],V.defined(d)||(d=i[1]=new P.Cartesian4),d.x=-l.x,d.y=-l.y,d.z=-l.z,d.w=-F.Cartesian3.dot(F.Cartesian3.negate(l,y),p),F.Cartesian3.multiplyByScalar(a,r,p),F.Cartesian3.add(h,p,p),d=i[2],V.defined(d)||(d=i[2]=new P.Cartesian4),d.x=a.x,d.y=a.y,d.z=a.z,d.w=-F.Cartesian3.dot(a,p),F.Cartesian3.multiplyByScalar(a,n,p),F.Cartesian3.add(h,p,p),d=i[3],V.defined(d)||(d=i[3]=new P.Cartesian4),d.x=-a.x,d.y=-a.y,d.z=-a.z,d.w=-F.Cartesian3.dot(F.Cartesian3.negate(a,y),p),d=i[4],V.defined(d)||(d=i[4]=new P.Cartesian4),d.x=e.x,d.y=e.y,d.z=e.z,d.w=-F.Cartesian3.dot(e,h),F.Cartesian3.multiplyByScalar(e,u,p),F.Cartesian3.add(t,p,p),d=i[5],V.defined(d)||(d=i[5]=new P.Cartesian4),d.x=-e.x,d.y=-e.y,d.z=-e.z,d.w=-F.Cartesian3.dot(F.Cartesian3.negate(e,y),p),this._cullingVolume},n.prototype.getPixelDimensions=function(t,e,a,i,n){s(this),i instanceof F.Cartesian2&&(n=i,i=1,P.deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65."));var r=i*(this.right-this.left)/t,o=i*(this.top-this.bottom)/e;return n.x=r,n.y=o,n},n.prototype.clone=function(t){return V.defined(t)||(t=new n),t.left=this.left,t.right=this.right,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},n.prototype.equals=function(t){return V.defined(t)&&t instanceof n&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},n.prototype.equalsEpsilon=function(t,e,a){return t===this||V.defined(t)&&t instanceof n&&i.CesiumMath.equalsEpsilon(this.right,t.right,e,a)&&i.CesiumMath.equalsEpsilon(this.left,t.left,e,a)&&i.CesiumMath.equalsEpsilon(this.top,t.top,e,a)&&i.CesiumMath.equalsEpsilon(this.bottom,t.bottom,e,a)&&i.CesiumMath.equalsEpsilon(this.near,t.near,e,a)&&i.CesiumMath.equalsEpsilon(this.far,t.far,e,a)},g.packedLength=4,g.pack=function(t,e,a){return a=M.defaultValue(a,0),e[a++]=t.width,e[a++]=t.aspectRatio,e[a++]=t.near,e[a]=t.far,e},g.unpack=function(t,e,a){return e=M.defaultValue(e,0),V.defined(a)||(a=new g),a.width=t[e++],a.aspectRatio=t[e++],a.near=t[e++],a.far=t[e],a},a.defineProperties(g.prototype,{projectionMatrix:{get:function(){return r(this),this._offCenterFrustum.projectionMatrix}}}),g.prototype.computeCullingVolume=function(t,e,a){return r(this),this._offCenterFrustum.computeCullingVolume(t,e,a)},g.prototype.getPixelDimensions=function(t,e,a,i,n){return r(this),i instanceof F.Cartesian2&&(n=i,i=1,P.deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65.")),this._offCenterFrustum.getPixelDimensions(t,e,a,i,n)},g.prototype.clone=function(t){return V.defined(t)||(t=new g),t.aspectRatio=this.aspectRatio,t.width=this.width,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._width=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},g.prototype.equals=function(t){return!!(V.defined(t)&&t instanceof g)&&(r(this),r(t),this.width===t.width&&this.aspectRatio===t.aspectRatio&&this._offCenterFrustum.equals(t._offCenterFrustum))},g.prototype.equalsEpsilon=function(t,e,a){return!!(V.defined(t)&&t instanceof g)&&(r(this),r(t),i.CesiumMath.equalsEpsilon(this.width,t.width,e,a)&&i.CesiumMath.equalsEpsilon(this.aspectRatio,t.aspectRatio,e,a)&&this._offCenterFrustum.equalsEpsilon(t._offCenterFrustum,e,a))},a.defineProperties(o.prototype,{projectionMatrix:{get:function(){return v(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return v(this),this._infinitePerspective}}});var w=new F.Cartesian3,x=new F.Cartesian3,b=new F.Cartesian3,z=new F.Cartesian3;function O(t){t=M.defaultValue(t,M.defaultValue.EMPTY_OBJECT),this._offCenterFrustum=new o,this.fov=t.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=t.aspectRatio,this._aspectRatio=void 0,this.near=M.defaultValue(t.near,1),this._near=this.near,this.far=M.defaultValue(t.far,5e8),this._far=this.far,this.xOffset=M.defaultValue(t.xOffset,0),this._xOffset=this.xOffset,this.yOffset=M.defaultValue(t.yOffset,0),this._yOffset=this.yOffset}function T(t){var e=t._offCenterFrustum;t.fov===t._fov&&t.aspectRatio===t._aspectRatio&&t.near===t._near&&t.far===t._far&&t.xOffset===t._xOffset&&t.yOffset===t._yOffset||(t._aspectRatio=t.aspectRatio,t._fov=t.fov,t._fovy=t.aspectRatio<=1?t.fov:2*Math.atan(Math.tan(.5*t.fov)/t.aspectRatio),t._near=t.near,t._far=t.far,t._sseDenominator=2*Math.tan(.5*t._fovy),t._xOffset=t.xOffset,t._yOffset=t.yOffset,e.top=t.near*Math.tan(.5*t._fovy),e.bottom=-e.top,e.right=t.aspectRatio*e.top,e.left=-e.right,e.near=t.near,e.far=t.far,e.right+=t.xOffset,e.left+=t.xOffset,e.top+=t.yOffset,e.bottom+=t.yOffset)}o.prototype.computeCullingVolume=function(t,e,a){var i=this._cullingVolume.planes,n=this.top,r=this.bottom,o=this.right,s=this.left,f=this.near,u=this.far,l=F.Cartesian3.cross(e,a,w),h=x;F.Cartesian3.multiplyByScalar(e,f,h),F.Cartesian3.add(t,h,h);var p=b;F.Cartesian3.multiplyByScalar(e,u,p),F.Cartesian3.add(t,p,p);var d=z;F.Cartesian3.multiplyByScalar(l,s,d),F.Cartesian3.add(h,d,d),F.Cartesian3.subtract(d,t,d),F.Cartesian3.normalize(d,d),F.Cartesian3.cross(d,a,d),F.Cartesian3.normalize(d,d);var c=i[0];return V.defined(c)||(c=i[0]=new P.Cartesian4),c.x=d.x,c.y=d.y,c.z=d.z,c.w=-F.Cartesian3.dot(d,t),F.Cartesian3.multiplyByScalar(l,o,d),F.Cartesian3.add(h,d,d),F.Cartesian3.subtract(d,t,d),F.Cartesian3.cross(a,d,d),F.Cartesian3.normalize(d,d),c=i[1],V.defined(c)||(c=i[1]=new P.Cartesian4),c.x=d.x,c.y=d.y,c.z=d.z,c.w=-F.Cartesian3.dot(d,t),F.Cartesian3.multiplyByScalar(a,r,d),F.Cartesian3.add(h,d,d),F.Cartesian3.subtract(d,t,d),F.Cartesian3.cross(l,d,d),F.Cartesian3.normalize(d,d),c=i[2],V.defined(c)||(c=i[2]=new P.Cartesian4),c.x=d.x,c.y=d.y,c.z=d.z,c.w=-F.Cartesian3.dot(d,t),F.Cartesian3.multiplyByScalar(a,n,d),F.Cartesian3.add(h,d,d),F.Cartesian3.subtract(d,t,d),F.Cartesian3.cross(d,l,d),F.Cartesian3.normalize(d,d),c=i[3],V.defined(c)||(c=i[3]=new P.Cartesian4),c.x=d.x,c.y=d.y,c.z=d.z,c.w=-F.Cartesian3.dot(d,t),c=i[4],V.defined(c)||(c=i[4]=new P.Cartesian4),c.x=e.x,c.y=e.y,c.z=e.z,c.w=-F.Cartesian3.dot(e,h),F.Cartesian3.negate(e,d),c=i[5],V.defined(c)||(c=i[5]=new P.Cartesian4),c.x=d.x,c.y=d.y,c.z=d.z,c.w=-F.Cartesian3.dot(d,p),this._cullingVolume},o.prototype.getPixelDimensions=function(t,e,a,i,n){v(this),i instanceof F.Cartesian2&&(n=i,i=1,P.deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65."));var r=1/this.near,o=this.top*r,s=2*i*a*o/e,f=2*i*a*(o=this.right*r)/t;return n.x=f,n.y=s,n},o.prototype.clone=function(t){return V.defined(t)||(t=new o),t.right=this.right,t.left=this.left,t.top=this.top,t.bottom=this.bottom,t.near=this.near,t.far=this.far,t._left=void 0,t._right=void 0,t._top=void 0,t._bottom=void 0,t._near=void 0,t._far=void 0,t},o.prototype.equals=function(t){return V.defined(t)&&t instanceof o&&this.right===t.right&&this.left===t.left&&this.top===t.top&&this.bottom===t.bottom&&this.near===t.near&&this.far===t.far},o.prototype.equalsEpsilon=function(t,e,a){return t===this||V.defined(t)&&t instanceof o&&i.CesiumMath.equalsEpsilon(this.right,t.right,e,a)&&i.CesiumMath.equalsEpsilon(this.left,t.left,e,a)&&i.CesiumMath.equalsEpsilon(this.top,t.top,e,a)&&i.CesiumMath.equalsEpsilon(this.bottom,t.bottom,e,a)&&i.CesiumMath.equalsEpsilon(this.near,t.near,e,a)&&i.CesiumMath.equalsEpsilon(this.far,t.far,e,a)},O.packedLength=6,O.pack=function(t,e,a){return a=M.defaultValue(a,0),e[a++]=t.fov,e[a++]=t.aspectRatio,e[a++]=t.near,e[a++]=t.far,e[a++]=t.xOffset,e[a]=t.yOffset,e},O.unpack=function(t,e,a){return e=M.defaultValue(e,0),V.defined(a)||(a=new O),a.fov=t[e++],a.aspectRatio=t[e++],a.near=t[e++],a.far=t[e++],a.xOffset=t[e++],a.yOffset=t[e],a},a.defineProperties(O.prototype,{projectionMatrix:{get:function(){return T(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return T(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return T(this),this._fovy}},sseDenominator:{get:function(){return T(this),this._sseDenominator}}}),O.prototype.computeCullingVolume=function(t,e,a){return T(this),this._offCenterFrustum.computeCullingVolume(t,e,a)},O.prototype.getPixelDimensions=function(t,e,a,i,n){return T(this),i instanceof F.Cartesian2&&(n=i,i=1,P.deprecationWarning("getPixelDimensions-parameter-change","getPixelDimensions now takes a pixelRatio argument before the result argument in Cesium 1.63. The previous function definition will no longer work in 1.65.")),this._offCenterFrustum.getPixelDimensions(t,e,a,i,n)},O.prototype.clone=function(t){return V.defined(t)||(t=new O),t.aspectRatio=this.aspectRatio,t.fov=this.fov,t.near=this.near,t.far=this.far,t._aspectRatio=void 0,t._fov=void 0,t._near=void 0,t._far=void 0,this._offCenterFrustum.clone(t._offCenterFrustum),t},O.prototype.equals=function(t){return!!(V.defined(t)&&t instanceof O)&&(T(this),T(t),this.fov===t.fov&&this.aspectRatio===t.aspectRatio&&this._offCenterFrustum.equals(t._offCenterFrustum))},O.prototype.equalsEpsilon=function(t,e,a){return!!(V.defined(t)&&t instanceof O)&&(T(this),T(t),i.CesiumMath.equalsEpsilon(this.fov,t.fov,e,a)&&i.CesiumMath.equalsEpsilon(this.aspectRatio,t.aspectRatio,e,a)&&this._offCenterFrustum.equalsEpsilon(t._offCenterFrustum,e,a))};function D(t){var e,a,i=t.frustum,n=t.orientation,r=t.origin,o=M.defaultValue(t.vertexFormat,l.VertexFormat.DEFAULT),s=M.defaultValue(t._drawNearPlane,!0);i instanceof O?(e=0,a=O.packedLength):i instanceof g&&(e=1,a=g.packedLength),this._frustumType=e,this._frustum=i.clone(),this._origin=F.Cartesian3.clone(r),this._orientation=P.Quaternion.clone(n),this._drawNearPlane=s,this._vertexFormat=o,this._workerName="createFrustumGeometry",this.packedLength=2+a+F.Cartesian3.packedLength+P.Quaternion.packedLength+l.VertexFormat.packedLength}D.pack=function(t,e,a){a=M.defaultValue(a,0);var i=t._frustumType,n=t._frustum;return 0===(e[a++]=i)?(O.pack(n,e,a),a+=O.packedLength):(g.pack(n,e,a),a+=g.packedLength),F.Cartesian3.pack(t._origin,e,a),a+=F.Cartesian3.packedLength,P.Quaternion.pack(t._orientation,e,a),a+=P.Quaternion.packedLength,l.VertexFormat.pack(t._vertexFormat,e,a),e[a+=l.VertexFormat.packedLength]=t._drawNearPlane?1:0,e};var S=new O,A=new g,I=new P.Quaternion,q=new F.Cartesian3,B=new l.VertexFormat;function L(t,e,a,i,n,r,o,s){for(var f=t/3*2,u=0;u<4;++u)V.defined(e)&&(e[t]=r.x,e[t+1]=r.y,e[t+2]=r.z),V.defined(a)&&(a[t]=o.x,a[t+1]=o.y,a[t+2]=o.z),V.defined(i)&&(i[t]=s.x,i[t+1]=s.y,i[t+2]=s.z),t+=3;n[f]=0,n[1+f]=0,n[2+f]=1,n[3+f]=0,n[4+f]=1,n[5+f]=1,n[6+f]=0,n[7+f]=1}D.unpack=function(t,e,a){e=M.defaultValue(e,0);var i,n=t[e++];0===n?(i=O.unpack(t,e,S),e+=O.packedLength):(i=g.unpack(t,e,A),e+=g.packedLength);var r=F.Cartesian3.unpack(t,e,q);e+=F.Cartesian3.packedLength;var o=P.Quaternion.unpack(t,e,I);e+=P.Quaternion.packedLength;var s=l.VertexFormat.unpack(t,e,B),f=1===t[e+=l.VertexFormat.packedLength];if(!V.defined(a))return new D({frustum:i,origin:r,orientation:o,vertexFormat:s,_drawNearPlane:f});var u=n===a._frustumType?a._frustum:void 0;return a._frustum=i.clone(u),a._frustumType=n,a._origin=F.Cartesian3.clone(r,a._origin),a._orientation=P.Quaternion.clone(o,a._orientation),a._vertexFormat=l.VertexFormat.clone(s,a._vertexFormat),a._drawNearPlane=f,a};var N=new P.Matrix3,G=new P.Matrix4,U=new P.Matrix4,j=new F.Cartesian3,Q=new F.Cartesian3,K=new F.Cartesian3,W=new F.Cartesian3,Y=new F.Cartesian3,J=new F.Cartesian3,X=new Array(3),Z=new Array(4);Z[0]=new P.Cartesian4(-1,-1,1,1),Z[1]=new P.Cartesian4(1,-1,1,1),Z[2]=new P.Cartesian4(1,1,1,1),Z[3]=new P.Cartesian4(-1,1,1,1);for(var H=new Array(4),$=0;$<4;++$)H[$]=new P.Cartesian4;D._computeNearFarPlanes=function(t,e,a,i,n,r,o,s){var f=P.Matrix3.fromQuaternion(e,N),u=M.defaultValue(r,j),l=M.defaultValue(o,Q),h=M.defaultValue(s,K);u=P.Matrix3.getColumn(f,0,u),l=P.Matrix3.getColumn(f,1,l),h=P.Matrix3.getColumn(f,2,h),F.Cartesian3.normalize(u,u),F.Cartesian3.normalize(l,l),F.Cartesian3.normalize(h,h),F.Cartesian3.negate(u,u);var p,d,c=P.Matrix4.computeView(t,h,l,u,G);if(0===a){var m=i.projectionMatrix,C=P.Matrix4.multiply(m,c,U);d=P.Matrix4.inverse(C,U)}else p=P.Matrix4.inverseTransformation(c,U);V.defined(d)?(X[0]=i.near,X[1]=i.far):(X[0]=0,X[1]=i.near,X[2]=i.far);for(var _=0;_<2;++_)for(var y=0;y<4;++y){var g=P.Cartesian4.clone(Z[y],H[y]);if(V.defined(d)){var v=1/(g=P.Matrix4.multiplyByVector(d,g,g)).w;F.Cartesian3.multiplyByScalar(g,v,g),F.Cartesian3.subtract(g,t,g),F.Cartesian3.normalize(g,g);var w=F.Cartesian3.dot(h,g);F.Cartesian3.multiplyByScalar(g,X[_]/w,g),F.Cartesian3.add(g,t,g)}else{V.defined(i._offCenterFrustum)&&(i=i._offCenterFrustum);var x=X[_],b=X[_+1];g.x=.5*(g.x*(i.right-i.left)+i.left+i.right),g.y=.5*(g.y*(i.top-i.bottom)+i.bottom+i.top),g.z=.5*(g.z*(x-b)-x-b),g.w=1,P.Matrix4.multiplyByVector(p,g,g)}n[12*_+3*y]=g.x,n[12*_+3*y+1]=g.y,n[12*_+3*y+2]=g.z}},D.createGeometry=function(t){var e=t._frustumType,a=t._frustum,i=t._origin,n=t._orientation,r=t._drawNearPlane,o=t._vertexFormat,s=r?6:5,f=new Float64Array(72);D._computeNearFarPlanes(i,n,e,a,f);var u=24;f[u]=f[12],f[u+1]=f[13],f[u+2]=f[14],f[u+3]=f[0],f[u+4]=f[1],f[u+5]=f[2],f[u+6]=f[9],f[u+7]=f[10],f[u+8]=f[11],f[u+9]=f[21],f[u+10]=f[22],f[u+11]=f[23],f[u+=12]=f[15],f[u+1]=f[16],f[u+2]=f[17],f[u+3]=f[3],f[u+4]=f[4],f[u+5]=f[5],f[u+6]=f[0],f[u+7]=f[1],f[u+8]=f[2],f[u+9]=f[12],f[u+10]=f[13],f[u+11]=f[14],f[u+=12]=f[3],f[u+1]=f[4],f[u+2]=f[5],f[u+3]=f[15],f[u+4]=f[16],f[u+5]=f[17],f[u+6]=f[18],f[u+7]=f[19],f[u+8]=f[20],f[u+9]=f[6],f[u+10]=f[7],f[u+11]=f[8],f[u+=12]=f[6],f[u+1]=f[7],f[u+2]=f[8],f[u+3]=f[18],f[u+4]=f[19],f[u+5]=f[20],f[u+6]=f[21],f[u+7]=f[22],f[u+8]=f[23],f[u+9]=f[9],f[u+10]=f[10],f[u+11]=f[11],r||(f=f.subarray(12));var l=new R.GeometryAttributes({position:new k.GeometryAttribute({componentDatatype:E.ComponentDatatype.DOUBLE,componentsPerAttribute:3,values:f})});if(V.defined(o.normal)||V.defined(o.tangent)||V.defined(o.bitangent)||V.defined(o.st)){var h=V.defined(o.normal)?new Float32Array(12*s):void 0,p=V.defined(o.tangent)?new Float32Array(12*s):void 0,d=V.defined(o.bitangent)?new Float32Array(12*s):void 0,c=V.defined(o.st)?new Float32Array(8*s):void 0,m=j,C=Q,_=K,y=F.Cartesian3.negate(m,W),g=F.Cartesian3.negate(C,Y),v=F.Cartesian3.negate(_,J);u=0,r&&(L(u,h,p,d,c,v,m,C),u+=12),L(u,h,p,d,c,_,y,C),L(u+=12,h,p,d,c,y,v,C),L(u+=12,h,p,d,c,g,v,y),L(u+=12,h,p,d,c,m,_,C),L(u+=12,h,p,d,c,C,_,y),V.defined(h)&&(l.normal=new k.GeometryAttribute({componentDatatype:E.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:h})),V.defined(p)&&(l.tangent=new k.GeometryAttribute({componentDatatype:E.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:p})),V.defined(d)&&(l.bitangent=new k.GeometryAttribute({componentDatatype:E.ComponentDatatype.FLOAT,componentsPerAttribute:3,values:d})),V.defined(c)&&(l.st=new k.GeometryAttribute({componentDatatype:E.ComponentDatatype.FLOAT,componentsPerAttribute:2,values:c}))}for(var w=new Uint16Array(6*s),x=0;x<s;++x){var b=6*x,M=4*x;w[b]=M,w[1+b]=1+M,w[2+b]=2+M,w[3+b]=M,w[4+b]=2+M,w[5+b]=3+M}return new k.Geometry({attributes:l,indices:w,primitiveType:k.PrimitiveType.TRIANGLES,boundingSphere:P.BoundingSphere.fromVertices(f)})},t.FrustumGeometry=D,t.OrthographicFrustum=g,t.PerspectiveFrustum=O});
