/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

public final class StringUtil {
    private static final String NAME_SEPARATOR = ".";
    private static final String PROPERTY_PREFIX_GET = "get";
    private static final String PROPERTY_PREFIX_IS = "is";
    private static final String PROPERTY_PREFIX_HAS = "has";

    private StringUtil() {
    }

    public static String determineFullyQualifiedClassName(String defaultPackage, String name) {
        if (StringUtil.isFullyQualified(name)) {
            return name;
        }
        return defaultPackage + NAME_SEPARATOR + name;
    }

    public static boolean isFullyQualified(String name) {
        return name.contains(NAME_SEPARATOR);
    }

    public static String packageNameFromFqcn(String fqcn) {
        return fqcn.substring(0, fqcn.lastIndexOf(NAME_SEPARATOR));
    }

    public static String classNameFromFqcn(String fqcn) {
        return fqcn.substring(fqcn.lastIndexOf(NAME_SEPARATOR) + 1);
    }

    public static boolean isPropertyName(String name) {
        if (name == null) {
            return false;
        }
        return StringUtil.checkPropertyName(name, PROPERTY_PREFIX_GET) || StringUtil.checkPropertyName(name, PROPERTY_PREFIX_IS) || StringUtil.checkPropertyName(name, PROPERTY_PREFIX_HAS);
    }

    private static boolean checkPropertyName(String name, String prefix) {
        if (!name.startsWith(prefix)) {
            return false;
        }
        if (name.length() < prefix.length() + 1) {
            return false;
        }
        return Character.isUpperCase(name.charAt(prefix.length()));
    }

    public static String getPropertyName(String name) {
        if (!StringUtil.isPropertyName(name)) {
            return null;
        }
        String tmp = name;
        if (name.startsWith(PROPERTY_PREFIX_GET)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_GET, "");
        } else if (name.startsWith(PROPERTY_PREFIX_IS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_IS, "");
        } else if (name.startsWith(PROPERTY_PREFIX_HAS)) {
            tmp = name.replaceFirst(PROPERTY_PREFIX_HAS, "");
        }
        return tmp.substring(0, 1).toLowerCase() + tmp.substring(1);
    }
}

