/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

public final class HostedZone {
    private final String id;
    private final String name;
    private final String callerReference;
    private final int resourceRecordSetCount;
    private final Optional<String> comment;

    private HostedZone(String id, String name, String callerReference, int resourceRecordSetCount, Optional<String> comment) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.callerReference = (String)Preconditions.checkNotNull((Object)callerReference, (String)"callerReference for %s", (Object[])new Object[]{name});
        this.resourceRecordSetCount = resourceRecordSetCount;
        this.comment = (Optional)Preconditions.checkNotNull(comment, (String)"comment for %s", (Object[])new Object[]{name});
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public int getResourceRecordSetCount() {
        return this.resourceRecordSetCount;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.callerReference});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostedZone that = (HostedZone)HostedZone.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.callerReference, (Object)that.callerReference);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("callerReference", (Object)this.callerReference).add("resourceRecordSetCount", this.resourceRecordSetCount).add("comment", this.comment.orNull()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return HostedZone.builder().from(this);
    }

    public static final class Builder {
        private String id;
        private String name;
        private String callerReference;
        private int resourceRecordSetCount;
        private Optional<String> comment = Optional.absent();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public Builder resourceRecordSetCount(int resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = Optional.fromNullable((Object)comment);
            return this;
        }

        public HostedZone build() {
            return new HostedZone(this.id, this.name, this.callerReference, this.resourceRecordSetCount, this.comment);
        }

        public Builder from(HostedZone in) {
            return this.id(in.id).name(in.name).callerReference(in.callerReference).resourceRecordSetCount(in.resourceRecordSetCount).comment((String)in.comment.orNull());
        }
    }
}

