/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.route53.domain.ResourceRecordSet;

public class ChangeBatch
extends ForwardingList<ActionOnResourceRecordSet> {
    private final Optional<String> comment;
    private final List<ActionOnResourceRecordSet> changes;

    public static ChangeBatch createAll(Iterable<ResourceRecordSet> toCreate) {
        return ChangeBatch.builder().createAll(toCreate).build();
    }

    public static ChangeBatch deleteAll(Iterable<ResourceRecordSet> toDelete) {
        return ChangeBatch.builder().deleteAll(toDelete).build();
    }

    private ChangeBatch(Optional<String> comment, ImmutableList<ActionOnResourceRecordSet> changes) {
        this.comment = (Optional)Preconditions.checkNotNull(comment, (Object)"comment");
        this.changes = (List)Preconditions.checkNotNull(changes, (String)"changes%s", (Object[])new Object[]{comment.isPresent() ? " for %s " + (String)comment.get() : ""});
        Preconditions.checkArgument((!changes.isEmpty() ? 1 : 0) != 0, (String)"no changes%s", (Object[])new Object[]{comment.isPresent() ? " for %s " + (String)comment.get() : ""});
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    protected List<ActionOnResourceRecordSet> delegate() {
        return this.changes;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.comment, this.changes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChangeBatch that = (ChangeBatch)((Object)ChangeBatch.class.cast(obj));
        return Objects.equal(this.comment, that.comment) && Objects.equal(this.changes, that.changes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").omitNullValues().add("comment", this.comment.orNull()).add("changes", this.changes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> comment = Optional.absent();
        private ImmutableList.Builder<ActionOnResourceRecordSet> changes = ImmutableList.builder();

        public Builder comment(String comment) {
            this.comment = Optional.fromNullable((Object)comment);
            return this;
        }

        public Builder create(ResourceRecordSet rrs) {
            this.changes.add((Object)new ActionOnResourceRecordSet(Action.CREATE, rrs));
            return this;
        }

        public Builder createAll(Iterable<ResourceRecordSet> toCreate) {
            for (ResourceRecordSet rrs : toCreate) {
                this.create(rrs);
            }
            return this;
        }

        public Builder delete(ResourceRecordSet rrs) {
            this.changes.add((Object)new ActionOnResourceRecordSet(Action.DELETE, rrs));
            return this;
        }

        public Builder deleteAll(Iterable<ResourceRecordSet> toDelete) {
            for (ResourceRecordSet rrs : toDelete) {
                this.delete(rrs);
            }
            return this;
        }

        public ChangeBatch build() {
            return new ChangeBatch(this.comment, this.changes.build());
        }
    }

    public static class ActionOnResourceRecordSet {
        private final Action action;
        private final ResourceRecordSet rrs;

        private ActionOnResourceRecordSet(Action action, ResourceRecordSet rrs) {
            this.action = action;
            this.rrs = rrs;
        }

        public Action getAction() {
            return this.action;
        }

        public ResourceRecordSet getRRS() {
            return this.rrs;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.action, this.rrs});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ActionOnResourceRecordSet that = (ActionOnResourceRecordSet)ActionOnResourceRecordSet.class.cast(obj);
            return Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal((Object)this.rrs, (Object)that.rrs);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").omitNullValues().add("action", (Object)this.action).add("rrs", (Object)this.rrs).toString();
        }
    }

    public static enum Action {
        CREATE,
        DELETE;

    }
}

